/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.impl.animation;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.animation.IBendHelper;
import net.minecraft.client.model.geom.ModelPart;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AnimationApplier
extends AnimationProcessor {
    public AnimationApplier(IAnimation animation) {
        super(animation);
    }

    public void updatePart(String partName, ModelPart part) {
        Vec3f pos = this.get3DTransform(partName, TransformType.POSITION, new Vec3f(part.f_104200_, part.f_104201_, part.f_104202_));
        part.f_104200_ = ((Float)pos.getX()).floatValue();
        part.f_104201_ = ((Float)pos.getY()).floatValue();
        part.f_104202_ = ((Float)pos.getZ()).floatValue();
        Vec3f rot = this.get3DTransform(partName, TransformType.ROTATION, new Vec3f(MathHelper.clampToRadian(part.f_104203_), MathHelper.clampToRadian(part.f_104204_), MathHelper.clampToRadian(part.f_104205_)));
        part.m_171327_(((Float)rot.getX()).floatValue(), ((Float)rot.getY()).floatValue(), ((Float)rot.getZ()).floatValue());
        if (!partName.equals("head")) {
            if (partName.equals("torso")) {
                Pair<Float, Float> torsoBend = this.getBend(partName);
                Pair<Float, Float> bodyBend = this.getBend("body");
                IBendHelper.INSTANCE.bend(part, new Pair<Float, Float>(Float.valueOf(torsoBend.getLeft().floatValue() + bodyBend.getLeft().floatValue()), Float.valueOf(torsoBend.getRight().floatValue() + bodyBend.getRight().floatValue())));
            } else {
                IBendHelper.INSTANCE.bend(part, this.getBend(partName));
            }
        }
    }
}

