/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import me.xjqsh.lrtactical.network.NetworkHandler;
import me.xjqsh.lrtactical.network.message.SShakeScreenMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class CustomExplosion
extends Explosion {
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final double damage;
    private int fireTime;
    private float damageMultiplier;
    private double screenShakeTime = 20.0;
    private double screenShakeAmplitude = 50.0;

    public CustomExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator pDamageCalculator, double damage, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, Explosion.BlockInteraction pBlockInteraction) {
        super(pLevel, pSource, source, null, pToBlowX, pToBlowY, pToBlowZ, pRadius, false, pBlockInteraction);
        this.level = pLevel;
        this.source = pSource;
        this.radius = pRadius;
        this.damageSource = source == null ? pLevel.m_269111_().m_269093_((Explosion)this) : source;
        this.damageCalculator = pDamageCalculator == null ? new ExplosionDamageCalculator() : pDamageCalculator;
        this.x = pToBlowX;
        this.y = pToBlowY;
        this.z = pToBlowZ;
        this.damage = damage;
    }

    public CustomExplosion(Level pLevel, @NotNull Entity pSource, double damage, float pRadius, Explosion.BlockInteraction pBlockInteraction) {
        this(pLevel, pSource, null, null, damage, pSource.m_20185_(), pSource.m_20186_(), pSource.m_20189_(), pRadius, pBlockInteraction);
    }

    public CustomExplosion setFireTime(int fireTime) {
        this.fireTime = fireTime;
        return this;
    }

    public CustomExplosion setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
        return this;
    }

    public void setScreenShakeTime(double screenShakeTime) {
        this.screenShakeTime = screenShakeTime;
    }

    public void setScreenShakeAmplitude(double screenShakeAmplitude) {
        this.screenShakeAmplitude = screenShakeAmplitude;
    }

    public void m_46061_() {
        if (!this.level.m_5776_()) {
            NetworkHandler.sendToNearbyPlayers(new SShakeScreenMessage(this.screenShakeTime, this.radius * 2.0f, this.screenShakeAmplitude, this.getPosition()), this.level, this.getPosition(), this.radius * 2.0f);
        }
        this.level.m_220400_(this.source, GameEvent.f_157812_, new Vec3(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    for (float f = this.radius * (0.4f + this.level.f_46441_.m_188501_() * 0.3f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.m_274561_((double)d4, (double)d6, (double)d8);
                        BlockState blockstate = this.level.m_8055_(blockpos);
                        FluidState fluidstate = this.level.m_6425_(blockpos);
                        if (!this.level.m_46739_(blockpos)) continue block2;
                        Optional optional = this.damageCalculator.m_6617_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 1.0f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.m_6714_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.m_46081_().addAll(set);
        float diameter = this.radius * 2.0f;
        int x0 = Mth.m_14107_((double)(this.x - (double)diameter - 1.0));
        int x1 = Mth.m_14107_((double)(this.x + (double)diameter + 1.0));
        int y0 = Mth.m_14107_((double)(this.y - (double)diameter - 1.0));
        int y1 = Mth.m_14107_((double)(this.y + (double)diameter + 1.0));
        int z0 = Mth.m_14107_((double)(this.z - (double)diameter - 1.0));
        int z1 = Mth.m_14107_((double)(this.z + (double)diameter + 1.0));
        List list = this.level.m_45933_(this.source, new AABB((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)diameter);
        Vec3 position = new Vec3(this.x, this.y, this.z);
        for (Entity entity : list) {
            double zDistance;
            double yDistance;
            double xDistance;
            double distance;
            double distanceRate;
            if (entity.m_6128_() || !((distanceRate = Math.sqrt(entity.m_20238_(position)) / (double)diameter) <= 1.0) || (distance = Math.sqrt((xDistance = entity.m_20185_() - this.x) * xDistance + (yDistance = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * yDistance + (zDistance = entity.m_20189_() - this.z) * zDistance)) == 0.0) continue;
            double seenPercent = Mth.m_14008_((double)CustomExplosion.m_46064_((Vec3)position, (Entity)entity), (double)0.01, (double)Double.POSITIVE_INFINITY);
            double damagePercent = (1.0 - distanceRate) * seenPercent;
            double damageFinal = (damagePercent * damagePercent + damagePercent) * this.damage / 2.0;
            if (entity instanceof Monster) {
                Monster monster = (Monster)entity;
                monster.m_6469_(this.damageSource, (float)damageFinal * (1.0f + 0.2f * this.damageMultiplier));
            } else {
                entity.m_6469_(this.damageSource, (float)damageFinal);
            }
            if (this.fireTime <= 0) continue;
            entity.m_20254_(this.fireTime);
        }
    }
}

