/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.resource;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import me.xjqsh.lrtactical.api.collision.ITargetFilter;
import me.xjqsh.lrtactical.item.index.MeleeWeaponIndex;
import me.xjqsh.lrtactical.item.index.ThrowableIndex;
import me.xjqsh.lrtactical.item.melee.AttributeData;
import me.xjqsh.lrtactical.item.melee.CombatData;
import me.xjqsh.lrtactical.item.throwable.area.EffectCloudThrowableData;
import me.xjqsh.lrtactical.network.DataType;
import me.xjqsh.lrtactical.network.NetworkHandler;
import me.xjqsh.lrtactical.network.message.SPackSyncMessage;
import me.xjqsh.lrtactical.resource.CommonNetworkCache;
import me.xjqsh.lrtactical.resource.ICommonResourceProvider;
import me.xjqsh.lrtactical.resource.manager.MeleeIndexManager;
import me.xjqsh.lrtactical.resource.manager.ThrowableIndexManager;
import me.xjqsh.lrtactical.resource.serializer.ParticleOptionsDeserializer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommonAssetsManager
implements ICommonResourceProvider {
    public static CommonAssetsManager INSTANCE;
    public static Gson GSON;
    public ThrowableIndexManager throwableIndexManager;
    public MeleeIndexManager meleeIndexManager;

    private CommonAssetsManager() {
    }

    public static ICommonResourceProvider get() {
        return INSTANCE == null ? CommonNetworkCache.INSTANCE : INSTANCE;
    }

    private void reloadAndRegister(Consumer<PreparableReloadListener> register) {
        this.throwableIndexManager = new ThrowableIndexManager(GSON);
        this.meleeIndexManager = new MeleeIndexManager(GSON);
        register.accept((PreparableReloadListener)this.throwableIndexManager);
        register.accept((PreparableReloadListener)this.meleeIndexManager);
    }

    public Map<DataType, Map<ResourceLocation, String>> toNetwork() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)DataType.THROWABLE_INDEX, this.throwableIndexManager.getCache());
        builder.put((Object)DataType.MELEE_INDEX, this.meleeIndexManager.getCache());
        return builder.build();
    }

    @Override
    public ThrowableIndex<?, ?> getThrowableIndex(ResourceLocation id) {
        return (ThrowableIndex)this.throwableIndexManager.getData(id);
    }

    @Override
    public Collection<ThrowableIndex<?, ?>> getThrowableIndexes() {
        return this.throwableIndexManager.getAllData().values();
    }

    @Override
    public MeleeWeaponIndex<?> getMeleeIndex(ResourceLocation id) {
        return (MeleeWeaponIndex)this.meleeIndexManager.getData(id);
    }

    @Override
    public Collection<MeleeWeaponIndex<?>> getMeleeIndexes() {
        return this.meleeIndexManager.getAllData().values();
    }

    @SubscribeEvent
    public static void onReload(AddReloadListenerEvent event) {
        CommonAssetsManager commonAssetsManager = new CommonAssetsManager();
        commonAssetsManager.reloadAndRegister(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
        INSTANCE = commonAssetsManager;
    }

    @SubscribeEvent
    public static void OnDatapackSync(OnDatapackSyncEvent event) {
        if (INSTANCE == null) {
            return;
        }
        SPackSyncMessage msg = new SPackSyncMessage(INSTANCE.toNetwork());
        if (event.getPlayer() != null) {
            NetworkHandler.sendToClientPlayer(msg, (Player)event.getPlayer());
        } else {
            event.getPlayerList().m_11314_().forEach(player -> NetworkHandler.sendToClientPlayer(msg, (Player)player));
        }
    }

    static {
        GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(CombatData.class, (Object)new CombatData.Deserializer()).registerTypeAdapter(ITargetFilter.class, (Object)new ITargetFilter.Deserializer()).registerTypeAdapter(AttributeData.class, (Object)new AttributeData.Deserializer()).registerTypeAdapter(ParticleOptions.class, (Object)new ParticleOptionsDeserializer()).registerTypeAdapter(EffectCloudThrowableData.EffectData.class, (Object)new EffectCloudThrowableData.EffectDataDeSerializer()).create();
    }
}

