/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.item.melee;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import me.xjqsh.lrtactical.api.collision.ConeFilter;
import me.xjqsh.lrtactical.api.collision.ITargetFilter;
import me.xjqsh.lrtactical.api.melee.MeleeAction;
import org.jetbrains.annotations.Nullable;

public class CombatData {
    public static ITargetFilter DEFAULT_HITBOX = new ConeFilter(3.5, 60.0);
    public EnumMap<MeleeAction, List<MeleeAttackInfo>> attackInfo = new EnumMap(MeleeAction.class);

    @Nullable
    public MeleeAttackInfo getAttackInfo(MeleeAction action) {
        return this.getAttackInfo(action, 0);
    }

    @Nullable
    public MeleeAttackInfo getAttackInfo(MeleeAction action, int index) {
        List<MeleeAttackInfo> attackInfos = this.attackInfo.get((Object)action);
        if (attackInfos != null && index < attackInfos.size()) {
            return attackInfos.get(index);
        }
        return null;
    }

    public static class MeleeAttackInfo {
        @SerializedName(value="factor")
        private float factor = 1.0f;
        @SerializedName(value="knockback")
        private float knockback = 0.02f;
        @SerializedName(value="cooldown")
        private int cooldown = 20;
        @SerializedName(value="delay")
        private int delay = 0;
        @SerializedName(value="hitbox")
        private ITargetFilter hitbox = DEFAULT_HITBOX;
        @SerializedName(value="durability_damage")
        private int durabilityDamage = 1;
        @SerializedName(value="movement")
        private MeleeMovement movement = null;

        public float getFactor() {
            return this.factor;
        }

        public float getKnockback() {
            return this.knockback;
        }

        public int getCooldown() {
            return this.cooldown;
        }

        public int getDelay() {
            return this.delay;
        }

        public ITargetFilter getHitbox() {
            return this.hitbox;
        }

        public int getDurabilityDamage() {
            return this.durabilityDamage;
        }

        @Nullable
        public MeleeMovement getMovement() {
            return this.movement;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<CombatData> {
        public CombatData deserialize(JsonElement element, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Expected a JsonObject, get " + element);
            }
            JsonObject jsonObject = (JsonObject)element;
            CombatData combatData = new CombatData();
            for (MeleeAction action : MeleeAction.values()) {
                ArrayList<MeleeAttackInfo> attackInfos = new ArrayList<MeleeAttackInfo>();
                if (jsonObject.has(action.getId())) {
                    JsonElement actionElement = jsonObject.get(action.getId());
                    this.parseAttackInfo(ctx, action, actionElement, attackInfos);
                }
                if (attackInfos.isEmpty()) continue;
                combatData.attackInfo.put(action, attackInfos);
            }
            return combatData;
        }

        private void parseAttackInfo(JsonDeserializationContext ctx, MeleeAction action, JsonElement actionElement, List<MeleeAttackInfo> attackInfos) throws JsonParseException {
            if (actionElement.isJsonArray()) {
                JsonArray actionArray = actionElement.getAsJsonArray();
                for (JsonElement ele : actionArray) {
                    MeleeAttackInfo attk = (MeleeAttackInfo)ctx.deserialize(ele, MeleeAttackInfo.class);
                    if (attk == null) continue;
                    attackInfos.add(attk);
                }
            } else if (actionElement.isJsonObject()) {
                MeleeAttackInfo attk = (MeleeAttackInfo)ctx.deserialize(actionElement, MeleeAttackInfo.class);
                if (attk != null) {
                    attackInfos.add(attk);
                }
            } else {
                throw new JsonParseException("Expected a JsonArray or JsonObject for action " + action.getId() + ", get " + actionElement);
            }
        }
    }

    public static class MeleeMovement {
        @SerializedName(value="delay")
        private int delay = 0;
        @SerializedName(value="speed")
        private float speed = 0.5f;

        public int getDelay() {
            return this.delay;
        }

        public float getSpeed() {
            return this.speed;
        }
    }
}

