/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.item.index;

import com.google.gson.JsonElement;
import me.xjqsh.lrtactical.api.index.ICustomItemIndex;
import me.xjqsh.lrtactical.api.item.IThrowable;
import me.xjqsh.lrtactical.entity.ThrowableItemEntity;
import me.xjqsh.lrtactical.item.throwable.ThrowableData;
import me.xjqsh.lrtactical.item.throwable.ThrowableType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowableIndex<T extends ThrowableData, E extends ThrowableItemEntity>
implements ICustomItemIndex {
    private final ThrowableType<T, E> type;
    private final Item baseItem;
    private final T data;
    private final ResourceLocation id;
    private final String name;

    private ThrowableIndex(@NotNull ThrowableType<T, E> type, T data, String name, ResourceLocation id, Item baseItem) {
        this.type = type;
        this.data = data;
        this.id = id;
        this.baseItem = baseItem;
        this.name = name;
    }

    @Nullable
    public static <T extends ThrowableData, E extends ThrowableItemEntity> ThrowableIndex<T, E> deserialize(@NotNull ThrowableType<T, E> type, JsonElement data, String name, ResourceLocation id, Item baseItem) {
        T throwableData = type.serializer().parse(data);
        if (throwableData == null) {
            return null;
        }
        return new ThrowableIndex<T, E>(type, throwableData, name, id, baseItem);
    }

    public T getData() {
        return this.data;
    }

    @Override
    public int getMaxStackSize() {
        return ((ThrowableData)this.data).getStackSize();
    }

    public ThrowableType<T, E> getType() {
        return this.type;
    }

    @Override
    public String getDescriptionId() {
        return this.name;
    }

    public E createEntity(ItemStack stack, LivingEntity thrower) {
        return this.type.factory().create(stack, thrower, this.data);
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Item getBaseItem() {
        return this.baseItem;
    }

    @Override
    public ItemStack createItemStack() {
        ItemStack stack = new ItemStack((ItemLike)this.baseItem);
        Item item = stack.m_41720_();
        if (item instanceof IThrowable) {
            IThrowable iThrowable = (IThrowable)item;
            iThrowable.setId(stack, this.getId());
        }
        return stack;
    }
}

