/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.api.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.xjqsh.lrtactical.api.LrTacticalAPI;
import me.xjqsh.lrtactical.api.item.ICustomItem;
import me.xjqsh.lrtactical.api.melee.AttackResult;
import me.xjqsh.lrtactical.api.melee.MeleeAction;
import me.xjqsh.lrtactical.config.CommonConfig;
import me.xjqsh.lrtactical.item.index.MeleeWeaponIndex;
import me.xjqsh.lrtactical.item.melee.CombatData;
import me.xjqsh.lrtactical.network.NetworkHandler;
import me.xjqsh.lrtactical.network.message.SCustomSound;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public interface IMeleeWeapon
extends ICustomItem {
    public static final String ID_TAG = "MeleeWeaponId";
    public static final String OVERRIDE_DISPLAY_ID = "DisplayId";
    public static final ResourceLocation EMPTY = new ResourceLocation("lrtactical", "empty");

    public static IMeleeWeapon of(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IMeleeWeapon) {
            IMeleeWeapon item2 = (IMeleeWeapon)item;
            return item2;
        }
        return null;
    }

    @Override
    default public ResourceLocation getId(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128425_(ID_TAG, 8)) {
            ResourceLocation rl = ResourceLocation.m_135820_((String)nbt.m_128461_(ID_TAG));
            return Objects.requireNonNullElse(rl, EMPTY);
        }
        return EMPTY;
    }

    @Override
    default public ResourceLocation getDisplayId(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128425_(OVERRIDE_DISPLAY_ID, 8)) {
            ResourceLocation rl = ResourceLocation.m_135820_((String)nbt.m_128461_(OVERRIDE_DISPLAY_ID));
            return Objects.requireNonNullElse(rl, EMPTY);
        }
        return this.getId(stack);
    }

    @Override
    default public void setId(ItemStack stack, ResourceLocation id) {
        stack.m_41784_().m_128359_(ID_TAG, id.toString());
    }

    @Override
    default public boolean shouldBlockAttack() {
        return true;
    }

    @Override
    default public boolean shouldBlockUse() {
        return true;
    }

    default public int getAttackDelay(Player attacker, ItemStack stack, MeleeAction action) {
        return 0;
    }

    @Nullable
    default public CombatData.MeleeMovement getAttackMovement(Player entity, ItemStack stack, MeleeAction action) {
        return null;
    }

    default public boolean canAttack(Player attacker, ItemStack stack, MeleeAction action) {
        return true;
    }

    default public Optional<MeleeWeaponIndex<?>> getMeleeIndex(ItemStack stack) {
        return LrTacticalAPI.getMeleeIndex(stack);
    }

    public List<Entity> collectTargets(Player var1, ItemStack var2, MeleeAction var3, Vec3 var4, Vec3 var5);

    public void attack(Player var1, ItemStack var2, MeleeAction var3, List<Entity> var4);

    @Deprecated
    default public void attack(Player attacker, ItemStack stack, MeleeAction action, Vec3 origin, Vec3 direction) {
    }

    default public AttackResult performAttack(Player attacker, Entity target, ItemStack stack, float base, float knockback) {
        boolean result;
        float modifier;
        if (!ForgeHooks.onPlayerAttackTarget((Player)attacker, (Entity)target)) {
            return AttackResult.MISS;
        }
        if (!target.m_6097_()) {
            return AttackResult.MISS;
        }
        if (target.m_7313_((Entity)attacker)) {
            return AttackResult.MISS;
        }
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            modifier = EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)living.m_6336_());
        } else {
            modifier = EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
        }
        boolean flag2 = attacker.f_19789_ > 0.0f && !attacker.m_20096_() && !attacker.m_6147_() && !attacker.m_20069_() && !attacker.m_21023_(MobEffects.f_19610_) && !attacker.m_20159_() && target instanceof LivingEntity;
        CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)attacker, (Entity)target, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
        if (hitResult != null) {
            base *= hitResult.getDamageModifier();
            flag2 = true;
        }
        int j = EnchantmentHelper.m_44914_((LivingEntity)attacker);
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            if (j > 0) {
                living.m_20254_(j * 4);
            }
        }
        if (target.f_19802_ < (Integer)CommonConfig.MELEE_IGNORE_INVULNERABLE_TICK_THRESHOLD.get()) {
            target.f_19802_ = 0;
        }
        if (!(result = target.m_6469_(attacker.m_269291_().m_269075_(attacker), base + modifier))) {
            return AttackResult.MISS;
        }
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_147240_((double)knockback, (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
            EnchantmentHelper.m_44823_((LivingEntity)living, (Entity)attacker);
        }
        EnchantmentHelper.m_44896_((LivingEntity)attacker, (Entity)target);
        if (flag2) {
            attacker.m_5704_(target);
        }
        return flag2 ? AttackResult.CRIT : AttackResult.HIT;
    }

    public static void playMeleeSound(Player entity, ResourceLocation id, String key, float volume, float pitch) {
        IMeleeWeapon.playMeleeSound(entity, id, key, volume, pitch, false);
    }

    public static void playMeleeSound(Player entity, ResourceLocation id, String key, float volume, float pitch, boolean exceptSelf) {
        ServerPlayer player;
        SCustomSound packet = new SCustomSound(SCustomSound.SoundType.MELEE, id, key, entity.m_20182_(), volume, pitch);
        ServerPlayer p = exceptSelf && entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null;
        NetworkHandler.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(p, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 64.0, entity.m_9236_().m_46472_())), (Object)packet);
    }

    default public boolean canSprintingAttack() {
        return true;
    }

    @Override
    default public boolean isSame(ItemStack i, ItemStack j) {
        IMeleeWeapon w1 = IMeleeWeapon.of(i);
        IMeleeWeapon w2 = IMeleeWeapon.of(j);
        if (w1 != null && w2 != null) {
            return w1.getId(i).equals((Object)w2.getId(j));
        }
        if (i.m_41619_() || j.m_41619_()) {
            return i.m_41619_() && j.m_41619_();
        }
        return false;
    }
}

