/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsarmor.client;

import com.google.common.collect.ImmutableList;
import me.xjqsh.lesraisinsarmor.client.resource.ArmorRenderConfigManager;
import me.xjqsh.lesraisinsarmor.client.resource.data.ArmorPartRenderConfig;
import me.xjqsh.lesraisinsarmor.client.resource.data.ArmorRenderConfig;
import me.xjqsh.lesraisinsarmor.client.resource.data.PlayerModelPart;
import me.xjqsh.lesraisinsarmor.item.LrArmorItem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientHandler {
    @SubscribeEvent
    public static void onRenderEntity(RenderLivingEvent.Pre<?, ?> event) {
        LivingEntity living = event.getEntity();
        EntityModel model = event.getRenderer().m_7200_();
        if (model instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)model;
            ClientHandler.resolveVisibleParts(living, EquipmentSlot.HEAD, playerModel);
            ClientHandler.resolveVisibleParts(living, EquipmentSlot.CHEST, playerModel);
            ClientHandler.resolveVisibleParts(living, EquipmentSlot.LEGS, playerModel);
            ClientHandler.resolveVisibleParts(living, EquipmentSlot.FEET, playerModel);
        } else if (model instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            ClientHandler.resolveVisibleParts(living, EquipmentSlot.HEAD, humanoidModel);
            ClientHandler.resolveVisibleParts(living, EquipmentSlot.CHEST, humanoidModel);
            ClientHandler.resolveVisibleParts(living, EquipmentSlot.LEGS, humanoidModel);
            ClientHandler.resolveVisibleParts(living, EquipmentSlot.FEET, humanoidModel);
        }
    }

    @SubscribeEvent
    public static void onRenderEntity(RenderLivingEvent.Post<?, ?> event) {
        EntityModel model = event.getRenderer().m_7200_();
        if (model instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)model;
            ClientHandler.playerBodyParts(playerModel).forEach(part -> {
                if (part != null) {
                    part.f_104207_ = true;
                }
            });
        } else if (model instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            ClientHandler.bodyParts(humanoidModel).forEach(part -> {
                if (part != null) {
                    part.f_104207_ = true;
                }
            });
        }
    }

    private static Iterable<ModelPart> playerBodyParts(PlayerModel<?> playerModel) {
        return ImmutableList.of((Object)playerModel.f_102810_, (Object)playerModel.f_102811_, (Object)playerModel.f_102812_, (Object)playerModel.f_102813_, (Object)playerModel.f_102814_, (Object)playerModel.f_102808_, (Object)playerModel.f_102809_, (Object)playerModel.f_103378_, (Object)playerModel.f_103375_, (Object)playerModel.f_103374_, (Object)playerModel.f_103377_, (Object)playerModel.f_103376_, (Object[])new ModelPart[0]);
    }

    private static Iterable<ModelPart> bodyParts(HumanoidModel<?> humanoidModel) {
        return ImmutableList.of((Object)humanoidModel.f_102810_, (Object)humanoidModel.f_102811_, (Object)humanoidModel.f_102812_, (Object)humanoidModel.f_102813_, (Object)humanoidModel.f_102814_, (Object)humanoidModel.f_102808_, (Object)humanoidModel.f_102809_);
    }

    public static void resolveVisibleParts(LivingEntity living, EquipmentSlot slot, HumanoidModel<?> model) {
        Item item = living.m_6844_(slot).m_41720_();
        if (item instanceof LrArmorItem) {
            LrArmorItem lrArmor = (LrArmorItem)item;
            ArmorRenderConfig config = ClientHandler.getConfig(lrArmor);
            if (config == null) {
                return;
            }
            switch (slot) {
                case HEAD: {
                    ClientHandler.setVisibility(config.helmet, model);
                    break;
                }
                case CHEST: {
                    ClientHandler.setVisibility(config.chestplate, model);
                    break;
                }
                case LEGS: {
                    ClientHandler.setVisibility(config.leggings, model);
                    break;
                }
                case FEET: {
                    ClientHandler.setVisibility(config.boots, model);
                }
            }
        }
    }

    private static void setVisibility(ArmorPartRenderConfig config, HumanoidModel<?> model) {
        if (config == null) {
            return;
        }
        for (PlayerModelPart part : config.hideParts) {
            switch (part) {
                case HEAD: {
                    model.f_102808_.f_104207_ = false;
                    break;
                }
                case HAT: {
                    model.f_102809_.f_104207_ = false;
                    break;
                }
                case BODY: {
                    model.f_102810_.f_104207_ = false;
                    break;
                }
                case RIGHT_ARM: {
                    model.f_102811_.f_104207_ = false;
                    break;
                }
                case LEFT_ARM: {
                    model.f_102812_.f_104207_ = false;
                    break;
                }
                case RIGHT_LEG: {
                    model.f_102813_.f_104207_ = false;
                    break;
                }
                case LEFT_LEG: {
                    model.f_102814_.f_104207_ = false;
                }
            }
        }
    }

    public static void resolveVisibleParts(LivingEntity player, EquipmentSlot slot, PlayerModel<?> model) {
        Item item = player.m_6844_(slot).m_41720_();
        if (item instanceof LrArmorItem) {
            LrArmorItem lrArmor = (LrArmorItem)item;
            ArmorRenderConfig config = ClientHandler.getConfig(lrArmor);
            if (config == null) {
                return;
            }
            switch (slot) {
                case HEAD: {
                    ClientHandler.setVisibility(config.helmet, model);
                    break;
                }
                case CHEST: {
                    ClientHandler.setVisibility(config.chestplate, model);
                    break;
                }
                case LEGS: {
                    ClientHandler.setVisibility(config.leggings, model);
                    break;
                }
                case FEET: {
                    ClientHandler.setVisibility(config.boots, model);
                }
            }
        }
    }

    private static void setVisibility(ArmorPartRenderConfig config, PlayerModel<?> model) {
        if (config == null) {
            return;
        }
        for (PlayerModelPart part : config.hideParts) {
            switch (part) {
                case HEAD: {
                    model.f_102808_.f_104207_ = false;
                    break;
                }
                case HAT: {
                    model.f_102809_.f_104207_ = false;
                    break;
                }
                case BODY: {
                    model.f_102810_.f_104207_ = false;
                    break;
                }
                case JACKET: {
                    model.f_103378_.f_104207_ = false;
                    break;
                }
                case RIGHT_ARM: {
                    model.f_102811_.f_104207_ = false;
                    break;
                }
                case RIGHT_SLEEVE: {
                    model.f_103375_.f_104207_ = false;
                    break;
                }
                case LEFT_ARM: {
                    model.f_102812_.f_104207_ = false;
                    break;
                }
                case LEFT_SLEEVE: {
                    model.f_103374_.f_104207_ = false;
                    break;
                }
                case RIGHT_LEG: {
                    model.f_102813_.f_104207_ = false;
                    break;
                }
                case RIGHT_PANTS: {
                    model.f_103377_.f_104207_ = false;
                    break;
                }
                case LEFT_LEG: {
                    model.f_102814_.f_104207_ = false;
                    break;
                }
                case LEFT_PANTS: {
                    model.f_103376_.f_104207_ = false;
                }
            }
        }
    }

    private static ArmorRenderConfig getConfig(LrArmorItem lrArmor) {
        return ArmorRenderConfigManager.getInstance().getConfig(ResourceLocation.m_214293_((String)"lrarmor", (String)lrArmor.getSuitIdf()));
    }
}

