/*
 * Decompiled with CFR 0.152.
 */
package net.felinamods.iglib.utils;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class GunUtilsClient {
    private static final Set<String> IGNORED_ENTITIES = Set.of("minecraft:armor_stand");
    private static final Set<String> HARD_ENTITIES = Set.of("minecraft:iron_golem");

    public static void shootBullet(Level world, Entity shooter, double maxDistance, float baseDamage, boolean piercing, int pierceLimit, double falloffStart, double falloffEnd, float minMultiplier, Vec3 pos, Vec3 dir) {
        if (shooter == null || world.f_46443_) {
            return;
        }
        Vec3 startPos = pos;
        Vec3 lookVector = dir;
        Vec3 endPos = startPos.m_82549_(lookVector.m_82490_(maxDistance));
        ClipContext context = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, shooter);
        BlockHitResult blockHit = world.m_45547_(context);
        Vec3 finalHitPos = blockHit.m_82450_();
        AABB hitbox = new AABB(startPos, finalHitPos).m_82400_(0.5);
        List entities = world.m_6249_(shooter, hitbox, entity -> entity != shooter && entity.m_6084_());
        entities.sort(Comparator.comparingDouble(e -> e.m_20238_(startPos)));
        Scoreboard scoreboard = world.m_6188_();
        PlayerTeam shooterTeam = scoreboard.m_83500_(shooter.m_6302_());
        int pierceCount = 0;
        boolean bulletStopped = false;
        for (Entity entity2 : entities) {
            double hitHeight;
            boolean isHeadshot;
            boolean isEnemy;
            AABB entityBox = entity2.m_20191_().m_82400_(0.5);
            Optional intersection = entityBox.m_82371_(startPos, endPos);
            if (intersection.isEmpty()) continue;
            finalHitPos = (Vec3)intersection.get();
            ResourceLocation entityKey = BuiltInRegistries.f_256780_.m_7981_((Object)entity2.m_6095_());
            String entityId = entityKey != null ? entityKey.toString() : "unknown";
            if (IGNORED_ENTITIES.contains(entityId)) continue;
            if (HARD_ENTITIES.contains(entityId)) {
                bulletStopped = true;
                break;
            }
            PlayerTeam targetTeam = scoreboard.m_83500_(entity2.m_6302_());
            boolean bl = isEnemy = shooterTeam == null || targetTeam == null || shooterTeam != targetTeam;
            if (!isEnemy) continue;
            double distance = startPos.m_82554_(finalHitPos);
            float damage = baseDamage;
            if (distance > falloffStart) {
                double t = Math.min((distance - falloffStart) / (falloffEnd - falloffStart), 1.0);
                float multiplier = (float)(1.0 - t * (1.0 - (double)minMultiplier));
                damage *= multiplier;
            }
            boolean bl2 = isHeadshot = (hitHeight = finalHitPos.f_82480_ - entity2.m_20186_()) >= (double)entity2.m_20206_() * 0.85;
            if (isHeadshot) {
                damage *= 2.0f;
            }
            entity2.f_19802_ = 0;
            entity2.m_6469_(world.m_269111_().m_269264_(), damage);
            if (piercing && ++pierceCount < pierceLimit) continue;
            break;
        }
        if (bulletStopped || blockHit.m_6662_() == HitResult.Type.BLOCK || pierceCount == 0) {
            // empty if block
        }
    }
}

