/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.animatable.stateless.StatelessGeoSingletonAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.network.GeckoLibNetwork;

public class StatelessSingletonStopAnimPacket {
    private final String syncableId;
    private final long instanceId;
    private final String animation;

    public StatelessSingletonStopAnimPacket(String syncableId, long instanceId, String animation) {
        this.syncableId = syncableId;
        this.instanceId = instanceId;
        this.animation = animation;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.syncableId);
        buffer.m_130103_(this.instanceId);
        buffer.m_130070_(this.animation);
    }

    public static StatelessSingletonStopAnimPacket decode(FriendlyByteBuf buffer) {
        String syncableId = buffer.m_130277_();
        long instanceID = buffer.m_130258_();
        String animation = buffer.m_130277_();
        return new StatelessSingletonStopAnimPacket(syncableId, instanceID, animation);
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            GeoAnimatable animatable = GeckoLibNetwork.getSyncedAnimatable(this.syncableId);
            if (animatable instanceof StatelessGeoSingletonAnimatable) {
                StatelessGeoSingletonAnimatable statelessAnimatable = (StatelessGeoSingletonAnimatable)animatable;
                statelessAnimatable.handleClientAnimationStop(animatable, this.instanceId, this.animation);
            }
        });
    }
}

