/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class SetRetaliateTarget<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26382_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT)});
    protected Predicate<LivingEntity> canAttackPredicate = entity -> {
        if (!entity.m_6084_()) return false;
        if (!(entity instanceof Player)) return true;
        Player player = (Player)entity;
        if (player.m_150110_().f_35934_) return false;
        return true;
    };
    protected LivingEntity toTarget = null;
    protected BiPredicate<E, Entity> alertAlliesPredicate = (owner, attacker) -> false;
    protected BiPredicate<E, LivingEntity> allyPredicate = (owner, ally) -> {
        OwnableEntity pet;
        if (!owner.getClass().isAssignableFrom(ally.getClass()) || BrainUtils.getTargetOfEntity(ally) != null) {
            return false;
        }
        if (owner instanceof OwnableEntity && (pet = (OwnableEntity)owner).m_269323_() != ((OwnableEntity)ally).m_269323_()) {
            return false;
        }
        Entity lastHurtBy = (Entity)BrainUtils.getMemory(ally, MemoryModuleType.f_26382_);
        return lastHurtBy == null || !ally.m_7307_(lastHurtBy);
    };

    public SetRetaliateTarget<E> attackablePredicate(Predicate<LivingEntity> predicate) {
        this.canAttackPredicate = predicate;
        return this;
    }

    public SetRetaliateTarget<E> alertAlliesWhen(BiPredicate<E, Entity> predicate) {
        this.alertAlliesPredicate = predicate;
        return this;
    }

    public SetRetaliateTarget<E> isAllyIf(BiPredicate<E, LivingEntity> predicate) {
        this.allyPredicate = predicate;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean m_6114_(ServerLevel level, E owner) {
        this.toTarget = (LivingEntity)BrainUtils.getMemory(owner, MemoryModuleType.f_26382_);
        if (this.toTarget.m_6084_() && this.toTarget.m_9236_() == level && this.canAttackPredicate.test(this.toTarget)) {
            if (this.alertAlliesPredicate.test(owner, (Entity)this.toTarget)) {
                this.alertAllies(level, owner);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setTargetOfEntity(entity, this.toTarget);
        BrainUtils.clearMemory(entity, MemoryModuleType.f_26326_);
        this.toTarget = null;
    }

    protected void alertAllies(ServerLevel level, E owner) {
        double followRange = owner.m_21133_(Attributes.f_22277_);
        for (LivingEntity ally : EntityRetrievalUtil.getEntities((Level)level, owner.m_20191_().m_82377_(followRange, 10.0, followRange), entity -> {
            LivingEntity livingEntity;
            return entity != owner && entity instanceof LivingEntity && this.allyPredicate.test(owner, livingEntity = (LivingEntity)entity);
        })) {
            BrainUtils.setTargetOfEntity(ally, this.toTarget);
        }
    }
}

