/*
 * Decompiled with CFR 0.152.
 */
package net.skart.skd.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.skart.skd.entity.MediumSeatEntity;
import net.skart.skd.entity.SeatEntity;
import net.skart.skd.entity.TallSeatEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SkdModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"skd");
    public static final RegistryObject<EntityType<SeatEntity>> SEAT = SkdModEntities.register("seat", EntityType.Builder.m_20704_(SeatEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SeatEntity::new).m_20699_(0.6f, 0.6f));
    public static final RegistryObject<EntityType<TallSeatEntity>> TALL_SEAT = SkdModEntities.register("tall_seat", EntityType.Builder.m_20704_(TallSeatEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(TallSeatEntity::new).m_20699_(0.6f, 0.1f));
    public static final RegistryObject<EntityType<MediumSeatEntity>> MEDIUM_SEAT = SkdModEntities.register("medium_seat", EntityType.Builder.m_20704_(MediumSeatEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MediumSeatEntity::new).m_20699_(0.6f, 0.85f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SeatEntity.init();
            TallSeatEntity.init();
            MediumSeatEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SEAT.get(), SeatEntity.createAttributes().m_22265_());
        event.put((EntityType)TALL_SEAT.get(), TallSeatEntity.createAttributes().m_22265_());
        event.put((EntityType)MEDIUM_SEAT.get(), MediumSeatEntity.createAttributes().m_22265_());
    }
}

