/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.fart.api.Inheritance;
import net.minecraftforge.fart.api.Renamer;
import net.minecraftforge.fart.api.Transformer;
import net.minecraftforge.fart.internal.AsyncHelper;
import net.minecraftforge.fart.internal.Util;

class RenamerImpl
implements Renamer {
    static final int MAX_ASM_VERSION = 589824;
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private final File input;
    private final File output;
    private final List<File> libraries;
    private final List<Transformer> transformers;
    private final Inheritance inh;
    private final int threads;
    private final Consumer<String> logger;
    private final Consumer<String> debug;

    RenamerImpl(File input, File output, List<File> libraries, List<Transformer> transformers, Inheritance inh, int threads, Consumer<String> logger, Consumer<String> debug) {
        this.input = input.getAbsoluteFile();
        this.output = output.getAbsoluteFile();
        this.libraries = libraries;
        this.transformers = transformers;
        this.inh = inh;
        this.threads = threads;
        this.logger = logger;
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.accept("Adding Libraries to Inheritance");
        this.libraries.forEach(this.inh::addLibrary);
        if (!this.input.exists()) {
            throw new IllegalArgumentException("Input file not found: " + this.input.getAbsolutePath());
        }
        this.logger.accept("Reading Input: " + this.input.getAbsolutePath());
        ArrayList oldEntries = new ArrayList();
        try (ZipFile in = new ZipFile(this.input);){
            Util.forZip(in, e -> {
                if (e.isDirectory()) {
                    return;
                }
                String name = e.getName();
                byte[] data = Util.toByteArray(in.getInputStream((ZipEntry)e));
                if (name.endsWith(".class")) {
                    oldEntries.add(Transformer.ClassEntry.create(name, e.getTime(), data));
                } else if (name.equals(MANIFEST_NAME)) {
                    oldEntries.add(Transformer.ManifestEntry.create(e.getTime(), data));
                } else {
                    oldEntries.add(Transformer.ResourceEntry.create(name, e.getTime(), data));
                }
            });
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not parse input: " + this.input.getAbsolutePath(), e2);
        }
        AsyncHelper async = new AsyncHelper(this.threads);
        try {
            List ourClasses = oldEntries.stream().filter(e -> e instanceof Transformer.ClassEntry && !e.getName().startsWith("META-INF/")).map(Transformer.ClassEntry.class::cast).collect(Collectors.toList());
            this.logger.accept("Adding input to inheritence map");
            async.consumeAll(ourClasses, Transformer.ClassEntry::getClassName, c -> this.inh.addClass(c.getName().substring(0, c.getName().length() - 6), c.getData()));
            this.logger.accept("Processing entries");
            List<Transformer.Entry> newEntries = async.invokeAll(oldEntries, Transformer.Entry::getName, this::processEntry);
            this.logger.accept("Adding extras");
            this.transformers.stream().forEach(t -> newEntries.addAll(t.getExtras()));
            HashSet<String> seen = new HashSet<String>();
            String dupes = newEntries.stream().map(Transformer.Entry::getName).filter(n -> !seen.add((String)n)).sorted().collect(Collectors.joining(", "));
            if (!dupes.isEmpty()) {
                throw new IllegalStateException("Duplicate entries detected: " + dupes);
            }
            this.logger.accept("Sorting");
            Collections.sort(newEntries, this::compare);
            if (!this.output.getParentFile().exists()) {
                this.output.getParentFile().mkdirs();
            }
            seen.clear();
            this.logger.accept("Writing Output: " + this.output.getAbsolutePath());
            try (FileOutputStream fos = new FileOutputStream(this.output);
                 ZipOutputStream zos = new ZipOutputStream(fos);){
                for (Transformer.Entry e3 : newEntries) {
                    String name = e3.getName();
                    int idx = name.lastIndexOf(47);
                    if (idx != -1) {
                        this.addDirectory(zos, seen, name.substring(0, idx));
                    }
                    this.logger.accept("  " + name);
                    ZipEntry entry = new ZipEntry(name);
                    entry.setTime(e3.getTime());
                    zos.putNextEntry(entry);
                    zos.write(e3.getData());
                    zos.closeEntry();
                }
            }
            catch (IOException e4) {
                throw new RuntimeException("Could not write output to file: " + this.output.getAbsolutePath(), e4);
            }
        }
        finally {
            async.shutdown();
        }
    }

    private void addDirectory(ZipOutputStream zos, Set<String> seen, String path) throws IOException {
        if (!seen.add(path)) {
            return;
        }
        int idx = path.lastIndexOf(47);
        if (idx != -1) {
            this.addDirectory(zos, seen, path.substring(0, idx));
        }
        this.logger.accept("  " + path + '/');
        ZipEntry dir = new ZipEntry(path + '/');
        dir.setTime(946684800L);
        zos.putNextEntry(dir);
        zos.closeEntry();
    }

    private Transformer.Entry processEntry(Transformer.Entry start) {
        Transformer.Entry entry = start;
        for (Transformer transformer : this.transformers) {
            if ((entry = entry.process(transformer)) != null) continue;
            return null;
        }
        return entry;
    }

    private int compare(Transformer.Entry o1, Transformer.Entry o2) {
        if (MANIFEST_NAME.equals(o1.getName())) {
            return MANIFEST_NAME.equals(o2.getName()) ? 0 : -1;
        }
        if (MANIFEST_NAME.equals(o2.getName())) {
            return MANIFEST_NAME.equals(o1.getName()) ? 0 : 1;
        }
        return o1.getName().compareTo(o2.getName());
    }
}

