/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import org.slf4j.Logger;

public class SpriteLoader {
    private static final Logger f_244357_ = LogUtils.getLogger();
    private final ResourceLocation f_244500_;
    private final int f_243676_;
    private final int f_276071_;
    private final int f_276068_;

    public SpriteLoader(ResourceLocation p_276126_, int p_276121_, int p_276110_, int p_276114_) {
        this.f_244500_ = p_276126_;
        this.f_243676_ = p_276121_;
        this.f_276071_ = p_276110_;
        this.f_276068_ = p_276114_;
    }

    public static SpriteLoader m_245483_(TextureAtlas p_249085_) {
        return new SpriteLoader(p_249085_.m_118330_(), p_249085_.m_245285_(), p_249085_.m_276092_(), p_249085_.m_276095_());
    }

    public Preparations m_261295_(List<SpriteContents> p_262029_, int p_261919_, Executor p_261665_) {
        CompletableFuture<Object> $$21;
        int $$12;
        int $$3 = this.f_243676_;
        Stitcher<SpriteContents> $$4 = new Stitcher<SpriteContents>($$3, $$3, p_261919_);
        int $$5 = Integer.MAX_VALUE;
        int $$6 = 1 << p_261919_;
        for (SpriteContents $$7 : p_262029_) {
            $$5 = Math.min($$5, Math.min($$7.m_246492_(), $$7.m_245330_()));
            int $$8 = Math.min(Integer.lowestOneBit($$7.m_246492_()), Integer.lowestOneBit($$7.m_245330_()));
            if ($$8 < $$6) {
                f_244357_.warn("Texture {} with size {}x{} limits mip level from {} to {}", new Object[]{$$7.m_246162_(), $$7.m_246492_(), $$7.m_245330_(), Mth.m_14173_($$6), Mth.m_14173_($$8)});
                $$6 = $$8;
            }
            $$4.m_246099_($$7);
        }
        int $$9 = Math.min($$5, $$6);
        int $$10 = Mth.m_14173_($$9);
        if ($$10 < p_261919_) {
            f_244357_.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", new Object[]{this.f_244500_, p_261919_, $$10, $$9});
            int $$11 = $$10;
        } else {
            $$12 = p_261919_;
        }
        try {
            $$4.m_118193_();
        }
        catch (StitcherException $$13) {
            CrashReport $$14 = CrashReport.m_127521_($$13, "Stitching");
            CrashReportCategory $$15 = $$14.m_127514_("Stitcher");
            $$15.m_128159_("Sprites", $$13.m_118258_().stream().map(p_249576_ -> String.format(Locale.ROOT, "%s[%dx%d]", p_249576_.m_246162_(), p_249576_.m_246492_(), p_249576_.m_245330_())).collect(Collectors.joining(",")));
            $$15.m_128159_("Max Texture Size", $$3);
            throw new ReportedException($$14);
        }
        int $$16 = Math.max($$4.m_118174_(), this.f_276071_);
        int $$17 = Math.max($$4.m_118187_(), this.f_276068_);
        Map<ResourceLocation, TextureAtlasSprite> $$18 = this.m_276091_($$4, $$16, $$17);
        TextureAtlasSprite $$19 = $$18.get(MissingTextureAtlasSprite.m_118071_());
        if ($$12 > 0) {
            CompletableFuture<Void> $$20 = CompletableFuture.runAsync(() -> $$18.values().forEach(p_251202_ -> p_251202_.m_245424_().m_246368_($$12)), p_261665_);
        } else {
            $$21 = CompletableFuture.completedFuture(null);
        }
        return new Preparations($$16, $$17, $$12, $$19, $$18, $$21);
    }

    public static CompletableFuture<List<SpriteContents>> m_260809_(List<Supplier<SpriteContents>> p_261516_, Executor p_261791_) {
        List<CompletableFuture> $$2 = p_261516_.stream().map(p_261395_ -> CompletableFuture.supplyAsync(p_261395_, p_261791_)).toList();
        return Util.m_137567_($$2).thenApply(p_252234_ -> p_252234_.stream().filter(Objects::nonNull).toList());
    }

    public CompletableFuture<Preparations> m_260881_(ResourceManager p_262108_, ResourceLocation p_261754_, int p_262104_, Executor p_261687_) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> SpriteResourceLoader.m_261166_(p_262108_, p_261754_).m_260886_(p_262108_), p_261687_).thenCompose(p_261390_ -> SpriteLoader.m_260809_(p_261390_, p_261687_))).thenApply(p_261393_ -> this.m_261295_((List<SpriteContents>)p_261393_, p_262104_, p_261687_));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static SpriteContents m_245083_(ResourceLocation p_251630_, Resource p_250558_) {
        void $$9;
        void $$4;
        try {
            AnimationMetadataSection $$2 = p_250558_.m_215509_().m_214059_(AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
        }
        catch (Exception $$3) {
            f_244357_.error("Unable to parse metadata from {}", (Object)p_251630_, (Object)$$3);
            return null;
        }
        try (InputStream $$5 = p_250558_.m_215507_();){
            NativeImage $$6 = NativeImage.m_85058_($$5);
        }
        catch (IOException $$8) {
            f_244357_.error("Using missing texture, unable to load {}", (Object)p_251630_, (Object)$$8);
            return null;
        }
        FrameSize $$10 = $$4.m_245821_($$9.m_84982_(), $$9.m_85084_());
        if (Mth.m_264612_($$9.m_84982_(), $$10.f_244129_()) && Mth.m_264612_($$9.m_85084_(), $$10.f_244503_())) {
            return new SpriteContents(p_251630_, $$10, (NativeImage)$$9, (AnimationMetadataSection)$$4);
        }
        f_244357_.error("Image {} size {},{} is not multiple of frame size {},{}", new Object[]{p_251630_, $$9.m_84982_(), $$9.m_85084_(), $$10.f_244129_(), $$10.f_244503_()});
        $$9.close();
        return null;
    }

    private Map<ResourceLocation, TextureAtlasSprite> m_276091_(Stitcher<SpriteContents> p_276117_, int p_276111_, int p_276112_) {
        HashMap<ResourceLocation, TextureAtlasSprite> $$3 = new HashMap<ResourceLocation, TextureAtlasSprite>();
        p_276117_.m_118180_((p_251421_, p_250533_, p_251913_) -> $$3.put(p_251421_.m_246162_(), new TextureAtlasSprite(this.f_244500_, (SpriteContents)p_251421_, p_276111_, p_276112_, p_250533_, p_251913_)));
        return $$3;
    }

    public record Preparations(int f_243669_, int f_244632_, int f_244353_, TextureAtlasSprite f_243912_, Map<ResourceLocation, TextureAtlasSprite> f_243807_, CompletableFuture<Void> f_244415_) {
        public CompletableFuture<Preparations> m_246429_() {
            return this.f_244415_.thenApply(p_249056_ -> this);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Preparations.class, "width;height;mipLevel;missing;regions;readyForUpload", "f_243669_", "f_244632_", "f_244353_", "f_243912_", "f_243807_", "f_244415_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Preparations.class, "width;height;mipLevel;missing;regions;readyForUpload", "f_243669_", "f_244632_", "f_244353_", "f_243912_", "f_243807_", "f_244415_"}, this);
        }

        @Override
        public final boolean equals(Object p_250785_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Preparations.class, "width;height;mipLevel;missing;regions;readyForUpload", "f_243669_", "f_244632_", "f_244353_", "f_243912_", "f_243807_", "f_244415_"}, this, p_250785_);
        }
    }
}

