/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.forgewrapper.installer.detector;

import cpw.mods.modlauncher.Launcher;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public interface IFileDetector {
    public String name();

    public boolean enabled(HashMap<String, IFileDetector> var1);

    default public Path getLibraryDir() {
        String libraryDir = System.getProperty("forgewrapper.librariesDir");
        if (libraryDir != null) {
            return Paths.get(libraryDir, new String[0]).toAbsolutePath();
        }
        try {
            Path launcher = Paths.get(Launcher.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toAbsolutePath();
            return launcher.getParent().getParent().getParent().getParent().getParent().toAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    default public Path getInstallerJar(String forgeGroup, String forgeArtifact, String forgeFullVersion) {
        String installer = System.getProperty("forgewrapper.installer");
        if (installer != null) {
            return Paths.get(installer, new String[0]).toAbsolutePath();
        }
        return null;
    }

    default public Path getMinecraftJar(String mcVersion) {
        String minecraft = System.getProperty("forgewrapper.minecraft");
        if (minecraft != null) {
            return Paths.get(minecraft, new String[0]).toAbsolutePath();
        }
        return null;
    }
}

