/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.capturepoints;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import ru.liko.capturepoints.CaptureConfig;
import ru.liko.capturepoints.Zone;

public final class ZonesData
extends SavedData {
    public static final String DATA_NAME = "wrbcapturepoint_zones";
    private final List<Zone> zones = new ArrayList<Zone>();
    private boolean enabled = (Boolean)CaptureConfig.START_DISABLED.get() == false;
    public int axisScore = 0;
    public int alliesScore = 0;
    public int axisTickets = 0;
    public int alliesTickets = 0;
    public boolean ticketsMode = false;
    public boolean roundRunning = false;
    public int roundTotalTicks = 0;
    public int roundRemainingTicks = 0;
    public String lockoutOwner = "";
    public int lockoutRemainingTicks = 0;
    public transient double axisTicketRemainder = 0.0;
    public transient double alliesTicketRemainder = 0.0;

    public static ZonesData get(ServerLevel level) {
        return (ZonesData)level.m_8895_().m_164861_(ZonesData::load, ZonesData::new, DATA_NAME);
    }

    public static ZonesData load(CompoundTag tag) {
        ZonesData d = new ZonesData();
        d.enabled = tag.m_128471_("enabled");
        d.axisScore = tag.m_128451_("axisScore");
        d.alliesScore = tag.m_128451_("alliesScore");
        d.axisTickets = tag.m_128441_("axisTickets") ? tag.m_128451_("axisTickets") : 0;
        d.alliesTickets = tag.m_128441_("alliesTickets") ? tag.m_128451_("alliesTickets") : 0;
        d.ticketsMode = tag.m_128471_("ticketsMode");
        d.roundRunning = tag.m_128471_("roundRunning");
        d.roundTotalTicks = tag.m_128451_("roundTotalTicks");
        d.roundRemainingTicks = tag.m_128451_("roundRemainingTicks");
        d.lockoutOwner = tag.m_128441_("lockoutOwner") ? tag.m_128461_("lockoutOwner") : "";
        d.lockoutRemainingTicks = tag.m_128451_("lockoutRemainingTicks");
        ListTag list = tag.m_128437_("zones", 10);
        for (int i = 0; i < list.size(); ++i) {
            d.zones.add(Zone.fromTag(list.m_128728_(i)));
        }
        return d;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128379_("enabled", this.enabled);
        tag.m_128405_("axisScore", this.axisScore);
        tag.m_128405_("alliesScore", this.alliesScore);
        tag.m_128405_("axisTickets", this.axisTickets);
        tag.m_128405_("alliesTickets", this.alliesTickets);
        tag.m_128379_("ticketsMode", this.ticketsMode);
        tag.m_128379_("roundRunning", this.roundRunning);
        tag.m_128405_("roundTotalTicks", this.roundTotalTicks);
        tag.m_128405_("roundRemainingTicks", this.roundRemainingTicks);
        tag.m_128359_("lockoutOwner", this.lockoutOwner == null ? "" : this.lockoutOwner);
        tag.m_128405_("lockoutRemainingTicks", this.lockoutRemainingTicks);
        ListTag list = new ListTag();
        for (Zone z : this.zones) {
            list.add((Object)z.toTag());
        }
        tag.m_128365_("zones", (Tag)list);
        return tag;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
        this.m_77762_();
    }

    public List<Zone> zonesForDimension(String dimensionId) {
        return this.zones.stream().filter(z -> z.dimension.equals(dimensionId)).collect(Collectors.toList());
    }

    public boolean addZone(Zone z) {
        if (this.zones.stream().anyMatch(existing -> existing.dimension.equals(z.dimension) && existing.id.equalsIgnoreCase(z.id))) {
            return false;
        }
        this.zones.add(z);
        this.m_77762_();
        return true;
    }

    public boolean removeZone(String dimensionId, String id) {
        boolean removed = this.zones.removeIf(z -> z.dimension.equals(dimensionId) && z.id.equalsIgnoreCase(id));
        if (removed) {
            this.m_77762_();
        }
        return removed;
    }

    public Optional<Zone> find(String dimensionId, String id) {
        return this.zones.stream().filter(z -> z.dimension.equals(dimensionId) && z.id.equalsIgnoreCase(id)).findFirst();
    }
}

