/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.capturepoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import ru.liko.capturepoints.CaptureConfig;
import ru.liko.capturepoints.Network;
import ru.liko.capturepoints.S2CZoneLabelsPacket;
import ru.liko.capturepoints.S2CZoneStatusPacket;
import ru.liko.capturepoints.TeamUtils;
import ru.liko.capturepoints.Zone;
import ru.liko.capturepoints.ZonesData;

public final class ZoneCaptureManager {
    public static final ZoneCaptureManager INSTANCE = new ZoneCaptureManager();
    private int tickCounter = 0;

    private ZoneCaptureManager() {
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        if (srv == null) {
            return;
        }
        ++this.tickCounter;
        int packetInterval = (Integer)CaptureConfig.PACKET_INTERVAL_TICKS.get();
        for (ServerLevel level : srv.m_129785_()) {
            ZonesData data = ZonesData.get(level);
            String dimId = level.m_46472_().m_135782_().toString();
            if (data.roundRunning && data.roundTotalTicks > 0) {
                if (data.roundRemainingTicks > 0) {
                    --data.roundRemainingTicks;
                    data.m_77762_();
                }
                if (data.roundRemainingTicks <= 0) {
                    int axisOwned = 0;
                    int alliesOwned = 0;
                    for (Zone zone : data.zonesForDimension(dimId)) {
                        if (zone.ownerTeam.equalsIgnoreCase((String)CaptureConfig.TEAM_AXIS_NAME.get())) {
                            ++axisOwned;
                            continue;
                        }
                        if (!zone.ownerTeam.equalsIgnoreCase((String)CaptureConfig.TEAM_ALLIES_NAME.get())) continue;
                        ++alliesOwned;
                    }
                    String winner = axisOwned > alliesOwned ? (String)CaptureConfig.TEAM_AXIS_NAME.get() : (alliesOwned > axisOwned ? (String)CaptureConfig.TEAM_ALLIES_NAME.get() : "draw");
                    ZoneCaptureManager.endGame(level, data, winner);
                }
            }
            if (data.isEnabled()) {
                if (data.lockoutRemainingTicks > 0) {
                    --data.lockoutRemainingTicks;
                    if (data.lockoutRemainingTicks <= 0) {
                        data.lockoutOwner = "";
                    }
                    data.m_77762_();
                }
                List<Zone> zones = data.zonesForDimension(dimId);
                String axisName = (String)CaptureConfig.TEAM_AXIS_NAME.get();
                String alliesName = (String)CaptureConfig.TEAM_ALLIES_NAME.get();
                for (Zone z : zones) {
                    AABB box = z.aabb();
                    Iterator<Zone> inside = level.m_6443_(ServerPlayer.class, box, p -> !p.m_5833_());
                    int axis = 0;
                    int allies = 0;
                    Iterator iterator = inside.iterator();
                    while (iterator.hasNext()) {
                        ServerPlayer p3 = (ServerPlayer)iterator.next();
                        String t = ZoneCaptureManager.teamOf((Player)p3);
                        if (t == null) continue;
                        if (t.equalsIgnoreCase((String)CaptureConfig.TEAM_AXIS_NAME.get())) {
                            ++axis;
                        }
                        if (!t.equalsIgnoreCase((String)CaptureConfig.TEAM_ALLIES_NAME.get())) continue;
                        ++allies;
                    }
                    int minReq = (Integer)CaptureConfig.MIN_PLAYERS_TO_CAPTURE.get();
                    boolean noPlayers = axis == 0 && allies == 0;
                    boolean contestedEqual = axis > 0 && allies > 0 && axis == allies;
                    String leading = null;
                    int advantage = 0;
                    if (axis >= minReq || allies >= minReq) {
                        if (axis > allies && axis >= minReq) {
                            leading = axisName;
                            advantage = axis - allies;
                        } else if (allies > axis && allies >= minReq) {
                            leading = alliesName;
                            advantage = allies - axis;
                        }
                    }
                    if (leading != null && ((Boolean)CaptureConfig.CHAIN_ENABLED.get()).booleanValue() && !ZoneCaptureManager.isZoneActiveForTeam(zones, z, leading, axisName, alliesName)) {
                        leading = null;
                    }
                    if (leading != null && data.lockoutRemainingTicks > 0 && !leading.equalsIgnoreCase(data.lockoutOwner)) {
                        leading = null;
                    }
                    if (noPlayers || contestedEqual || leading == null) continue;
                    int seconds = Math.max(1, z.captureSeconds > 0 ? z.captureSeconds : (Integer)CaptureConfig.CAPTURE_TIME_SECONDS.get());
                    float basePerTick = 1.0f / ((float)seconds * 20.0f);
                    int attackers = leading.equalsIgnoreCase(axisName) ? axis : allies;
                    int defenders = leading.equalsIgnoreCase(axisName) ? allies : axis;
                    double exp = (Double)CaptureConfig.CAPTURE_GROWTH_EXPONENT.get();
                    double slow = (Double)CaptureConfig.DEFENDER_SLOW_COEFF.get();
                    float delta = (float)((double)basePerTick * Math.max(0.0, Math.pow(Math.max(1, attackers), exp) - slow * (double)defenders));
                    if (leading.equalsIgnoreCase(z.ownerTeam)) {
                        if (z.capturingTeam == null || leading.equalsIgnoreCase(z.capturingTeam)) continue;
                        z.progress -= delta;
                        if (z.progress <= 0.0f) {
                            z.progress = 0.0f;
                            z.capturingTeam = null;
                        }
                        data.m_77762_();
                        continue;
                    }
                    if (z.capturingTeam == null) {
                        z.capturingTeam = leading;
                        ZoneCaptureManager.execConfigured(level, z, leading, z.ownerTeam, (String)CaptureConfig.CMD_ON_START.get());
                        if (((Boolean)CaptureConfig.CHAT_ANNOUNCE_ENABLED.get()).booleanValue()) {
                            ZoneCaptureManager.broadcastAll(level, (Component)Component.m_237110_((String)"wrbcapturepoint.chat.flag_capturing", (Object[])new Object[]{z.id, ZoneCaptureManager.teamDisplayName(level, leading)}));
                        }
                    }
                    if (!leading.equalsIgnoreCase(z.capturingTeam)) {
                        z.progress -= delta;
                        if (z.progress <= 0.0f) {
                            z.progress = 0.0f;
                            z.capturingTeam = leading;
                            ZoneCaptureManager.execConfigured(level, z, leading, z.ownerTeam, (String)CaptureConfig.CMD_ON_START.get());
                        }
                    } else {
                        z.progress += delta;
                        if (z.progress >= 1.0f) {
                            if (!"neutral".equalsIgnoreCase(z.ownerTeam) && !leading.equalsIgnoreCase(z.ownerTeam)) {
                                prevOwner = z.ownerTeam;
                                z.ownerTeam = "neutral";
                                z.progress = 0.0f;
                                ZoneCaptureManager.execConfigured(level, z, leading, (String)prevOwner, (String)CaptureConfig.CMD_ON_NEUTRALIZE.get());
                                if (((Boolean)CaptureConfig.CHAT_ANNOUNCE_ENABLED.get()).booleanValue()) {
                                    ZoneCaptureManager.broadcastAll(level, (Component)Component.m_237110_((String)"wrbcapturepoint.chat.flag_lost", (Object[])new Object[]{z.id}));
                                }
                            } else {
                                prevOwner = z.ownerTeam;
                                z.ownerTeam = leading;
                                z.capturingTeam = null;
                                z.progress = 0.0f;
                                ZoneCaptureManager.execConfigured(level, z, leading, (String)prevOwner, (String)CaptureConfig.CMD_ON_CAPTURED.get());
                                if (((Boolean)CaptureConfig.CHAT_ANNOUNCE_ENABLED.get()).booleanValue()) {
                                    ZoneCaptureManager.broadcastAll(level, (Component)Component.m_237110_((String)"wrbcapturepoint.chat.flag_captured", (Object[])new Object[]{z.id, ZoneCaptureManager.teamDisplayName(level, leading)}));
                                }
                            }
                        }
                    }
                    data.m_77762_();
                }
                int n = zones.size();
                if (n > 0 && (Integer)CaptureConfig.LOCKOUT_SECONDS.get() > 0) {
                    int axisOwned = 0;
                    int alliesOwned = 0;
                    for (Zone z : zones) {
                        if (z.ownerTeam.equalsIgnoreCase(axisName)) {
                            ++axisOwned;
                            continue;
                        }
                        if (!z.ownerTeam.equalsIgnoreCase(alliesName)) continue;
                        ++alliesOwned;
                    }
                    if (axisOwned == n) {
                        data.lockoutOwner = axisName;
                        data.lockoutRemainingTicks = (Integer)CaptureConfig.LOCKOUT_SECONDS.get() * 20;
                        data.m_77762_();
                    } else if (alliesOwned == n) {
                        data.lockoutOwner = alliesName;
                        data.lockoutRemainingTicks = (Integer)CaptureConfig.LOCKOUT_SECONDS.get() * 20;
                        data.m_77762_();
                    }
                }
                if (((Boolean)CaptureConfig.TICKETS_ENABLED.get()).booleanValue()) {
                    int newVal;
                    if (!data.ticketsMode) {
                        data.ticketsMode = true;
                        if (data.axisTickets <= 0) {
                            data.axisTickets = (Integer)CaptureConfig.TICKETS_INITIAL.get();
                        }
                        if (data.alliesTickets <= 0) {
                            data.alliesTickets = (Integer)CaptureConfig.TICKETS_INITIAL.get();
                        }
                        data.m_77762_();
                    }
                    data.roundRunning = true;
                    data.roundTotalTicks = 0;
                    int axisOwned = 0;
                    int alliesOwned = 0;
                    for (Zone z : zones) {
                        if (z.ownerTeam.equalsIgnoreCase(axisName)) {
                            ++axisOwned;
                            continue;
                        }
                        if (!z.ownerTeam.equalsIgnoreCase(alliesName)) continue;
                        ++alliesOwned;
                    }
                    int diff = axisOwned - alliesOwned;
                    double base = (Double)CaptureConfig.TICKET_DRAIN_BASE_PER_SEC.get();
                    double perPoint = (Double)CaptureConfig.TICKET_DRAIN_PER_POINT_PER_SEC.get();
                    double axisDrainPerSec = 0.0;
                    double alliesDrainPerSec = 0.0;
                    if (diff > 0) {
                        alliesDrainPerSec = base + perPoint * (double)diff;
                        axisDrainPerSec = base;
                    } else if (diff < 0) {
                        axisDrainPerSec = base + perPoint * (double)(-diff);
                        alliesDrainPerSec = base;
                    } else {
                        axisDrainPerSec = base;
                        alliesDrainPerSec = base;
                    }
                    double axisPerTick = axisDrainPerSec / 20.0;
                    double alliesPerTick = alliesDrainPerSec / 20.0;
                    data.axisTicketRemainder += axisPerTick;
                    data.alliesTicketRemainder += alliesPerTick;
                    int axisDec = (int)Math.floor(data.axisTicketRemainder);
                    int alliesDec = (int)Math.floor(data.alliesTicketRemainder);
                    if (axisDec > 0) {
                        data.axisTicketRemainder -= (double)axisDec;
                        newVal = Math.max(0, data.axisTickets - axisDec);
                        if (newVal != data.axisTickets) {
                            data.axisTickets = newVal;
                            data.m_77762_();
                        }
                    }
                    if (alliesDec > 0) {
                        data.alliesTicketRemainder -= (double)alliesDec;
                        newVal = Math.max(0, data.alliesTickets - alliesDec);
                        if (newVal != data.alliesTickets) {
                            data.alliesTickets = newVal;
                            data.m_77762_();
                        }
                    }
                    if (data.axisTickets <= 0 || data.alliesTickets <= 0) {
                        String winner = data.axisTickets <= 0 && data.alliesTickets <= 0 ? "draw" : (data.axisTickets <= 0 ? alliesName : axisName);
                        ZoneCaptureManager.endGame(level, data, winner);
                    }
                }
            }
            if (this.tickCounter % packetInterval == 0) {
                for (ServerPlayer p4 : level.m_6907_()) {
                    Zone current = null;
                    for (Zone z : data.zonesForDimension(dimId)) {
                        if (!z.contains(p4.m_20183_())) continue;
                        current = z;
                        break;
                    }
                    Network.sendToPlayer(p4, new S2CZoneStatusPacket(data.isEnabled(), current == null ? "" : current.id, current == null ? "" : current.ownerTeam, current == null || current.capturingTeam == null ? "" : current.capturingTeam, current == null ? 0.0f : current.progress, data.axisTickets, data.alliesTickets, data.roundRunning, data.roundRemainingTicks, data.roundTotalTicks));
                }
            }
            if (this.tickCounter % packetInterval != 0) continue;
            if (!((Boolean)CaptureConfig.HUD_HOLOGRAMS_ENABLED.get()).booleanValue()) {
                for (ServerPlayer p5 : level.m_6907_()) {
                    Network.sendToPlayer(p5, new S2CZoneLabelsPacket(Collections.emptyList()));
                }
                continue;
            }
            double maxDistSq = 65536.0;
            for (ServerPlayer serverPlayer : level.m_6907_()) {
                ArrayList<S2CZoneLabelsPacket.Label> list = new ArrayList<S2CZoneLabelsPacket.Label>();
                Vec3 pos = serverPlayer.m_20182_();
                for (Zone z : data.zonesForDimension(dimId)) {
                    double cz;
                    double dz;
                    double cy;
                    double dy;
                    double cx = (double)(z.min.m_123341_() + z.max.m_123341_()) / 2.0 + 0.5;
                    double dx = cx - pos.f_82479_;
                    if (!(dx * dx + (dy = (cy = (double)z.max.m_123342_() + 2.5) - pos.f_82480_) * dy + (dz = (cz = (double)(z.min.m_123343_() + z.max.m_123343_()) / 2.0 + 0.5) - pos.f_82481_) * dz <= 65536.0)) continue;
                    int axisCount = 0;
                    int alliesCount = 0;
                    List inside = level.m_6443_(ServerPlayer.class, z.aabb(), p2 -> !p2.m_5833_());
                    for (ServerPlayer p22 : inside) {
                        String t = ZoneCaptureManager.teamOf((Player)p22);
                        if (t == null) continue;
                        if (t.equalsIgnoreCase((String)CaptureConfig.TEAM_AXIS_NAME.get())) {
                            ++axisCount;
                            continue;
                        }
                        if (!t.equalsIgnoreCase((String)CaptureConfig.TEAM_ALLIES_NAME.get())) continue;
                        ++alliesCount;
                    }
                    Object status = axisCount > 0 && alliesCount > 0 && axisCount == alliesCount ? "\u0421\u043f\u043e\u0440\u043d\u0430\u044f" : (z.capturingTeam != null && !z.capturingTeam.isBlank() ? (!"neutral".equalsIgnoreCase(z.ownerTeam) && !z.capturingTeam.equalsIgnoreCase(z.ownerTeam) ? "\u041d\u0435\u0439\u0442\u0440\u0430\u043b\u0438\u0437\u0443\u0435\u0442\u0441\u044f: " + z.capturingTeam : "\u0417\u0430\u0445\u0432\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f: " + z.capturingTeam) : ("neutral".equalsIgnoreCase(z.ownerTeam) ? "\u041d\u0435\u0439\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f" : "\u0417\u0430\u0445\u0432\u0430\u0447\u0435\u043d\u0430: " + z.ownerTeam));
                    list.add(new S2CZoneLabelsPacket.Label(z.id, cx, cy, cz, (String)status, z.progress, z.min.m_123341_(), z.min.m_123342_(), z.min.m_123343_(), z.max.m_123341_(), z.max.m_123342_(), z.max.m_123343_()));
                }
                Network.sendToPlayer(serverPlayer, new S2CZoneLabelsPacket(list));
            }
        }
    }

    private static String teamOf(Player p) {
        Team t = p.m_5647_();
        return t != null ? t.m_5758_() : null;
    }

    private static boolean isZoneActiveForTeam(List<Zone> zones, Zone current, String team, String axisName, String alliesName) {
        String mode = (String)CaptureConfig.GAME_MODE.get();
        if (mode == null) {
            mode = "FREE";
        }
        switch (mode = mode.trim().toUpperCase()) {
            case "FREE": {
                return true;
            }
            case "CHAIN_AB": {
                char prefix;
                if (!((Boolean)CaptureConfig.CHAIN_ENABLED.get()).booleanValue()) {
                    return true;
                }
                if (team.equalsIgnoreCase(axisName)) {
                    prefix = 'A';
                } else if (team.equalsIgnoreCase(alliesName)) {
                    prefix = 'B';
                } else {
                    return true;
                }
                String id = current.id;
                if (id == null || id.length() < 2 || Character.toUpperCase(id.charAt(0)) != prefix) {
                    return true;
                }
                ArrayList<Zone> list = new ArrayList<Zone>();
                for (Zone zone : zones) {
                    if (zone.id == null || zone.id.length() < 2 || Character.toUpperCase(zone.id.charAt(0)) != prefix) continue;
                    list.add(zone);
                }
                if (list.isEmpty()) {
                    return true;
                }
                ZoneCaptureManager.sortByNumericSuffix(list);
                Zone active = null;
                for (Zone z : list) {
                    if (team.equalsIgnoreCase(z.ownerTeam)) continue;
                    active = z;
                    break;
                }
                if (active == null) {
                    return false;
                }
                return current.id.equalsIgnoreCase(active.id);
            }
            case "LINEAR": {
                List<Zone> list = ZoneCaptureManager.buildLinearList(zones);
                Zone active = ZoneCaptureManager.linearActive(list);
                return active != null && current.id.equalsIgnoreCase(active.id);
            }
            case "ALTERNATING": {
                List<Zone> list = ZoneCaptureManager.buildLinearList(zones);
                Zone active = ZoneCaptureManager.linearActive(list);
                if (active == null || !current.id.equalsIgnoreCase(active.id)) {
                    return false;
                }
                int idx = ZoneCaptureManager.indexOf(list, current);
                if (idx < 0) {
                    return false;
                }
                boolean firstAxis = (Boolean)CaptureConfig.ALT_START_AXIS.get();
                boolean bl = idx % 2 == 0 == firstAxis;
                String allowedTeam = bl ? axisName : alliesName;
                return team.equalsIgnoreCase(allowedTeam);
            }
        }
        return true;
    }

    private static List<Zone> buildLinearList(List<Zone> zones) {
        String order = (String)CaptureConfig.LINEAR_ORDER.get();
        if (order != null && !order.isBlank()) {
            String[] ids = order.split(",");
            HashMap<String, Integer> prio = new HashMap<String, Integer>();
            int i = 0;
            for (String s : ids) {
                prio.put(s.trim().toLowerCase(), i++);
            }
            ArrayList<Zone> list = new ArrayList<Zone>(zones);
            list.sort((a, b) -> {
                Integer pb;
                Integer pa = prio.getOrDefault(a.id == null ? "" : a.id.toLowerCase(), Integer.MAX_VALUE);
                if (!pa.equals(pb = prio.getOrDefault(b.id == null ? "" : b.id.toLowerCase(), Integer.MAX_VALUE))) {
                    return Integer.compare(pa, pb);
                }
                return ZoneCaptureManager.compareByNumericSuffix(a, b);
            });
            return list;
        }
        ArrayList<Zone> list = new ArrayList<Zone>(zones);
        ZoneCaptureManager.sortByNumericSuffix(list);
        return list;
    }

    private static Zone linearActive(List<Zone> list) {
        if (list.isEmpty()) {
            return null;
        }
        for (Zone z : list) {
            if (z.ownerTeam != null && !z.ownerTeam.equalsIgnoreCase("neutral")) continue;
            return z;
        }
        return list.get(list.size() - 1);
    }

    private static int indexOf(List<Zone> list, Zone target) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).id == null || !list.get((int)i).id.equalsIgnoreCase(target.id)) continue;
            return i;
        }
        return -1;
    }

    private static void sortByNumericSuffix(List<Zone> list) {
        list.sort(ZoneCaptureManager::compareByNumericSuffix);
    }

    private static int compareByNumericSuffix(Zone a, Zone b) {
        int na = ZoneCaptureManager.parseSuffixNumber(a.id);
        int nb = ZoneCaptureManager.parseSuffixNumber(b.id);
        if (na != -1 && nb != -1) {
            return Integer.compare(na, nb);
        }
        if (na != -1) {
            return -1;
        }
        if (nb != -1) {
            return 1;
        }
        return a.id.compareToIgnoreCase(b.id);
    }

    private static int parseSuffixNumber(String id) {
        if (id == null || id.length() < 2) {
            return -1;
        }
        try {
            String s = id.substring(1);
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private static void execConfigured(ServerLevel level, Zone z, String team, String ownerForPlaceholder, String template) {
        if (template == null || template.isBlank()) {
            return;
        }
        MinecraftServer srv = level.m_7654_();
        if (srv == null) {
            return;
        }
        int x = (int)Math.round(z.centerX());
        int y = (int)Math.round(z.centerY());
        int zc = (int)Math.round(z.centerZ());
        String dim = level.m_46472_().m_135782_().toString();
        String cmd = template.replace("{id}", z.id == null ? "" : z.id).replace("{team}", team == null ? "" : team).replace("{owner}", ownerForPlaceholder == null ? "" : ownerForPlaceholder).replace("{dim}", dim).replace("{x}", String.valueOf(x)).replace("{y}", String.valueOf(y)).replace("{z}", String.valueOf(zc));
        srv.m_129892_().m_230957_(srv.m_129893_().m_81325_(4), cmd);
    }

    private static void endGame(ServerLevel level, ZonesData data, String winnerTeamId) {
        try {
            data.ticketsMode = false;
            data.roundRunning = false;
            data.roundRemainingTicks = 0;
            data.roundTotalTicks = 0;
            data.lockoutOwner = "";
            data.lockoutRemainingTicks = 0;
            data.setEnabled(false);
            String dimId = level.m_46472_().m_135782_().toString();
            for (Zone z : data.zonesForDimension(dimId)) {
                z.capturingTeam = null;
                z.progress = 0.0f;
            }
            data.m_77762_();
            String display = winnerTeamId != null && !"draw".equalsIgnoreCase(winnerTeamId) ? ZoneCaptureManager.teamDisplayName(level, winnerTeamId) : "\u041d\u0438\u0447\u044c\u044f";
            String color = winnerTeamId != null && !"draw".equalsIgnoreCase(winnerTeamId) ? ZoneCaptureManager.teamColorName(level, winnerTeamId) : "gold";
            ZoneCaptureManager.perform(level, "title @a times 10 80 20");
            ZoneCaptureManager.perform(level, "title @a subtitle " + ZoneCaptureManager.jsonText("\u0420\u0430\u0443\u043d\u0434 \u043e\u043a\u043e\u043d\u0447\u0435\u043d", "gray"));
            Object titleText = "draw".equalsIgnoreCase(winnerTeamId) ? "\u041d\u0438\u0447\u044c\u044f" : "\u041f\u043e\u0431\u0435\u0434\u0430: " + display;
            ZoneCaptureManager.perform(level, "title @a title " + ZoneCaptureManager.jsonText((String)titleText, color));
            String msg = "\u0420\u0430\u0443\u043d\u0434 \u043e\u043a\u043e\u043d\u0447\u0435\u043d. " + (String)(winnerTeamId != null && !"draw".equalsIgnoreCase(winnerTeamId) ? "\u041f\u043e\u0431\u0435\u0434\u0438\u043b\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 " + ZoneCaptureManager.teamDisplayName(level, winnerTeamId) : "\u041d\u0438\u0447\u044c\u044f");
            for (ServerPlayer sp : level.m_6907_()) {
                sp.m_5661_((Component)Component.m_237113_((String)msg), false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String teamDisplayName(ServerLevel lvl, String teamId) {
        if (teamId == null || teamId.isBlank()) {
            return "";
        }
        try {
            ServerScoreboard sb = lvl.m_6188_();
            return TeamUtils.getDisplayName((Scoreboard)sb, teamId);
        }
        catch (Throwable throwable) {
            return teamId;
        }
    }

    private static String teamColorName(ServerLevel lvl, String teamId) {
        if (teamId == null || teamId.isBlank()) {
            return "white";
        }
        try {
            ServerScoreboard sb = lvl.m_6188_();
            String name = TeamUtils.getColorName((Scoreboard)sb, teamId);
            if (name != null && !name.isBlank()) {
                return name.toLowerCase();
            }
        }
        catch (Throwable sb) {
            // empty catch block
        }
        String axis = (String)CaptureConfig.TEAM_AXIS_NAME.get();
        String allies = (String)CaptureConfig.TEAM_ALLIES_NAME.get();
        if (teamId.equalsIgnoreCase(axis)) {
            return "red";
        }
        if (teamId.equalsIgnoreCase(allies)) {
            return "blue";
        }
        return "white";
    }

    private static String jsonText(String text, String color) {
        if (text == null) {
            text = "";
        }
        String safe = text.replace("\\", "\\\\").replace("\"", "\\\"");
        String col = color == null || color.isBlank() ? "white" : color.toLowerCase();
        return "{\"text\":\"" + safe + "\",\"color\":\"" + col + "\"}";
    }

    private static void perform(ServerLevel level, String cmd) {
        try {
            MinecraftServer srv = level.m_7654_();
            if (srv != null) {
                srv.m_129892_().m_230957_(srv.m_129893_().m_81325_(4), cmd);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void broadcastAll(ServerLevel level, Component msg) {
        try {
            for (ServerPlayer sp : level.m_6907_()) {
                sp.m_5661_(msg, false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

