/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.capturepoints;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public final class TeamUtils {
    private TeamUtils() {
    }

    public static PlayerTeam getTeamById(Scoreboard sb, String teamId) {
        if (sb == null || teamId == null || teamId.isBlank()) {
            return null;
        }
        try {
            try {
                PlayerTeam direct = sb.m_83489_(teamId);
                if (direct != null) {
                    return direct;
                }
            }
            catch (Throwable direct) {
                // empty catch block
            }
            for (PlayerTeam tt : TeamUtils.getAllTeams(sb)) {
                if (tt == null || !teamId.equalsIgnoreCase(tt.m_5758_())) continue;
                return tt;
            }
            PlayerTeam viaMap = TeamUtils.getTeamFromInternalMap(sb, teamId);
            if (viaMap != null) {
                return viaMap;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static PlayerTeam getTeamByDisplayName(Scoreboard sb, String displayName) {
        if (sb == null || displayName == null || displayName.isBlank()) {
            return null;
        }
        try {
            Collection<PlayerTeam> teams = TeamUtils.getAllTeams(sb);
            if (teams == null) {
                return null;
            }
            for (PlayerTeam t : teams) {
                try {
                    Component dn = t.m_83364_();
                    if (dn == null || !displayName.equalsIgnoreCase(dn.getString())) continue;
                    return t;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Collection<PlayerTeam> getAllTeams(Scoreboard sb) {
        try {
            try {
                Method m = Scoreboard.class.getMethod("getPlayerTeams", new Class[0]);
                Object res = m.invoke((Object)sb, new Object[0]);
                if (res instanceof Collection) {
                    Collection col = (Collection)res;
                    ArrayList<PlayerTeam> list = new ArrayList<PlayerTeam>();
                    for (Object o : col) {
                        if (!(o instanceof PlayerTeam)) continue;
                        PlayerTeam pt = (PlayerTeam)o;
                        list.add(pt);
                    }
                    return list;
                }
            }
            catch (NoSuchMethodException m) {
                // empty catch block
            }
            try {
                Method m2 = Scoreboard.class.getMethod("getTeams", new Class[0]);
                Object res2 = m2.invoke((Object)sb, new Object[0]);
                if (res2 instanceof Collection) {
                    Collection col2 = (Collection)res2;
                    ArrayList<PlayerTeam> list = new ArrayList<PlayerTeam>();
                    for (Object o : col2) {
                        if (!(o instanceof PlayerTeam)) continue;
                        PlayerTeam pt = (PlayerTeam)o;
                        list.add(pt);
                    }
                    return list;
                }
            }
            catch (NoSuchMethodException m2) {
                // empty catch block
            }
            Map<String, PlayerTeam> map = TeamUtils.getInternalTeamsMap(sb);
            return map != null ? map.values() : List.of();
        }
        catch (Throwable t) {
            return List.of();
        }
    }

    private static PlayerTeam getTeamFromInternalMap(Scoreboard sb, String teamId) {
        Map<String, PlayerTeam> map = TeamUtils.getInternalTeamsMap(sb);
        if (map == null) {
            return null;
        }
        PlayerTeam direct = map.get(teamId);
        if (direct != null) {
            return direct;
        }
        for (Map.Entry<String, PlayerTeam> e : map.entrySet()) {
            if (e.getKey() == null || !e.getKey().equalsIgnoreCase(teamId)) continue;
            return e.getValue();
        }
        return null;
    }

    private static Map<String, PlayerTeam> getInternalTeamsMap(Scoreboard sb) {
        try {
            for (Class<?> c = sb.getClass(); c != null; c = c.getSuperclass()) {
                for (String fieldName : new String[]{"teamsByName", "teams", "teamMap"}) {
                    try {
                        Field f = c.getDeclaredField(fieldName);
                        f.setAccessible(true);
                        Object val = f.get(sb);
                        if (!(val instanceof Map)) continue;
                        Map m = (Map)val;
                        try {
                            Map cast = m;
                            return cast;
                        }
                        catch (ClassCastException classCastException) {
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static PlayerTeam resolveTeam(Scoreboard sb, String idOrDisplayName) {
        PlayerTeam t = TeamUtils.getTeamById(sb, idOrDisplayName);
        if (t != null) {
            return t;
        }
        return TeamUtils.getTeamByDisplayName(sb, idOrDisplayName);
    }

    public static Integer getTeamRgb(Scoreboard sb, String idOrDisplayName) {
        PlayerTeam t = TeamUtils.resolveTeam(sb, idOrDisplayName);
        if (t != null) {
            try {
                ChatFormatting fmt = t.m_7414_();
                if (fmt != null) {
                    Integer rgb = fmt.m_126665_();
                    if (rgb != null) {
                        return rgb;
                    }
                    String name = fmt.m_126666_();
                    if (name != null && name.equalsIgnoreCase("reset")) {
                        return 0xFFFFFF;
                    }
                }
            }
            catch (Throwable fmt) {
                // empty catch block
            }
            try {
                TextColor tc;
                Component dn = t.m_83364_();
                if (dn != null && (tc = dn.m_7383_().m_131135_()) != null) {
                    return tc.m_131265_();
                }
            }
            catch (Throwable dn) {
                // empty catch block
            }
        }
        try {
            ChatFormatting byName;
            String s;
            String string = s = idOrDisplayName == null ? null : idOrDisplayName.trim().toLowerCase(Locale.ROOT);
            if (s != null && !s.isEmpty() && (byName = ChatFormatting.m_126657_((String)s)) != null) {
                Integer rgb = byName.m_126665_();
                if (rgb != null) {
                    return rgb;
                }
                if ("reset".equals(s)) {
                    return 0xFFFFFF;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String getDisplayName(Scoreboard sb, String teamIdOrDisplay) {
        PlayerTeam t = TeamUtils.resolveTeam(sb, teamIdOrDisplay);
        if (t != null && t.m_83364_() != null) {
            return t.m_83364_().getString();
        }
        return teamIdOrDisplay == null ? "" : teamIdOrDisplay;
    }

    public static String getColorName(Scoreboard sb, String teamIdOrDisplay) {
        ChatFormatting byName;
        String s;
        PlayerTeam t = TeamUtils.resolveTeam(sb, teamIdOrDisplay);
        if (t != null && t.m_7414_() != null && t.m_7414_().m_126666_() != null) {
            return t.m_7414_().m_126666_().toLowerCase(Locale.ROOT);
        }
        String string = s = teamIdOrDisplay == null ? null : teamIdOrDisplay.trim().toLowerCase(Locale.ROOT);
        if (s != null && (byName = ChatFormatting.m_126657_((String)s)) != null && byName.m_126666_() != null) {
            return byName.m_126666_().toLowerCase(Locale.ROOT);
        }
        return "white";
    }

    public static String debugDump(Scoreboard sb) {
        StringBuilder sbuf = new StringBuilder();
        try {
            Integer rgb;
            String cn;
            ChatFormatting fmt;
            String dn;
            PlayerTeam t;
            try {
                Method m = Scoreboard.class.getMethod("getPlayerTeams", new Class[0]);
                Object res = m.invoke((Object)sb, new Object[0]);
                if (res instanceof Collection) {
                    Collection col = (Collection)res;
                    sbuf.append("getPlayerTeams size=").append(col.size()).append('\n');
                    for (Object o : col) {
                        if (o instanceof PlayerTeam) {
                            t = (PlayerTeam)o;
                            dn = t.m_83364_() == null ? "" : t.m_83364_().getString();
                            fmt = t.m_7414_();
                            cn = fmt == null ? "null" : fmt.m_126666_();
                            rgb = fmt == null ? null : fmt.m_126665_();
                            sbuf.append(" - id=").append(t.m_5758_()).append(", display=\"").append(dn).append("\", color=").append(cn).append(", rgb=").append(rgb == null ? "null" : String.format("#%06X", rgb)).append('\n');
                            continue;
                        }
                        sbuf.append(" - unknown entry class=").append(o == null ? "null" : o.getClass().getName()).append('\n');
                    }
                } else {
                    sbuf.append("getPlayerTeams returned ").append(res == null ? "null" : res.getClass().getName()).append('\n');
                }
            }
            catch (Throwable ex) {
                sbuf.append("getPlayerTeams failed: ").append(ex.getClass().getSimpleName()).append('\n');
            }
            try {
                Method m2 = Scoreboard.class.getMethod("getTeams", new Class[0]);
                Object res2 = m2.invoke((Object)sb, new Object[0]);
                if (res2 instanceof Collection) {
                    Collection col2 = (Collection)res2;
                    sbuf.append("getTeams size=").append(col2.size()).append('\n');
                    for (Object o : col2) {
                        if (o instanceof PlayerTeam) {
                            t = (PlayerTeam)o;
                            dn = t.m_83364_() == null ? "" : t.m_83364_().getString();
                            fmt = t.m_7414_();
                            cn = fmt == null ? "null" : fmt.m_126666_();
                            rgb = fmt == null ? null : fmt.m_126665_();
                            sbuf.append(" - id=").append(t.m_5758_()).append(", display=\"").append(dn).append("\", color=").append(cn).append(", rgb=").append(rgb == null ? "null" : String.format("#%06X", rgb)).append('\n');
                            continue;
                        }
                        sbuf.append(" - unknown entry class=").append(o == null ? "null" : o.getClass().getName()).append('\n');
                    }
                } else {
                    sbuf.append("getTeams returned ").append(res2 == null ? "null" : res2.getClass().getName()).append('\n');
                }
            }
            catch (Throwable ex) {
                sbuf.append("getTeams failed: ").append(ex.getClass().getSimpleName()).append('\n');
            }
            Map<String, PlayerTeam> map = TeamUtils.getInternalTeamsMap(sb);
            if (map != null) {
                sbuf.append("internalMap size=").append(map.size()).append('\n');
                for (Map.Entry<String, PlayerTeam> e : map.entrySet()) {
                    PlayerTeam t2 = e.getValue();
                    String dn2 = t2.m_83364_() == null ? "" : t2.m_83364_().getString();
                    ChatFormatting fmt2 = t2.m_7414_();
                    String cn2 = fmt2 == null ? "null" : fmt2.m_126666_();
                    Integer rgb2 = fmt2 == null ? null : fmt2.m_126665_();
                    sbuf.append(" * id=").append(e.getKey()).append(" -> display=\"").append(dn2).append("\", color=").append(cn2).append(", rgb=").append(rgb2 == null ? "null" : String.format("#%06X", rgb2)).append('\n');
                }
            } else {
                sbuf.append("internalMap failed\n");
            }
        }
        catch (Throwable ex) {
            sbuf.append("debugDump error: ").append(ex.getClass().getSimpleName());
        }
        return sbuf.toString();
    }
}

