/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.capturepoints;

import net.minecraftforge.common.ForgeConfigSpec;

public final class ClientConfig {
    private static final ForgeConfigSpec.Builder B = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue HUD_ENABLED;
    public static final ForgeConfigSpec.IntValue HUD_OFFSET_X;
    public static final ForgeConfigSpec.IntValue HUD_OFFSET_Y;
    public static final ForgeConfigSpec.BooleanValue HUD_HOLOGRAMS_ENABLED;
    public static final ForgeConfigSpec.IntValue HUD_PANEL_FADE_TICKS;
    public static final ForgeConfigSpec.IntValue HUD_BANNER_TICKS;
    public static final ForgeConfigSpec.IntValue HUD_STALE_TIMEOUT_TICKS;
    public static final ForgeConfigSpec.BooleanValue MODERN_HOLOGRAMS_ENABLED;
    public static final ForgeConfigSpec.IntValue HOLO_MAX_DISTANCE;
    public static final ForgeConfigSpec.IntValue HOLO_LOD_NEAR;
    public static final ForgeConfigSpec.IntValue HOLO_LOD_FAR;
    public static final ForgeConfigSpec.DoubleValue HOLO_BASE_SCALE;
    public static final ForgeConfigSpec.BooleanValue HOLO_TEXTURED;
    public static final ForgeConfigSpec.ConfigValue<String> HOLO_TEXTURE_PANEL;
    public static final ForgeConfigSpec.BooleanValue HOLO_SHOW_BOUNDS;
    public static final ForgeConfigSpec.BooleanValue ZONE_OUTLINE_ENABLED;
    public static final ForgeConfigSpec.IntValue ZONE_OUTLINE_COLOR;
    public static final ForgeConfigSpec.ConfigValue<String> TEAM_AXIS_NAME;
    public static final ForgeConfigSpec.ConfigValue<String> TEAM_ALLIES_NAME;

    private ClientConfig() {
    }

    static {
        B.push("hud");
        HUD_ENABLED = B.comment(new String[]{"RU: \u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0443\u044e HUD-\u043f\u0430\u043d\u0435\u043b\u044c \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0442\u043e\u0447\u043a\u0438.", "EN: Enable client HUD panel for zone status."}).define("enabled", true);
        HUD_OFFSET_X = B.comment(new String[]{"RU: \u0413\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u0434\u0432\u0438\u0433 HUD (\u043f\u0438\u043a\u0441\u0435\u043b\u0438).", "EN: HUD horizontal offset (pixels)."}).defineInRange("offsetX", 0, -10000, 10000);
        HUD_OFFSET_Y = B.comment(new String[]{"RU: \u0412\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u0434\u0432\u0438\u0433 HUD (\u043f\u0438\u043a\u0441\u0435\u043b\u0438).", "EN: HUD vertical offset (pixels)."}).defineInRange("offsetY", 0, -10000, 10000);
        HUD_HOLOGRAMS_ENABLED = B.comment(new String[]{"RU: \u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u0442\u0430\u0440\u044b\u0435 3D-\u043b\u0435\u0439\u0431\u043b\u044b/\u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u043d\u0430\u0434 \u0442\u043e\u0447\u043a\u0430\u043c\u0438.", "EN: Enable legacy 3D labels/holograms above points."}).define("hologramsEnabled", true);
        HUD_PANEL_FADE_TICKS = B.comment(new String[]{"RU: \u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043f\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f/\u0441\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u0430\u043d\u0435\u043b\u0438 (\u0442\u0438\u043a\u0438).", "EN: Panel fade-in/out duration (ticks)."}).defineInRange("panelFadeTicks", 24, 6, 200);
        HUD_BANNER_TICKS = B.comment(new String[]{"RU: \u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0431\u0430\u043d\u043d\u0435\u0440\u0430 \u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0438 \u0437\u0430\u0445\u0432\u0430\u0442\u0430 (\u0442\u0438\u043a\u0438).", "EN: Duration of capture-complete banner (ticks)."}).defineInRange("bannerTicks", 70, 20, 400);
        HUD_STALE_TIMEOUT_TICKS = B.comment(new String[]{"RU: \u0421\u0447\u0438\u0442\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u043c\u0438 \u0447\u0435\u0440\u0435\u0437 N \u0442\u0438\u043a\u043e\u0432 (\u0441\u043a\u0440\u044b\u0432\u0430\u0442\u044c HUD \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439).", "EN: Mark data as stale after N ticks (hide HUD if no updates)."}).defineInRange("staleTimeoutTicks", 15, 1, 200);
        MODERN_HOLOGRAMS_ENABLED = B.comment(new String[]{"RU: \u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0440\u0435\u043d\u0434\u0435\u0440 \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c (\u043d\u0435 \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0443\u044f \u0441\u043e \u0441\u0442\u0430\u0440\u044b\u043c\u0438).", "EN: Enable modern hologram renderer (won't double-render with legacy).", "NOTE: Works only when hud.hologramsEnabled=false and modernHologramsEnabled=true."}).define("modernHologramsEnabled", true);
        HOLO_MAX_DISTANCE = B.comment(new String[]{"RU: \u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u0440\u0435\u043d\u0434\u0435\u0440\u0430 \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c (\u0431\u043b\u043e\u043a\u0438).", "EN: Maximum hologram render distance (blocks)."}).defineInRange("hologramMaxDistance", 96, 16, 512);
        HOLO_LOD_NEAR = B.comment(new String[]{"RU: \u0414\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f, \u0431\u043b\u0438\u0436\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438.", "EN: Distance for full-detail LOD."}).defineInRange("hologramLodNear", 16, 4, 128);
        HOLO_LOD_FAR = B.comment(new String[]{"RU: \u0414\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f, \u0434\u0430\u043b\u044c\u0448\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0443\u043f\u0440\u043e\u0449\u0435\u043d\u043d\u044b\u0439 \u0432\u0438\u0434.", "EN: Distance to start simplified LOD."}).defineInRange("hologramLodFar", 48, 8, 256);
        HOLO_BASE_SCALE = B.comment(new String[]{"RU: \u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u043c\u0430\u0441\u0448\u0442\u0430\u0431 \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0432 \u043c\u0438\u0440\u0435.", "EN: Base scale of the label in world."}).defineInRange("hologramBaseScale", 0.025, 0.005, 0.1);
        HOLO_TEXTURED = B.comment(new String[]{"RU: \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0443\u044e \u043f\u0430\u043d\u0435\u043b\u044c \u0434\u043b\u044f \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c.", "EN: Use textured panel for holograms."}).define("hologramTextured", true);
        HOLO_TEXTURE_PANEL = B.comment(new String[]{"RU: \u041f\u0443\u0442\u044c \u043a \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u0435 \u043f\u0430\u043d\u0435\u043b\u0438 \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u044b.", "EN: Texture path for hologram panel."}).define("hologramTexturePanel", (Object)"capturepoints:textures/ui/holo_panel.png");
        HOLO_SHOW_BOUNDS = B.comment(new String[]{"RU: \u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0443\u044e \u0440\u0430\u043c\u043a\u0443/\u043a\u043e\u043d\u0442\u0443\u0440.", "EN: Show minimal border/box."}).define("hologramShowBounds", true);
        B.pop();
        B.push("outline");
        ZONE_OUTLINE_ENABLED = B.comment(new String[]{"RU: \u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043a\u0440\u0430\u0441\u0438\u0432\u0443\u044e \u043e\u0431\u0432\u043e\u0434\u043a\u0443 \u0437\u043e\u043d\u044b \u0432 \u043c\u0438\u0440\u0435 (\u0432\u043c\u0435\u0441\u0442\u043e \u043f\u0430\u0440\u0442\u0438\u043a\u043b\u043e\u0432).", "EN: Render a nice world-space outline of the zone (non-particle)."}).define("enabled", true);
        ZONE_OUTLINE_COLOR = B.comment(new String[]{"RU: \u0426\u0432\u0435\u0442 \u043b\u0438\u043d\u0438\u0438 \u043e\u0431\u0432\u043e\u0434\u043a\u0438 (ARGB, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 0xA0FFCC00).", "EN: Outline line color (ARGB, e.g. 0xA0FFCC00)."}).defineInRange("color", -1593848832, Integer.MIN_VALUE, Integer.MAX_VALUE);
        B.pop();
        B.push("teams");
        TEAM_AXIS_NAME = B.comment(new String[]{"RU: \u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b 1 (\u0432\u043b\u0438\u044f\u0435\u0442 \u043d\u0430 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430).", "EN: Technical name of team 1 (client display only)."}).define("team1", (Object)"team1");
        TEAM_ALLIES_NAME = B.comment(new String[]{"RU: \u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b 2 (\u0432\u043b\u0438\u044f\u0435\u0442 \u043d\u0430 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430).", "EN: Technical name of team 2 (client display only)."}).define("team2", (Object)"team2");
        B.pop();
        SPEC = B.build();
    }
}

