/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.capturepoints;

import net.minecraftforge.common.ForgeConfigSpec;

public final class CaptureConfig {
    private static final ForgeConfigSpec.Builder B = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue START_DISABLED;
    public static final ForgeConfigSpec.IntValue CAPTURE_TIME_SECONDS;
    public static final ForgeConfigSpec.BooleanValue CONTESTED_STOPS_PROGRESS;
    public static final ForgeConfigSpec.IntValue PACKET_INTERVAL_TICKS;
    public static final ForgeConfigSpec.IntValue MIN_PLAYERS_TO_CAPTURE;
    public static final ForgeConfigSpec.IntValue ROUND_SECONDS;
    public static final ForgeConfigSpec.BooleanValue CHAIN_ENABLED;
    public static final ForgeConfigSpec.IntValue LOCKOUT_SECONDS;
    public static final ForgeConfigSpec.BooleanValue CHAT_ANNOUNCE_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<String> CMD_ON_START;
    public static final ForgeConfigSpec.ConfigValue<String> CMD_ON_NEUTRALIZE;
    public static final ForgeConfigSpec.ConfigValue<String> CMD_ON_CAPTURED;
    public static final ForgeConfigSpec.ConfigValue<String> GAME_MODE;
    public static final ForgeConfigSpec.ConfigValue<String> LINEAR_ORDER;
    public static final ForgeConfigSpec.BooleanValue ALT_START_AXIS;
    public static final ForgeConfigSpec.DoubleValue CAPTURE_GROWTH_EXPONENT;
    public static final ForgeConfigSpec.DoubleValue DEFENDER_SLOW_COEFF;
    public static final ForgeConfigSpec.BooleanValue TICKETS_ENABLED;
    public static final ForgeConfigSpec.IntValue TICKETS_INITIAL;
    public static final ForgeConfigSpec.DoubleValue TICKET_DRAIN_BASE_PER_SEC;
    public static final ForgeConfigSpec.DoubleValue TICKET_DRAIN_PER_POINT_PER_SEC;
    public static final ForgeConfigSpec.ConfigValue<String> TEAM_AXIS_NAME;
    public static final ForgeConfigSpec.ConfigValue<String> TEAM_ALLIES_NAME;
    public static final ForgeConfigSpec.BooleanValue HUD_ENABLED;
    public static final ForgeConfigSpec.IntValue HUD_OFFSET_X;
    public static final ForgeConfigSpec.IntValue HUD_OFFSET_Y;
    public static final ForgeConfigSpec.BooleanValue HUD_HOLOGRAMS_ENABLED;
    public static final ForgeConfigSpec.IntValue HUD_PANEL_FADE_TICKS;
    public static final ForgeConfigSpec.IntValue HUD_BANNER_TICKS;
    public static final ForgeConfigSpec.IntValue HUD_STALE_TIMEOUT_TICKS;

    private CaptureConfig() {
    }

    static {
        B.push("general");
        START_DISABLED = B.comment(new String[]{"RU: \u0415\u0441\u043b\u0438 true, \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0437\u0430\u0445\u0432\u0430\u0442\u0430 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0434\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f /cp start.", "EN: If true, the capture system starts disabled until /cp start is executed."}).define("startDisabled", true);
        CAPTURE_TIME_SECONDS = B.comment(new String[]{"RU: \u0411\u0430\u0437\u043e\u0432\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e\u043b\u043d\u043e\u0433\u043e \u0437\u0430\u0445\u0432\u0430\u0442\u0430 \u043e\u0434\u043d\u043e\u0439 \u0442\u043e\u0447\u043a\u0438 (\u0441\u0435\u043a\u0443\u043d\u0434\u044b).", "EN: Base time to fully capture a single point (seconds)."}).defineInRange("captureTimeSeconds", 25, 1, 600);
        CONTESTED_STOPS_PROGRESS = B.comment(new String[]{"RU: \u041f\u0440\u0438 \u0440\u0430\u0432\u043d\u043e\u043c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u043e\u0431\u0435\u0438\u0445 \u043a\u043e\u043c\u0430\u043d\u0434 \u043f\u0440\u043e\u0433\u0440\u0435\u0441\u0441 \u043e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f.", "EN: When both teams have equal presence, capture progress pauses."}).define("contestedStopsProgress", true);
        PACKET_INTERVAL_TICKS = B.comment(new String[]{"RU: \u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b (\u0432 \u0442\u0438\u043a\u0430\u0445) \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442 (HUD/\u043b\u0435\u0439\u0431\u043b\u044b).", "EN: Packet update interval (ticks) for client HUD/labels."}).defineInRange("packetIntervalTicks", 10, 1, 200);
        MIN_PLAYERS_TO_CAPTURE = B.comment(new String[]{"RU: \u041c\u0438\u043d\u0438\u043c\u0443\u043c \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u043e\u0434\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u0447\u0430\u0442\u044c \u0437\u0430\u0445\u0432\u0430\u0442.", "EN: Minimum players from a team required to start capture."}).defineInRange("minPlayersToCapture", 1, 1, 100);
        ROUND_SECONDS = B.comment(new String[]{"RU: \u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0440\u0430\u0443\u043d\u0434\u0430 (\u0441\u0435\u043a\u0443\u043d\u0434\u044b). 0 \u2014 \u0440\u0430\u0443\u043d\u0434\u043e\u0432\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0430.", "EN: Round duration in seconds. 0 disables round system."}).defineInRange("roundSeconds", 180, 0, 7200);
        CHAIN_ENABLED = B.comment(new String[]{"RU: \u0423\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0430\u044f \u043e\u043f\u0446\u0438\u044f \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438. \u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0441\u0442\u0430\u0440\u044b\u0439 \u0440\u0435\u0436\u0438\u043c \u0446\u0435\u043f\u043e\u0447\u0435\u043a A*/B* (\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0440\u0435\u0436\u0438\u043c CHAIN_AB).", "EN: Legacy compatibility flag. Enables old A*/B* chain mode (use CHAIN_AB game mode instead)."}).define("chainEnabled", false);
        LOCKOUT_SECONDS = B.comment(new String[]{"RU: \u0411\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0430 \u043f\u043e\u0441\u043b\u0435 \u043f\u043e\u043b\u043d\u043e\u0439 \u0434\u043e\u043c\u0438\u043d\u0430\u0446\u0438\u0438 (\u0441\u0435\u043a\u0443\u043d\u0434\u044b), \u0447\u0442\u043e\u0431\u044b \u0441\u0440\u0430\u0437\u0443 \u043d\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u0445\u0432\u0430\u0442\u0438\u043b\u0438.", "EN: Lockout duration after full domination (seconds) to prevent instant counter-capture."}).defineInRange("lockoutSeconds", 0, 0, 7200);
        CHAT_ANNOUNCE_ENABLED = B.comment(new String[]{"RU: \u041e\u0431\u044a\u044f\u0432\u043b\u044f\u0442\u044c \u0432 \u0447\u0430\u0442\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0442\u043e\u0447\u0435\u043a (\u043d\u0430\u0447\u0430\u043b\u043e \u0437\u0430\u0445\u0432\u0430\u0442\u0430, \u043d\u0435\u0439\u0442\u0440\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f, \u0437\u0430\u0445\u0432\u0430\u0442).", "EN: Announce point events in chat (capturing start, neutralized, captured)."}).define("chatAnnounceEnabled", true);
        CMD_ON_START = B.comment(new String[]{"RU: \u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u043f\u0440\u0438 \u0441\u0442\u0430\u0440\u0442\u0435 \u0437\u0430\u0445\u0432\u0430\u0442\u0430. \u041f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440\u044b: {id},{team},{owner},{dim},{x},{y},{z}", "EN: Server command on capture start. Placeholders: {id},{team},{owner},{dim},{x},{y},{z}"}).define("onCaptureStartCommand", (Object)"");
        CMD_ON_NEUTRALIZE = B.comment(new String[]{"RU: \u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u043f\u0440\u0438 \u043d\u0435\u0439\u0442\u0440\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0442\u043e\u0447\u043a\u0438.", "EN: Command when a point is neutralized."}).define("onNeutralizedCommand", (Object)"");
        CMD_ON_CAPTURED = B.comment(new String[]{"RU: \u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u043d\u043e\u043c \u0437\u0430\u0445\u0432\u0430\u0442\u0435 \u0442\u043e\u0447\u043a\u0438.", "EN: Command when a point is fully captured."}).define("onCapturedCommand", (Object)"");
        GAME_MODE = B.comment(new String[]{"RU: \u0420\u0435\u0436\u0438\u043c \u0438\u0433\u0440\u043e\u0432\u043e\u0433\u043e \u043f\u043e\u0442\u043e\u043a\u0430: FREE, CHAIN_AB, LINEAR, ALTERNATING.", "EN: Game flow mode: FREE, CHAIN_AB, LINEAR, ALTERNATING."}).define("gameMode", (Object)"FREE");
        LINEAR_ORDER = B.comment(new String[]{"RU: \u042f\u0432\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0437\u043e\u043d \u0434\u043b\u044f LINEAR/ALTERNATING (id \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e). \u041f\u0443\u0441\u0442\u043e \u2014 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043f\u043e \u0447\u0438\u0441\u043b\u043e\u0432\u043e\u043c\u0443 \u0441\u0443\u0444\u0444\u0438\u043a\u0441\u0443.", "EN: Explicit zone order for LINEAR/ALTERNATING (comma-separated ids). Empty falls back to numeric suffix sorting."}).define("linearOrder", (Object)"");
        ALT_START_AXIS = B.comment(new String[]{"RU: \u0412 ALTERNATING \u2014 \u043a\u0430\u043a\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442 \u043d\u0430 \u043f\u0435\u0440\u0432\u043e\u043c \u0438\u043d\u0434\u0435\u043a\u0441\u0435 (true = team1, false = team2).", "EN: In ALTERNATING \u2014 which team starts on the first index (true = team1, false = team2)."}).define("alternatingFirstAxis", true);
        CAPTURE_GROWTH_EXPONENT = B.comment(new String[]{"RU: \u042d\u043a\u0441\u043f\u043e\u043d\u0435\u043d\u0442\u0430 \u0440\u043e\u0441\u0442\u0430 \u043f\u0440\u043e\u0433\u0440\u0435\u0441\u0441\u0430 \u0437\u0430\u0445\u0432\u0430\u0442\u0430 (1.0 \u043b\u0438\u043d\u0435\u0439\u043d\u043e, <1.0 \u2014 \u0441\u0443\u0431\u043b\u0438\u043d\u0435\u0439\u043d\u043e).", "EN: Capture growth exponent (1.0 linear, <1.0 sub-linear)."}).defineInRange("captureGrowthExponent", 1.0, 0.2, 1.0);
        DEFENDER_SLOW_COEFF = B.comment(new String[]{"RU: \u041a\u043e\u044d\u0444\u0444\u0438\u0446\u0438\u0435\u043d\u0442 \u0437\u0430\u043c\u0435\u0434\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0433\u0440\u0435\u0441\u0441\u0430 \u043f\u0440\u0438 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u0437\u0430\u0449\u0438\u0442\u043d\u0438\u043a\u043e\u0432.", "EN: Slowdown coefficient when defenders are present."}).defineInRange("defenderSlowCoeff", 0.5, 0.0, 5.0);
        B.pop();
        B.push("tickets");
        TICKETS_ENABLED = B.comment(new String[]{"RU: \u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0442\u0438\u043a\u0435\u0442\u043e\u0432/\u0431\u0438\u043b\u0435\u0442\u043e\u0432 (\u0438\u0441\u0442\u043e\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u0438\u0432\u043e\u0434\u0438\u0442 \u043a \u043f\u043e\u0440\u0430\u0436\u0435\u043d\u0438\u044e).", "EN: Enable ticket system (draining to zero results in defeat)."}).define("enabled", true);
        TICKETS_INITIAL = B.comment(new String[]{"RU: \u0421\u0442\u0430\u0440\u0442\u043e\u0432\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0438\u043a\u0435\u0442\u043e\u0432 \u0443 \u043a\u0430\u0436\u0434\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b.", "EN: Initial tickets for each team."}).defineInRange("initial", 300, 1, 100000);
        TICKET_DRAIN_BASE_PER_SEC = B.comment(new String[]{"RU: \u0411\u0430\u0437\u043e\u0432\u0430\u044f \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u043f\u043e\u0442\u0435\u0440\u0438 \u0442\u0438\u043a\u0435\u0442\u043e\u0432 (\u0432 \u0441\u0435\u043a.), \u0432\u0441\u0435\u0433\u0434\u0430.", "EN: Base ticket drain per second (always applied)."}).defineInRange("drainBasePerSec", 0.0, 0.0, 1000.0);
        TICKET_DRAIN_PER_POINT_PER_SEC = B.comment(new String[]{"RU: \u0414\u043e\u043f. \u043f\u043e\u0442\u0435\u0440\u044f \u0442\u0438\u043a\u0435\u0442\u043e\u0432 \u0437\u0430 \u043a\u0430\u0436\u0434\u0443\u044e \u0442\u043e\u0447\u043a\u0443 \u043f\u043e\u0434 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u0435\u043c \u043f\u0440\u043e\u0442\u0438\u0432\u043d\u0438\u043a\u0430 (\u0432 \u0441\u0435\u043a.).", "EN: Extra drain per enemy-controlled point (per second)."}).defineInRange("drainPerPointPerSec", 1.0, 0.0, 1000.0);
        B.pop();
        B.push("teams");
        TEAM_AXIS_NAME = B.comment(new String[]{"RU: \u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b 1 (\u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 /team <id>).", "EN: Technical name of team 1 (matches /team <id>)."}).define("team1", (Object)"team1");
        TEAM_ALLIES_NAME = B.comment(new String[]{"RU: \u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b 2 (\u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 /team <id>).", "EN: Technical name of team 2 (matches /team <id>)."}).define("team2", (Object)"team2");
        B.pop();
        B.push("hud");
        HUD_ENABLED = B.comment(new String[]{"RU: \u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0443\u044e HUD-\u043f\u0430\u043d\u0435\u043b\u044c \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0437\u043e\u043d\u044b.", "EN: Enable client HUD panel for zone status."}).define("enabled", true);
        HUD_OFFSET_X = B.comment(new String[]{"RU: \u0413\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u0434\u0432\u0438\u0433 HUD (\u043f\u0438\u043a\u0441\u0435\u043b\u0438).", "EN: HUD horizontal offset (pixels)."}).defineInRange("offsetX", 0, -10000, 10000);
        HUD_OFFSET_Y = B.comment(new String[]{"RU: \u0412\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u0434\u0432\u0438\u0433 HUD (\u043f\u0438\u043a\u0441\u0435\u043b\u0438).", "EN: HUD vertical offset (pixels)."}).defineInRange("offsetY", 0, -10000, 10000);
        HUD_HOLOGRAMS_ENABLED = B.comment(new String[]{"RU: \u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u0442\u0430\u0440\u044b\u0435 3D-\u043b\u0435\u0439\u0431\u043b\u044b/\u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u043d\u0430\u0434 \u0442\u043e\u0447\u043a\u0430\u043c\u0438 (\u043a\u043b\u0438\u0435\u043d\u0442).", "EN: Enable legacy 3D labels/holograms above points (client)."}).define("hologramsEnabled", true);
        HUD_PANEL_FADE_TICKS = B.comment(new String[]{"RU: \u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043f\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f/\u0441\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u0430\u043d\u0435\u043b\u0438 (\u0442\u0438\u043a\u0438).", "EN: Panel fade-in/out duration (ticks)."}).defineInRange("panelFadeTicks", 24, 6, 200);
        HUD_BANNER_TICKS = B.comment(new String[]{"RU: \u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0431\u0430\u043d\u043d\u0435\u0440\u0430 \u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0438 \u0437\u0430\u0445\u0432\u0430\u0442\u0430 (\u0442\u0438\u043a\u0438).", "EN: Duration of capture-complete banner (ticks)."}).defineInRange("bannerTicks", 70, 20, 400);
        HUD_STALE_TIMEOUT_TICKS = B.comment(new String[]{"RU: \u0421\u0447\u0438\u0442\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u043c\u0438 \u0447\u0435\u0440\u0435\u0437 N \u0442\u0438\u043a\u043e\u0432 (\u0434\u043b\u044f \u0441\u043a\u0440\u044b\u0442\u0438\u044f HUD \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439).", "EN: Mark data as stale after N ticks (to hide HUD if no updates)."}).defineInRange("staleTimeoutTicks", 15, 1, 200);
        B.pop();
        SPEC = B.build();
    }
}

