/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import com.hrznstudio.titanium.block.BasicBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RayTraceUtils {
    public static HitResult rayTraceSimple(Level world, LivingEntity living, double blockReachDistance, float partialTicks) {
        Vec3 vec3d = living.m_20299_(partialTicks);
        Vec3 vec3d1 = living.m_20252_(partialTicks);
        Vec3 vec3d2 = vec3d.m_82520_(vec3d1.f_82479_ * blockReachDistance, vec3d1.f_82480_ * blockReachDistance, vec3d1.f_82481_ * blockReachDistance);
        return world.m_45547_(new ClipContext(vec3d, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)living));
    }

    @Nullable
    public static VoxelShape rayTraceVoxelShape(BlockHitResult original, Level world, LivingEntity living, double blockReachDistance, float partialTicks) {
        BlockState og = world.m_8055_(original.m_82425_());
        if (og.m_60734_() instanceof BasicBlock && ((BasicBlock)og.m_60734_()).hasIndividualRenderVoxelShape()) {
            Vec3 vec3d = living.m_20299_(partialTicks);
            Vec3 vec3d1 = living.m_20252_(partialTicks);
            Vec3 vec3d2 = vec3d.m_82520_(vec3d1.f_82479_ * blockReachDistance, vec3d1.f_82480_ * blockReachDistance, vec3d1.f_82481_ * blockReachDistance);
            List<VoxelShape> voxelShapes = ((BasicBlock)og.m_60734_()).getBoundingBoxes(og, (BlockGetter)world, original.m_82425_());
            if (voxelShapes.size() > 0) {
                VoxelShape closest = Shapes.m_83040_();
                double distance = Double.MAX_VALUE;
                for (VoxelShape voxelShape : voxelShapes) {
                    BlockHitResult result = voxelShape.m_83220_(vec3d, vec3d2, original.m_82425_());
                    if (result == null || !(vec3d.m_82554_(result.m_82450_()) < distance)) continue;
                    closest = voxelShape;
                    distance = vec3d.m_82554_(result.m_82450_());
                }
                return closest;
            }
        }
        return Shapes.m_83040_();
    }
}

