/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class OrResourceCondition
implements ResourceCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final List<ICondition> conditions;

    public OrResourceCondition(ICondition ... alternatives) {
        this.conditions = new ArrayList<ICondition>(Arrays.asList(alternatives));
    }

    public OrResourceCondition(ResourceCondition ... alternatives) {
        this((ICondition[])Arrays.stream(alternatives).map(ResourceCondition::createForgeCondition).toArray(ICondition[]::new));
    }

    @Override
    public boolean test(ResourceConditionContext context) {
        for (ICondition condition : this.conditions) {
            if (!condition.test(context.getUnderlying())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResourceConditionSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public ResourceCondition or(ResourceCondition alternative) {
        this.conditions.add(ResourceCondition.createForgeCondition(alternative));
        return this;
    }

    private static class Serializer
    implements ResourceConditionSerializer<OrResourceCondition> {
        private Serializer() {
        }

        @Override
        public void serialize(JsonObject json, OrResourceCondition condition) {
            JsonArray conditions = new JsonArray();
            for (ICondition alternative : condition.conditions) {
                conditions.add((JsonElement)CraftingHelper.serialize((ICondition)alternative));
            }
            json.add("conditions", (JsonElement)conditions);
        }

        @Override
        public OrResourceCondition deserialize(JsonObject json) {
            if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
                throw new RuntimeException("Condition must have key 'conditions' with a json array!");
            }
            JsonArray conditionsJson = json.getAsJsonArray("conditions");
            ICondition[] conditions = new ICondition[conditionsJson.size()];
            for (int i = 0; i < conditionsJson.size(); ++i) {
                conditions[i] = CraftingHelper.getCondition((JsonObject)conditionsJson.get(i).getAsJsonObject());
            }
            return new OrResourceCondition(conditions);
        }
    }
}

