/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.functional;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import java.util.Collection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PowerfulAttraction
extends Perk {
    public PowerfulAttraction() {
        super("powerful_attraction", Perk.Type.FUNCTIONAL);
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity sourceEntity = source.m_7639_();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        Player player = (Player)sourceEntity;
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        short level = GunData.from((ItemStack)stack).perk.getLevel(ModPerks.POWERFUL_ATTRACTION);
        if (level > 0 && (DamageTypeTool.isGunDamage(source) || DamageTypeTool.isExplosionDamage(source))) {
            Collection drops = event.getDrops();
            drops.forEach(itemEntity -> {
                ItemStack item = itemEntity.m_32055_();
                if (!player.m_36356_(item.m_41777_())) {
                    player.m_36176_(item, false);
                }
            });
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        short level = GunData.from((ItemStack)stack).perk.getLevel(ModPerks.POWERFUL_ATTRACTION);
        if (level > 0) {
            player.m_6756_((int)((float)event.getDroppedExperience() * (0.8f + 0.2f * (float)level)));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLootingLevel(LootingLevelEvent event) {
        DamageSource source = event.getDamageSource();
        if (source == null) {
            return;
        }
        Entity sourceEntity = source.m_7639_();
        if (!(sourceEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)sourceEntity;
        ItemStack stack = living.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        short level = GunData.from((ItemStack)stack).perk.getLevel(ModPerks.POWERFUL_ATTRACTION);
        if (level > 0 && (DamageTypeTool.isGunDamage(source) || DamageTypeTool.isExplosionDamage(source))) {
            event.setLootingLevel(level / 4);
        }
    }
}

