/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ItemNBTTool;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record VehicleMovementMessage(short keys) {
    public static VehicleMovementMessage decode(FriendlyByteBuf buffer) {
        return new VehicleMovementMessage(buffer.readShort());
    }

    public static void encode(VehicleMovementMessage message, FriendlyByteBuf buffer) {
        buffer.writeShort((int)message.keys);
    }

    public static void handler(VehicleMovementMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() != null) {
                VehicleEntity vehicleEntity;
                ServerPlayer player = context.getSender();
                Entity entity = player.m_20202_();
                ItemStack stack = player.m_21205_();
                VehicleEntity vehicle = null;
                if (entity instanceof VehicleEntity && (vehicleEntity = (VehicleEntity)entity).m_146895_() == player) {
                    vehicle = vehicleEntity;
                } else if (stack.m_150930_((Item)ModItems.MONITOR.get()) && ItemNBTTool.getBoolean(stack, "Using", false) && ItemNBTTool.getBoolean(stack, "Linked", false)) {
                    vehicle = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_("LinkedDrone"));
                }
                if (vehicle == null) {
                    return;
                }
                vehicle.processInput(message.keys);
            }
        });
        context.setPacketHandled(true);
    }
}

