/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ShootMessage {
    private final double spread;
    private final boolean zoom;
    @Nullable
    private final UUID uuid;
    @Nullable
    private final Vector3f targetPos;

    public ShootMessage(double spread, boolean zoom, @Nullable UUID uuid) {
        this.spread = spread;
        this.zoom = zoom;
        this.uuid = uuid;
        this.targetPos = null;
    }

    public ShootMessage(double spread, boolean zoom, @Nullable UUID uuid, Vector3f targetPos) {
        this.spread = spread;
        this.zoom = zoom;
        this.uuid = uuid;
        this.targetPos = targetPos;
    }

    public static ShootMessage decode(FriendlyByteBuf buffer) {
        double spread = buffer.readDouble();
        boolean zoom = buffer.readBoolean();
        UUID uuid = buffer.m_236860_(FriendlyByteBuf::m_130259_).orElse(null);
        boolean flag = buffer.readBoolean();
        if (flag) {
            return new ShootMessage(spread, zoom, uuid, buffer.m_269394_());
        }
        return new ShootMessage(spread, zoom, uuid);
    }

    public static void encode(ShootMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.spread);
        buffer.writeBoolean(message.zoom);
        buffer.m_236835_(Optional.ofNullable(message.uuid), FriendlyByteBuf::m_130077_);
        boolean flag = message.targetPos != null;
        buffer.writeBoolean(flag);
        if (flag) {
            buffer.m_269582_(message.targetPos);
        }
    }

    public static void handler(ShootMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ItemStack stack = player.m_21205_();
                if (!(stack.m_41720_() instanceof GunItem)) {
                    return;
                }
                if (message.targetPos == null) {
                    GunData.from(stack).shoot((Entity)player, message.spread, message.zoom, message.uuid);
                } else {
                    GunData.from(stack).shoot((Entity)player, message.spread, message.zoom, message.uuid, new Vec3(message.targetPos));
                }
            }
        });
        context.setPacketHandled(true);
    }
}

