/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public enum InteractMessage {
    INSTANCE;


    public static void handler(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() != null) {
                InteractMessage.handleInteract((Player)context.getSender());
            }
        });
        context.setPacketHandled(true);
    }

    public static void handleInteract(Player player) {
        DroneEntity drone;
        ItemStack stack = player.m_21205_();
        if (stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked") && !player.m_36335_().m_41519_(stack.m_41720_()) && (drone = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_("LinkedDrone"))) != null) {
            Vec3 looking = Vec3.m_82528_((Vec3i)player.m_9236_().m_45547_(new ClipContext(drone.m_146892_(), drone.m_146892_().m_82549_(drone.m_20154_().m_82490_(2.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_82425_());
            BlockPos blockPos = BlockPos.m_274561_((double)looking.m_7096_(), (double)looking.m_7098_(), (double)looking.m_7094_());
            player.m_9236_().m_8055_(blockPos).m_60664_(player.m_9236_(), player, InteractionHand.MAIN_HAND, BlockHitResult.m_82426_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (Direction)Direction.UP, (BlockPos)blockPos));
            Entity lookingEntity = TraceTool.findLookingEntity(drone, 2.0);
            if (lookingEntity == null) {
                return;
            }
            player.m_5706_(lookingEntity);
            player.m_36335_().m_41524_(stack.m_41720_(), 13);
        }
    }
}

