/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class AdjustMortarAngleMessage {
    private final double scroll;

    public AdjustMortarAngleMessage(double scroll) {
        this.scroll = scroll;
    }

    public static void encode(AdjustMortarAngleMessage message, FriendlyByteBuf byteBuf) {
        byteBuf.writeDouble(message.scroll);
    }

    public static AdjustMortarAngleMessage decode(FriendlyByteBuf byteBuf) {
        return new AdjustMortarAngleMessage(byteBuf.readDouble());
    }

    public static void handler(AdjustMortarAngleMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            Entity looking = TraceTool.findLookingEntity((Entity)player, 6.0);
            if (looking == null) {
                return;
            }
            if (looking instanceof MortarEntity) {
                MortarEntity mortar = (MortarEntity)looking;
                mortar.m_20088_().m_135381_(MortarEntity.TARGET_PITCH, (Object)Float.valueOf((float)Mth.m_14008_((double)((double)((Float)mortar.m_20088_().m_135370_(MortarEntity.TARGET_PITCH)).floatValue() + 0.5 * message.scroll), (double)-89.0, (double)-20.0)));
            }
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.ADJUST_FOV.get(), 1.0f, 0.7f);
        });
        context.get().setPacketHandled(true);
    }
}

