/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.ArtilleryIndicator;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ArtilleryEntity
extends GeoVehicleEntity {
    public static final EntityDataAccessor<IntList> BARREL_ANIM = SynchedEntityData.m_135353_(ArtilleryEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.INT_LIST_SERIALIZER.get()));
    public static final EntityDataAccessor<Vector3f> SHOOT_VEC = SynchedEntityData.m_135353_(ArtilleryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Boolean> DEPRESSED = SynchedEntityData.m_135353_(ArtilleryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Vector3f> TARGET_POS = SynchedEntityData.m_135353_(ArtilleryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.m_135353_(ArtilleryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ArtilleryEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.f_19804_.m_135381_(BARREL_ANIM, (Object)IntList.of((int[])new int[this.getMaxBarrel()]));
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        Item item;
        GunData gunData = this.getGunData("Main");
        if (gunData == null) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21205_();
        if (this.canBind() && (item = stack.m_41720_()) instanceof ArtilleryIndicator) {
            ArtilleryIndicator indicator = (ArtilleryIndicator)item;
            if (player.m_20201_() == this) {
                return InteractionResult.FAIL;
            }
            return indicator.bind(stack, player, this);
        }
        if (stack.m_204117_(ModTags.Items.TOOLS_CROWBAR) && !player.m_6144_()) {
            if (gunData.ammo.get() > 0 && player.m_9236_() instanceof ServerLevel) {
                this.vehicleShoot((LivingEntity)player, "Main");
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_21205_().m_41720_() == ModItems.FIRING_PARAMETERS.get() && player.m_6144_()) {
            this.setTarget(player.m_21205_(), (Entity)player, "Main");
            return InteractionResult.SUCCESS;
        }
        if (player.m_21206_().m_41720_() == ModItems.FIRING_PARAMETERS.get() && player.m_6144_()) {
            this.setTarget(player.m_21206_(), (Entity)player, "Main");
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.f_19804_.m_135381_(SHOOT_VEC, (Object)this.m_20156_().m_252839_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT_VEC, (Object)this.m_20156_().m_252839_());
        this.f_19804_.m_135372_(DEPRESSED, (Object)false);
        this.f_19804_.m_135372_(TARGET_POS, (Object)new Vector3f());
        this.f_19804_.m_135372_(RADIUS, (Object)0);
        this.f_19804_.m_135372_(BARREL_ANIM, (Object)IntList.of((int[])new int[4]));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("ShootVecX", ((Vector3f)this.f_19804_.m_135370_(ArtilleryEntity.SHOOT_VEC)).x);
        compound.m_128350_("ShootVecY", ((Vector3f)this.f_19804_.m_135370_(ArtilleryEntity.SHOOT_VEC)).y);
        compound.m_128350_("ShootVecZ", ((Vector3f)this.f_19804_.m_135370_(ArtilleryEntity.SHOOT_VEC)).z);
        compound.m_128379_("Depressed", ((Boolean)this.f_19804_.m_135370_(DEPRESSED)).booleanValue());
        compound.m_128405_("Radius", ((Integer)this.f_19804_.m_135370_(RADIUS)).intValue());
        compound.m_128350_("TargetX", ((Vector3f)this.f_19804_.m_135370_(ArtilleryEntity.TARGET_POS)).x);
        compound.m_128350_("TargetY", ((Vector3f)this.f_19804_.m_135370_(ArtilleryEntity.TARGET_POS)).y);
        compound.m_128350_("TargetZ", ((Vector3f)this.f_19804_.m_135370_(ArtilleryEntity.TARGET_POS)).z);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("ShootVecX") && compound.m_128441_("ShootVecY") && compound.m_128441_("ShootVecZ")) {
            this.f_19804_.m_135381_(SHOOT_VEC, (Object)new Vector3f(compound.m_128457_("ShootVecX"), compound.m_128457_("ShootVecY"), compound.m_128457_("ShootVecZ")));
        }
        if (compound.m_128441_("Depressed")) {
            this.f_19804_.m_135381_(DEPRESSED, (Object)compound.m_128471_("Depressed"));
        }
        if (compound.m_128441_("Radius")) {
            this.f_19804_.m_135381_(RADIUS, (Object)compound.m_128451_("Radius"));
        }
        if (compound.m_128441_("TargetX") && compound.m_128441_("TargetY") && compound.m_128441_("TargetZ")) {
            this.f_19804_.m_135381_(TARGET_POS, (Object)new Vector3f(compound.m_128457_("TargetX"), compound.m_128457_("TargetX"), compound.m_128457_("TargetZ")));
        }
    }

    public void setTarget(ItemStack stack, Entity entity, String weaponName) {
        GunData data = this.getGunData(weaponName);
        if (data == null) {
            return;
        }
        double targetX = stack.m_41784_().m_128459_("TargetX");
        double targetY = stack.m_41784_().m_128459_("TargetY");
        double targetZ = stack.m_41784_().m_128459_("TargetZ");
        boolean canAim = true;
        this.f_19804_.m_135381_(TARGET_POS, (Object)new Vector3f((float)targetX, (float)targetY, (float)targetZ));
        this.f_19804_.m_135381_(DEPRESSED, (Object)stack.m_41784_().m_128471_("IsDepressed"));
        this.f_19804_.m_135381_(RADIUS, (Object)stack.m_41784_().m_128451_("Radius"));
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.f_19804_.m_135370_(TARGET_POS)), (Integer)this.f_19804_.m_135370_(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.getShootPos(weaponName, 1.0f), randomPos, this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName), (Boolean)this.f_19804_.m_135370_(DEPRESSED));
        MutableComponent component = Component.m_237113_((String)"");
        MutableComponent location = Component.m_237110_((String)"tips.superbwarfare.mortar.position", (Object[])new Object[]{this.m_5446_()}).m_7220_((Component)Component.m_237113_((String)(" X:" + FormatTool.format0D(this.m_20185_()) + " Y:" + FormatTool.format0D(this.m_20186_()) + " Z:" + FormatTool.format0D(this.m_20189_()) + " ")));
        if (launchVector == null) {
            canAim = false;
            component = Component.m_237115_((String)"tips.superbwarfare.mortar.out_of_range");
        } else {
            float angle = (float)(-VehicleVecUtils.getXRotFromVector(launchVector));
            if (angle < -this.getTurretMaxPitch() || angle > -this.getTurretMinPitch()) {
                canAim = false;
                component = Component.m_237110_((String)"tips.superbwarfare.mortar.warn", (Object[])new Object[]{this.m_5446_()});
                if (angle < -this.getTurretMaxPitch()) {
                    component = Component.m_237115_((String)"tips.superbwarfare.ballistics.warn");
                }
            }
        }
        if (canAim) {
            this.f_19804_.m_135381_(SHOOT_VEC, (Object)launchVector.m_252839_());
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)location.m_6881_().m_7220_((Component)component).m_130940_(ChatFormatting.RED), false);
        }
    }

    public void resetTarget(String weaponName) {
        GunData data = this.getGunData(weaponName);
        if (data == null) {
            return;
        }
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.f_19804_.m_135370_(TARGET_POS)), (Integer)this.f_19804_.m_135370_(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.getShootPos(weaponName, 1.0f), randomPos, this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName), (Boolean)this.f_19804_.m_135370_(DEPRESSED));
        if (launchVector == null) {
            return;
        }
        float angle = (float)(-VehicleVecUtils.getXRotFromVector(launchVector));
        if (angle > -this.getTurretMaxPitch() && angle < -this.getTurretMinPitch()) {
            this.f_19804_.m_135381_(SHOOT_VEC, (Object)launchVector.m_252839_());
        }
    }

    public int getMaxBarrel() {
        GunData data = this.getGunData("Main");
        if (data != null) {
            return data.compute().magazine;
        }
        return 1;
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        for (int i = 0; i < this.getMaxBarrel(); ++i) {
            IntList animCounters = (IntList)this.f_19804_.m_135370_(BARREL_ANIM);
            if (i >= animCounters.size() || animCounters.getInt(i) <= 0) continue;
            int[] barrelAnim = animCounters.toIntArray();
            barrelAnim[i] = animCounters.getInt(i) - 1;
            this.f_19804_.m_135381_(BARREL_ANIM, (Object)IntList.of((int[])barrelAnim));
        }
        Entity controller = this.getNthEntity(this.getTurretControllerIndex());
        if (controller != null) {
            this.f_19804_.m_135381_(SHOOT_VEC, (Object)controller.m_20252_(1.0f).m_252839_());
        } else {
            this.turretAutoAimFromVector(new Vec3((Vector3f)this.f_19804_.m_135370_(SHOOT_VEC)));
        }
    }

    @Override
    public void vehicleShoot(LivingEntity living, String weaponName) {
        this.beforeShoot(living);
        super.vehicleShoot(living, weaponName);
    }

    @Override
    public void vehicleShoot(LivingEntity living, UUID uuid, Vec3 targetPos) {
        this.beforeShoot(living);
        super.vehicleShoot(living, uuid, targetPos);
    }

    public void beforeShoot(LivingEntity living) {
        Level level;
        GunData data = this.getGunData("Main");
        if (data != null && data.ammo.get() > 0) {
            int[] barrelAnim = ((IntList)this.f_19804_.m_135370_(BARREL_ANIM)).toIntArray();
            barrelAnim[data.ammo.get() - 1] = data.compute().shootAnimationTime;
            this.f_19804_.m_135381_(BARREL_ANIM, (Object)IntList.of((int[])barrelAnim));
        }
        if ((level = living.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ParticleTool.spawnBigCannonMuzzleParticles(this.getShootVec("Main", 1.0f), this.getShootPos("Main", 1.0f), level2, this);
        }
    }

    public boolean canBind() {
        return false;
    }
}

