/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.CustomData;
import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.data.JsonPropertyModifier;
import com.atsuishio.superbwarfare.data.StringOrVec3;
import com.atsuishio.superbwarfare.data.gun.AmmoConsumer;
import com.atsuishio.superbwarfare.data.gun.DamageReduce;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.FireModeInfo;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.data.gun.ShootParameters;
import com.atsuishio.superbwarfare.data.gun.subdata.AmmoSlot;
import com.atsuishio.superbwarfare.data.gun.subdata.Attachment;
import com.atsuishio.superbwarfare.data.gun.subdata.Bolt;
import com.atsuishio.superbwarfare.data.gun.subdata.Charge;
import com.atsuishio.superbwarfare.data.gun.subdata.Perks;
import com.atsuishio.superbwarfare.data.gun.subdata.Reload;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.data.gun.value.BooleanValue;
import com.atsuishio.superbwarfare.data.gun.value.DoubleValue;
import com.atsuishio.superbwarfare.data.gun.value.IntValue;
import com.atsuishio.superbwarfare.data.gun.value.ReloadState;
import com.atsuishio.superbwarfare.data.gun.value.StringEnumValue;
import com.atsuishio.superbwarfare.data.gun.value.StringValue;
import com.atsuishio.superbwarfare.event.GunEventHandler;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;

public class GunData
implements DefaultDataSupplier<DefaultGunData> {
    public static final LoadingCache<ItemStack, GunData> DATA_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<ItemStack, GunData>(){

        @NotNull
        public GunData load(@NotNull ItemStack stack) {
            return new GunData(stack);
        }
    });
    public final ItemStack stack;
    public final GunItem item;
    public final CompoundTag tag;
    public final CompoundTag gunDataTag;
    public final CompoundTag perkTag;
    public final CompoundTag attachmentTag;
    public final StringValue propertyOverrideString;
    public final String id;
    @NotNull
    public Supplier<DefaultGunData> defaultDataSupplier;
    private final JsonPropertyModifier<GunData, DefaultGunData> jsonPropModifier = new JsonPropertyModifier();
    private DefaultGunData cache = null;
    private Function<DefaultGunData, DefaultGunData> tempModifications = null;
    public final IntValue selectedAmmoType;
    public final IntValue ammo;
    public final IntValue virtualAmmo;
    public final IntValue backupAmmoCount;
    public final AmmoSlot ammoSlot;
    public final IntValue burstAmount;
    public final IntValue selectedFireMode;
    public final IntValue fireIndex;
    public final IntValue level;
    public final DoubleValue exp;
    public final DoubleValue heat;
    public final IntValue shootAnimationTimer;
    public final IntValue shootTimer;
    public final BooleanValue overHeat;
    public final Reload reload;
    public final Charge charge;
    public final BooleanValue isEmpty;
    public final BooleanValue closeHammer;
    public final BooleanValue closeStrike;
    public final BooleanValue stopped;
    public final BooleanValue forceStop;
    public final IntValue loadIndex;
    public final BooleanValue holdOpen;
    public final BooleanValue hideBulletChain;
    public final IntValue sensitivity;
    public final BooleanValue zooming;
    public final Bolt bolt;
    public final Attachment attachment;
    public final Perks perk;
    @Deprecated(forRemoval=true, since="0.8.9")
    public final StringEnumValue<FireMode> fireMode = new FireModeGetter();

    private GunData(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof GunItem)) {
            throw new IllegalArgumentException("stack is not GunItem!");
        }
        GunItem gunItem = (GunItem)item;
        this.item = gunItem;
        this.stack = stack;
        this.id = GunData.getRegistryId(stack.m_41720_());
        this.defaultDataSupplier = () -> gunItem.getDefaultData(this);
        this.tag = stack.m_41784_();
        this.gunDataTag = this.getOrPut("GunData");
        this.perkTag = this.getOrPut("Perks");
        this.attachmentTag = this.getOrPut("Attachments");
        this.propertyOverrideString = new StringValue(this.gunDataTag, "Override");
        this.selectedAmmoType = new IntValue(this.gunDataTag, "SelectedAmmoType");
        this.selectedFireMode = new IntValue(this.gunDataTag, "SelectedFireMode", 0);
        this.fireIndex = new IntValue(this.gunDataTag, "FireIndex", 0);
        this.reload = new Reload(this);
        this.charge = new Charge(this);
        this.bolt = new Bolt(this);
        this.attachment = new Attachment(this);
        this.perk = new Perks(this);
        this.ammo = new IntValue(this.gunDataTag, "Ammo");
        this.virtualAmmo = new IntValue(this.gunDataTag, "VirtualAmmo");
        this.backupAmmoCount = new IntValue(this.gunDataTag, "BackupAmmoCount");
        this.ammoSlot = new AmmoSlot(this.gunDataTag);
        this.burstAmount = new IntValue(this.gunDataTag, "BurstAmount");
        this.level = new IntValue(this.gunDataTag, "Level");
        this.exp = new DoubleValue(this.gunDataTag, "Exp");
        this.isEmpty = new BooleanValue(this.gunDataTag, "IsEmpty");
        this.closeHammer = new BooleanValue(this.gunDataTag, "CloseHammer");
        this.closeStrike = new BooleanValue(this.gunDataTag, "CloseStrike");
        this.stopped = new BooleanValue(this.gunDataTag, "Stopped");
        this.forceStop = new BooleanValue(this.gunDataTag, "ForceStop");
        this.loadIndex = new IntValue(this.gunDataTag, "LoadIndex");
        this.holdOpen = new BooleanValue(this.gunDataTag, "HoldOpen");
        this.hideBulletChain = new BooleanValue(this.gunDataTag, "HideBulletChain");
        this.sensitivity = new IntValue(this.gunDataTag, "Sensitivity");
        this.heat = new DoubleValue(this.gunDataTag, "Heat");
        this.shootAnimationTimer = new IntValue(this.gunDataTag, "ShootAnimationTimer");
        this.shootTimer = new IntValue(this.gunDataTag, "ShootTimer");
        this.overHeat = new BooleanValue(this.gunDataTag, "OverHeat");
        this.zooming = new BooleanValue(this.gunDataTag, "Zooming");
        String defaultFireMode = this.compute((boolean)false).defaultFireMode;
        if (defaultFireMode == null) {
            defaultFireMode = FireMode.SEMI.name;
        }
        List<FireModeInfo> fireModes = this.compute(false).availableFireModes();
        for (int i = 0; i < fireModes.size(); ++i) {
            if (!fireModes.get((int)i).name.equals(defaultFireMode)) continue;
            this.selectedFireMode.defaultValue = i;
            break;
        }
    }

    private CompoundTag getOrPut(String name) {
        CompoundTag tag;
        if (!this.tag.m_128441_(name)) {
            tag = new CompoundTag();
            this.tag.m_128365_(name, (Tag)tag);
        } else {
            tag = this.tag.m_128469_(name);
        }
        return tag;
    }

    public boolean initialized() {
        return this.item.isInitialized(this);
    }

    public void initialize() {
        this.item.init(this);
    }

    public static GunData create(Item item) {
        return GunData.from(new ItemStack((ItemLike)item));
    }

    public static GunData from(ItemStack stack) {
        return (GunData)DATA_CACHE.getUnchecked((Object)stack);
    }

    public GunItem item() {
        return this.item;
    }

    public ItemStack stack() {
        return this.stack;
    }

    public CompoundTag tag() {
        return this.tag;
    }

    public CompoundTag data() {
        return this.gunDataTag;
    }

    public CompoundTag perk() {
        return this.perkTag;
    }

    public CompoundTag attachment() {
        return this.attachmentTag;
    }

    public static DefaultGunData getDefault(String id) {
        boolean isDefault = !CustomData.GUN_DATA.containsKey(id);
        DefaultGunData data = CustomData.GUN_DATA.getOrElseGet(id, DefaultGunData::new);
        data.isDefaultData = isDefault;
        return data;
    }

    @Override
    public DefaultGunData getDefault() {
        return this.defaultDataSupplier.get();
    }

    public static DefaultGunData getDefault(ItemStack stack) {
        return GunData.getDefault(stack.m_41720_());
    }

    public static DefaultGunData getDefault(Item item) {
        return GunData.getDefault(GunData.getRegistryId(item));
    }

    public static String getRegistryId(Item item) {
        String id = item.m_5524_();
        id = id.substring(id.indexOf(".") + 1).replace('.', ':');
        return id;
    }

    public void setTempModifications(Function<DefaultGunData, DefaultGunData> modification) {
        this.tempModifications = modification;
        this.update();
    }

    public void clearTempModifications() {
        this.tempModifications = null;
    }

    public static DefaultGunData compute(ItemStack stack) {
        return GunData.from(stack).compute();
    }

    public DefaultGunData compute() {
        return this.compute(true);
    }

    public DefaultGunData compute(boolean useCache) {
        if (this.cache != null && useCache) {
            return this.cache;
        }
        DefaultGunData rawData = (DefaultGunData)this.getDefault().copy();
        this.jsonPropModifier.update(this.propertyOverrideString.get());
        rawData = this.jsonPropModifier.computeProperties(this, rawData);
        rawData = this.item.computeProperties(this, rawData);
        rawData = this.selectedFireModeInfo(rawData.availableFireModes()).computeProperties(this, rawData);
        rawData = this.selectedAmmoConsumer(rawData.getAmmoConsumers()).computeProperties(this, rawData);
        if (this.perk != null) {
            for (Perk.Type type : Perk.Type.values()) {
                Perk instance = this.perk.get(type);
                if (instance == null) continue;
                rawData = instance.computeProperties(this, rawData);
            }
        }
        if (this.tempModifications != null) {
            rawData = this.tempModifications.apply(rawData);
        }
        rawData.limit();
        if (useCache) {
            this.cache = rawData;
        }
        return rawData;
    }

    public void update() {
        this.cache = null;
    }

    @Deprecated(forRemoval=true)
    public <T> T get(GunProp<T> prop) {
        return (T)prop.asModifier(this).compute(this.compute());
    }

    public boolean hasInfiniteBackupAmmo(@Nullable Entity shooter) {
        Player player;
        return shooter instanceof Player && (player = (Player)shooter).m_7500_() || this.selectedAmmoConsumer().type == AmmoConsumer.AmmoConsumeType.INFINITE || this.meleeOnly() || InventoryTool.hasCreativeAmmoBox(shooter);
    }

    public boolean useBackpackAmmo() {
        return this.compute().magazine <= 0;
    }

    public double minZoom() {
        int scopeType = this.attachment.get(AttachmentType.SCOPE);
        return scopeType == 3 ? Math.max(this.getDefault().minZoom, 1.25) : 1.25;
    }

    public double maxZoom() {
        int scopeType = this.attachment.get(AttachmentType.SCOPE);
        return scopeType == 3 ? this.getDefault().maxZoom : 114514.0;
    }

    public double zoom() {
        if (this.minZoom() >= this.maxZoom()) {
            return this.compute().defaultZoom;
        }
        return Mth.m_14008_((double)this.compute().defaultZoom, (double)this.minZoom(), (double)this.maxZoom());
    }

    public AmmoConsumer selectedAmmoConsumer(List<AmmoConsumer> consumers) {
        if (consumers == null || consumers.isEmpty()) {
            return AmmoConsumer.INVALID;
        }
        return consumers.get(Mth.m_14045_((int)this.selectedAmmoType.get(), (int)0, (int)(consumers.size() - 1)));
    }

    public AmmoConsumer selectedAmmoConsumer() {
        return this.selectedAmmoConsumer(this.compute().getAmmoConsumers());
    }

    public void changeAmmoConsumer(int index, @Nullable Entity ammoSupplier) {
        Player player;
        List<AmmoConsumer> consumers = this.compute().getAmmoConsumers();
        int targetIndex = Mth.m_14045_((int)index, (int)0, (int)(consumers.size() - 1));
        if (targetIndex == this.selectedAmmoType.get()) {
            return;
        }
        if (!(ammoSupplier instanceof Player) || !(player = (Player)ammoSupplier).m_7500_()) {
            AmmoConsumer currentConsumer = this.selectedAmmoConsumer();
            AmmoConsumer targetConsumer = consumers.get(this.selectedAmmoType.get());
            String currentSlot = currentConsumer.ammoSlot;
            String targetSlot = targetConsumer.ammoSlot;
            if (currentSlot == null) {
                currentSlot = "Default";
            }
            if (targetSlot == null) {
                targetSlot = "Default";
            }
            if (currentSlot.equals(targetSlot) && ammoSupplier != null && targetConsumer.shouldUnload) {
                this.withdrawAmmo(ammoSupplier);
            } else {
                int ammo = this.ammo.get();
                int virtualAmmo = this.virtualAmmo.get();
                this.ammoSlot.set(currentSlot, ammo, virtualAmmo);
                this.ammo.set(this.ammoSlot.getAmmo(targetSlot));
                this.virtualAmmo.set(this.ammoSlot.getVirtualAmmo(targetSlot));
                this.ammoSlot.reset(targetSlot);
            }
        }
        this.selectedAmmoType.set(targetIndex);
        if (ammoSupplier instanceof Player && (player = (Player)ammoSupplier).m_7500_()) {
            this.ammo.set(this.compute().magazine);
        }
        this.item.whenNoAmmo(this);
        this.closeHammer.set(false);
        this.fireIndex.reset();
        this.resetStatus();
    }

    public void resetStatus() {
        this.reload.stage.reset();
        this.reload.setState(ReloadState.NOT_RELOADING);
        this.reload.iterativeLoadTimer.reset();
        this.reload.reloadTimer.reset();
        this.reload.finishTimer.reset();
        this.reload.prepareTimer.reset();
        this.reload.prepareLoadTimer.reset();
        this.reload.reloadStarter.finish();
        this.reload.singleReloadStarter.finish();
        this.reload.singleReloadStarter.finish();
        this.bolt.actionTimer.reset();
        this.bolt.needed.reset();
        this.charge.starter.finish();
        this.charge.timer.reset();
    }

    public FireModeInfo selectedFireModeInfo(List<FireModeInfo> fireModes) {
        if (fireModes == null || fireModes.isEmpty()) {
            return new FireModeInfo();
        }
        return fireModes.get(Mth.m_14045_((int)this.selectedFireMode.get(), (int)0, (int)(fireModes.size() - 1)));
    }

    public FireModeInfo selectedFireModeInfo() {
        return this.selectedFireModeInfo(this.compute().availableFireModes());
    }

    public boolean shouldStartReloading(@Nullable Entity entity) {
        return !this.reloading() && !this.useBackpackAmmo() && !this.hasEnoughAmmoToShoot(entity) && this.hasBackupAmmo(entity);
    }

    public boolean shouldStartBolt() {
        return this.bolt.actionTimer.get() == 0 && this.bolt.needed.get();
    }

    public void startReload() {
        this.reload.reloadStarter.markStart();
    }

    public void startBolt() {
        this.bolt.actionTimer.set(this.compute().boltActionTime + 1);
    }

    public boolean hasBackupAmmo(@Nullable Entity entity) {
        return this.countBackupAmmo(entity) > 0;
    }

    public int countBackupAmmo(@Nullable Entity entity) {
        Player player;
        if (entity == null) {
            return this.virtualAmmo.get();
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_() || InventoryTool.hasCreativeAmmoBox(entity)) {
            return Integer.MAX_VALUE;
        }
        return Math.toIntExact(Math.min((long)this.countBackupAmmoItem(entity) * (long)this.selectedAmmoConsumer().loadAmount + (long)this.virtualAmmo.get(), Integer.MAX_VALUE));
    }

    public int countBackupAmmo(@Nullable IItemHandler handler) {
        if (handler == null) {
            return this.virtualAmmo.get();
        }
        if (InventoryTool.hasCreativeAmmoBox(handler)) {
            return Integer.MAX_VALUE;
        }
        return Math.toIntExact(Math.min((long)this.countBackupAmmoItem(handler) * (long)this.selectedAmmoConsumer().loadAmount + (long)this.virtualAmmo.get(), Integer.MAX_VALUE));
    }

    public int countBackupAmmoItem(@Nullable Entity entity) {
        return this.selectedAmmoConsumer().count(this, entity);
    }

    public int countBackupAmmoItem(@Nullable IItemHandler handler) {
        return this.selectedAmmoConsumer().count(this, handler);
    }

    public void consumeBackupAmmo(@Nullable Entity entity, int count) {
        Player player;
        if (count <= 0 || entity instanceof Player && (player = (Player)entity).m_7500_() || InventoryTool.hasCreativeAmmoBox(entity)) {
            return;
        }
        if (this.virtualAmmo.get() > 0) {
            int consumed = Math.min(this.virtualAmmo.get(), count);
            this.virtualAmmo.add(-consumed);
            count -= consumed;
            this.save();
        }
        if (count <= 0 || entity == null) {
            return;
        }
        AmmoConsumer consumer = this.selectedAmmoConsumer();
        int loadAmount = consumer.loadAmount;
        if (count % loadAmount != 0) {
            int required;
            int consumed;
            if ((count -= (consumed = consumer.consume(this, entity, required = count / loadAmount + 1)) * loadAmount) <= 0) {
                this.virtualAmmo.add(-count);
            }
        } else {
            consumer.consume(this, entity, count / loadAmount);
        }
    }

    public void consumeBackupAmmo(@Nullable IItemHandler handler, int count) {
        if (count <= 0 || InventoryTool.hasCreativeAmmoBox(handler)) {
            return;
        }
        if (this.virtualAmmo.get() > 0) {
            int consumed = Math.min(this.virtualAmmo.get(), count);
            this.virtualAmmo.add(-consumed);
            count -= consumed;
            this.save();
        }
        if (count <= 0 || handler == null) {
            return;
        }
        AmmoConsumer consumer = this.selectedAmmoConsumer();
        int loadAmount = consumer.loadAmount;
        if (count % loadAmount != 0) {
            int required;
            int consumed;
            if ((count -= (consumed = consumer.consume(this, handler, required = count / loadAmount + 1)) * loadAmount) <= 0) {
                this.virtualAmmo.add(-count);
            }
        } else {
            consumer.consume(this, handler, count / loadAmount);
        }
    }

    public int currentAvailableShots(@Nullable Entity entity) {
        int ammoCost = this.compute().ammoCostPerShoot;
        if (ammoCost <= 0) {
            return Integer.MAX_VALUE;
        }
        return this.currentAvailableAmmo(entity) / ammoCost;
    }

    public int currentAvailableAmmo(@Nullable Entity entity) {
        return this.useBackpackAmmo() ? this.countBackupAmmo(entity) : this.ammo.get();
    }

    public boolean hasEnoughAmmoToShoot(@Nullable Entity entity) {
        return this.compute().ammoCostPerShoot <= this.currentAvailableAmmo(entity);
    }

    public void reloadAmmo(@Nullable Entity entity) {
        this.reloadAmmo(entity, false);
    }

    public void reloadAmmo(@Nullable Entity entity, boolean extraOne) {
        if (this.useBackpackAmmo()) {
            return;
        }
        int mag = this.compute().magazine;
        int ammo = this.ammo.get();
        int ammoNeeded = mag - ammo + (extraOne ? 1 : 0);
        if (ammo == 0 && this.compute().boltActionTime > 0) {
            this.bolt.needed.set(false);
        }
        int available = this.countBackupAmmo(entity);
        int ammoToAdd = Math.min(ammoNeeded, available);
        this.consumeBackupAmmo(entity, ammoToAdd);
        this.ammo.set(ammo + ammoToAdd);
        this.reload.setState(ReloadState.NOT_RELOADING);
        this.fireIndex.reset();
    }

    public boolean canShoot(@Nullable Entity shooter) {
        return this.item.canShoot(this, shooter);
    }

    public void shoot(@NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, double spread, boolean zoom) {
        this.item.shoot(level, shootPosition, shootDirection, this, spread, zoom, null);
    }

    public void shoot(@NotNull Entity entity, double spread, boolean zoom, @Nullable UUID uuid) {
        this.item.shoot(this, entity, spread, zoom, uuid);
    }

    public void shoot(@NotNull Entity entity, double spread, boolean zoom, @Nullable UUID uuid, @Nullable Vec3 targetPos) {
        this.item.shoot(this, entity, spread, zoom, uuid, targetPos);
    }

    public void shoot(@NotNull ShootParameters parameters) {
        this.item.shoot(parameters);
    }

    public void tick(@Nullable Entity shooter, boolean inMainHand) {
        GunEventHandler.gunTick(shooter, this, inMainHand);
    }

    public void withdrawAmmo(@NotNull Entity ammoSupplier) {
        int itemAmount = this.withdrawAmmoCount();
        this.virtualAmmo.reset();
        this.ammo.reset();
        this.selectedAmmoConsumer().withdraw(ammoSupplier, itemAmount);
    }

    public int withdrawAmmoCount() {
        return (this.virtualAmmo.get() + this.ammo.get()) / this.selectedAmmoConsumer().loadAmount;
    }

    public void withdrawAmmo(@NotNull IItemHandler handler) {
        int itemAmount = this.withdrawAmmoCount();
        this.virtualAmmo.reset();
        this.ammo.reset();
        this.selectedAmmoConsumer().withdraw(handler, itemAmount);
    }

    private static int getPerkPriority(String s) {
        if (s == null || s.isEmpty()) {
            return 2;
        }
        return switch (s.charAt(0)) {
            case '@' -> 0;
            case '!' -> 2;
            default -> 1;
        };
    }

    public List<Perk> availablePerks() {
        ArrayList<Perk> availablePerks = new ArrayList<Perk>();
        List<String> perkNames = this.compute().availablePerks();
        if (perkNames == null || perkNames.isEmpty()) {
            return availablePerks;
        }
        ArrayList<String> sortedNames = new ArrayList<String>(perkNames);
        sortedNames.sort((s1, s2) -> {
            int p2;
            int p1 = GunData.getPerkPriority(s1);
            if (p1 != (p2 = GunData.getPerkPriority(s2))) {
                return Integer.compare(p1, p2);
            }
            return s1.compareTo((String)s2);
        });
        Set perks = RegistryManager.ACTIVE.getRegistry(ModPerks.PERK_KEY).getEntries();
        List<Perk> perkValues = perks.stream().map(Map.Entry::getValue).toList();
        List<String> perkKeys = perks.stream().map(perk -> ((ResourceKey)perk.getKey()).m_135782_().toString()).toList();
        for (String name : sortedNames) {
            if (name.startsWith("@")) {
                String type;
                switch (type = name.substring(1)) {
                    case "Ammo": {
                        availablePerks.addAll(perkValues.stream().filter(perk -> perk.type == Perk.Type.AMMO).toList());
                        break;
                    }
                    case "Functional": {
                        availablePerks.addAll(perkValues.stream().filter(perk -> perk.type == Perk.Type.FUNCTIONAL).toList());
                        break;
                    }
                    case "Damage": {
                        availablePerks.addAll(perkValues.stream().filter(perk -> perk.type == Perk.Type.DAMAGE).toList());
                    }
                }
                continue;
            }
            if (name.startsWith("!")) {
                String n = name.substring(1);
                int index = perkKeys.indexOf(n);
                if (index != -1) {
                    availablePerks.remove(perkValues.get(index));
                    continue;
                }
                Mod.LOGGER.info("Perk {} not found", (Object)n);
                continue;
            }
            int index = perkKeys.indexOf(name);
            if (index != -1) {
                availablePerks.add(perkValues.get(index));
                continue;
            }
            Mod.LOGGER.info("Perk {} not found", (Object)name);
        }
        return availablePerks;
    }

    public boolean canApplyPerk(Perk perk) {
        return this.availablePerks().contains(perk);
    }

    public DamageReduce getRawDamageReduce() {
        return this.getDefault().damageReduce;
    }

    public double getDamageReduceRate() {
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = this.perk.getInstance(type);
            if (instance == null) continue;
            return instance.perk().getModifiedDamageReduceRate(this.getRawDamageReduce());
        }
        return this.getRawDamageReduce().getRate();
    }

    public double getDamageReduceMinDistance() {
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = this.perk.getInstance(type);
            if (instance == null) continue;
            return instance.perk().getModifiedDamageReduceMinDistance(this.getRawDamageReduce());
        }
        return this.getRawDamageReduce().getMinDistance();
    }

    public boolean meleeOnly() {
        return this.compute().projectileAmount <= 0 && this.compute().meleeDamage > 0.0;
    }

    public boolean isShotgun(DefaultGunData gunData) {
        return gunData.projectileAmount > 1;
    }

    public boolean isShotgun() {
        return this.isShotgun(this.compute());
    }

    public Vec3 firePosition() {
        List<Vec3> list = this.compute().shootPos.positions;
        int size = list.size();
        if (size == 0) {
            return Vec3.f_82478_;
        }
        if (this.compute().shootPos.boundUpWithAmmoAmount) {
            return list.get(Mth.m_14045_((int)(this.ammo.get() - 1), (int)0, (int)size));
        }
        return list.get(this.fireIndex.get() % size);
    }

    public Vec3 firePositionForHud() {
        if (this.compute().shootPos.shootPositionForHud != null) {
            return this.compute().shootPos.shootPositionForHud;
        }
        return this.firePosition();
    }

    public StringOrVec3 fireDirection() {
        List<StringOrVec3> list = this.compute().shootPos.directions;
        int size = list.size();
        if (size == 0) {
            return new StringOrVec3("Default");
        }
        return list.get(this.fireIndex.get() % size);
    }

    public StringOrVec3 fireDirectionForHud() {
        return this.compute().shootPos.shootDirectionForHud;
    }

    public LazyOptional<IEnergyStorage> getEnergyProvider(@Nullable Entity ammoSupplier) {
        return this.item.getEnergyProvider(this, ammoSupplier);
    }

    public void shakePlayers(@Nullable Entity source) {
        if (source == null) {
            return;
        }
        Vec3 shootShake = this.compute().shootShake;
        if (shootShake == null) {
            return;
        }
        ShakeClientMessage.sendToNearbyPlayers(source, shootShake.f_82479_, shootShake.f_82480_, shootShake.f_82481_);
    }

    public boolean canAdjustZoom() {
        return this.item.canAdjustZoom(this);
    }

    public boolean canSwitchScope() {
        return this.item.canSwitchScope(this);
    }

    public boolean reloading() {
        return this.reload.state() != ReloadState.NOT_RELOADING;
    }

    public boolean charging() {
        return this.charge.time() > 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GunData)) {
            return false;
        }
        GunData otherData = (GunData)obj;
        return ItemStack.m_150942_((ItemStack)otherData.stack, (ItemStack)this.stack);
    }

    public void save() {
        this.update();
    }

    public GunData copy() {
        GunData data = GunData.from(this.stack.m_41777_());
        data.defaultDataSupplier = this.defaultDataSupplier;
        return data;
    }

    @Deprecated(forRemoval=true, since="0.8.9")
    public class FireModeGetter
    extends StringEnumValue<FireMode> {
        public FireModeGetter() {
            super(new CompoundTag(), "DeprecatedFireMode", FireMode.SEMI, str -> FireMode.SEMI);
        }

        @Override
        public FireMode get() {
            return GunData.this.selectedFireModeInfo().mode;
        }
    }
}

