/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.compat.jei;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.compat.jei.GunPerksCategory;
import com.atsuishio.superbwarfare.compat.jei.PotionMortarShellRecipeMaker;
import com.atsuishio.superbwarfare.compat.jei.VehicleAssemblingCategory;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class SbwJEIPlugin
implements IModPlugin {
    private static IJeiRuntime jeiRuntime;

    @NotNull
    public ResourceLocation getPluginUid() {
        return Mod.loc("jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        SbwJEIPlugin.jeiRuntime = jeiRuntime;
    }

    public static Optional<IJeiRuntime> getJeiRuntime() {
        return Optional.ofNullable(jeiRuntime);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new GunPerksCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new VehicleAssemblingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.REFORGING_TABLE.get()), new RecipeType[]{GunPerksCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.VEHICLE_ASSEMBLING_TABLE.get()), new RecipeType[]{VehicleAssemblingCategory.TYPE});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        RecipeManager recipeManager = level.m_7465_();
        List<ItemStack> guns = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof GunItem).map(Item::m_7968_).toList();
        registration.addRecipes(GunPerksCategory.TYPE, guns);
        registration.addRecipes(VehicleAssemblingCategory.TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.VEHICLE_ASSEMBLING_TYPE.get()));
        registration.addItemStackInfo(new ItemStack((ItemLike)ModItems.ANCIENT_CPU.get()), new Component[]{Component.m_237115_((String)"jei.superbwarfare.ancient_cpu")});
        registration.addItemStackInfo(new ItemStack((ItemLike)ModItems.CHARGING_STATION.get()), new Component[]{Component.m_237115_((String)"jei.superbwarfare.charging_station")});
        List<CraftingRecipe> specialCraftingRecipes = PotionMortarShellRecipeMaker.createRecipes();
        registration.addRecipes(RecipeTypes.CRAFTING, specialCraftingRecipes);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.CONTAINER.get(), (ingredient, context) -> {
            if (ingredient.m_41783_() == null) {
                return "";
            }
            return ingredient.m_41783_().m_128469_("BlockEntityTag").m_128461_("EntityType");
        });
        registration.registerSubtypeInterpreter((Item)ModItems.POTION_MORTAR_SHELL.get(), (stack, context) -> {
            if (!stack.m_41782_()) {
                return "";
            }
            Potion potionType = PotionUtils.m_43579_((ItemStack)stack);
            String potionTypeString = potionType.m_43492_("");
            StringBuilder stringBuilder = new StringBuilder(potionTypeString);
            List effects = PotionUtils.m_43547_((ItemStack)stack);
            for (MobEffectInstance effect : effects) {
                stringBuilder.append(";").append(effect);
            }
            return stringBuilder.toString();
        });
        registration.registerSubtypeInterpreter((Item)ModItems.C4_BOMB.get(), (ingredient, context) -> {
            if (ingredient.m_41783_() == null) {
                return "";
            }
            return String.valueOf(ingredient.m_41783_().m_128471_("Control"));
        });
    }

    public static boolean showRecipes(ItemStack itemStack) {
        boolean[] result = new boolean[]{false};
        SbwJEIPlugin.getJeiRuntime().ifPresent(jeiRuntime -> jeiRuntime.getIngredientManager().getIngredientTypeChecked((Object)itemStack).ifPresent(type -> {
            jeiRuntime.getRecipesGui().show(jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, type, (Object)itemStack));
            result[0] = true;
        }));
        return result[0];
    }
}

