/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.capability.energy;

import com.atsuishio.superbwarfare.capability.energy.DynamicEnergyStorage;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;

public class ItemEnergyStorage
extends DynamicEnergyStorage {
    private static final String NBT_ENERGY = "Energy";
    private final ItemStack stack;

    public ItemEnergyStorage(ItemStack stack, int capacity) {
        this(stack, capacity, capacity, capacity);
    }

    public ItemEnergyStorage(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
        this(stack, s -> capacity, s -> maxReceive, s -> maxExtract);
    }

    public ItemEnergyStorage(ItemStack stack, Function<ItemStack, Integer> capacityGetter, Function<ItemStack, Integer> maxReceiveGetter, Function<ItemStack, Integer> maxExtractGetter) {
        super(() -> (Integer)capacityGetter.apply(stack), () -> (Integer)maxReceiveGetter.apply(stack), () -> (Integer)maxExtractGetter.apply(stack));
        this.stack = stack;
        if (stack.m_41783_() != null) {
            this.energy = stack.m_41782_() && stack.m_41783_().m_128441_(NBT_ENERGY) ? stack.m_41783_().m_128451_(NBT_ENERGY) : 0;
        }
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = super.receiveEnergy(maxReceive, simulate);
        if (received > 0 && !simulate) {
            this.stack.m_41784_().m_128405_(NBT_ENERGY, this.getEnergyStored());
        }
        return received;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = super.extractEnergy(maxExtract, simulate);
        if (extracted > 0 && !simulate) {
            this.stack.m_41784_().m_128405_(NBT_ENERGY, this.getEnergyStored());
        }
        return extracted;
    }
}

