/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.mixin.optimizations.beacon_beam_rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.flashyreese.mods.sodiumextra.compat.IrisCompat;
import me.flashyreese.mods.sodiumextra.mixin.optimizations.beacon_beam_rendering.WorldRendererAccessor;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BeaconRenderer.class}, priority=1500)
public abstract class MixinBeaconBlockEntityRenderer {
    @Inject(method={"renderBeam(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/util/Identifier;FFJII[FFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void optimizeRenderBeam(PoseStack matrices, MultiBufferSource vertexConsumerProvider, ResourceLocation textureId, float tickDelta, float heightScale, long worldTime, int yOffset, int maxY, float[] color, float innerRadius, float outerRadius, CallbackInfo ci) {
        ci.cancel();
        if (IrisCompat.isIrisPresent() && IrisCompat.isRenderingShadowPass()) {
            return;
        }
        int height = yOffset + maxY;
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        float time = (float)Math.floorMod(worldTime, 40) + tickDelta;
        float negativeTime = maxY < 0 ? time : -time;
        float fractionalPart = Mth.m_14187_((float)(negativeTime * 0.2f - (float)Mth.m_14143_((float)(negativeTime * 0.1f))));
        float red = color[0];
        float green = color[1];
        float blue = color[2];
        matrices.m_85836_();
        matrices.m_252781_(Axis.f_252436_.m_252977_(time * 2.25f - 45.0f));
        float innerX3 = -innerRadius;
        float innerZ4 = -innerRadius;
        float innerV2 = -1.0f + fractionalPart;
        float innerV1 = (float)maxY * heightScale * (0.5f / innerRadius) + innerV2;
        int colorNoneTranslucent = ColorABGR.pack((float)red, (float)green, (float)blue, (float)1.0f);
        int colorTranslucent = ColorABGR.pack((float)red, (float)green, (float)blue, (float)0.125f);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(1152);
            ptr = MixinBeaconBlockEntityRenderer.writeBeamLayerVertices(ptr, matrices, colorNoneTranslucent, yOffset, height, 0.0f, innerRadius, innerRadius, 0.0f, innerX3, 0.0f, 0.0f, innerZ4, innerV1, innerV2);
            VertexBufferWriter.of((VertexConsumer)vertexConsumerProvider.m_6299_(RenderType.m_110460_((ResourceLocation)textureId, (boolean)false))).push(stack, buffer, 16, ModelVertex.FORMAT);
            matrices.m_85849_();
            float innerX1 = -outerRadius;
            float outerZ1 = -outerRadius;
            float innerZ2 = -outerRadius;
            innerX3 = -outerRadius;
            innerV2 = -1.0f + fractionalPart;
            innerV1 = (float)maxY * heightScale + innerV2;
            buffer = ptr;
            ptr = MixinBeaconBlockEntityRenderer.writeBeamLayerVertices(ptr, matrices, colorTranslucent, yOffset, height, innerX1, outerZ1, outerRadius, innerZ2, innerX3, outerRadius, outerRadius, outerRadius, innerV1, innerV2);
            VertexBufferWriter.of((VertexConsumer)vertexConsumerProvider.m_6299_(RenderType.m_110460_((ResourceLocation)textureId, (boolean)true))).push(stack, buffer, 16, ModelVertex.FORMAT);
        }
        matrices.m_85849_();
    }

    @Unique
    private static long writeBeamLayerVertices(long ptr, PoseStack matrixStack, int color, int yOffset, int height, float x1, float z1, float x2, float z2, float x3, float z3, float x4, float z4, float v1, float v2) {
        PoseStack.Pose entry = matrixStack.m_85850_();
        Matrix4f positionMatrix = entry.m_252922_();
        Matrix3f normalMatrix = entry.m_252943_();
        int normal = MatrixHelper.transformNormal((Matrix3f)normalMatrix, (float)0.0f, (float)1.0f, (float)0.0f);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x1, height, z1, color, 1.0f, v1, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x1, yOffset, z1, color, 1.0f, v2, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x2, yOffset, z2, color, 0.0f, v2, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x2, height, z2, color, 0.0f, v1, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x4, height, z4, color, 1.0f, v1, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x4, yOffset, z4, color, 1.0f, v2, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x3, yOffset, z3, color, 0.0f, v2, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x3, height, z3, color, 0.0f, v1, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x2, height, z2, color, 1.0f, v1, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x2, yOffset, z2, color, 1.0f, v2, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x4, yOffset, z4, color, 0.0f, v2, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x4, height, z4, color, 0.0f, v1, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x3, height, z3, color, 1.0f, v1, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x3, yOffset, z3, color, 1.0f, v2, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x1, yOffset, z1, color, 0.0f, v2, normal);
        ptr = MixinBeaconBlockEntityRenderer.transformAndWriteVertex(ptr, positionMatrix, x1, height, z1, color, 0.0f, v1, normal);
        return ptr;
    }

    @Unique
    private static long transformAndWriteVertex(long ptr, Matrix4f positionMatrix, float x, float y, float z, int color, float u, float v, int normal) {
        float transformedX = MatrixHelper.transformPositionX((Matrix4f)positionMatrix, (float)x, (float)y, (float)z);
        float transformedY = MatrixHelper.transformPositionY((Matrix4f)positionMatrix, (float)x, (float)y, (float)z);
        float transformedZ = MatrixHelper.transformPositionZ((Matrix4f)positionMatrix, (float)x, (float)y, (float)z);
        ModelVertex.write((long)ptr, (float)transformedX, (float)transformedY, (float)transformedZ, (int)color, (float)u, (float)v, (int)0xF000F0, (int)OverlayTexture.f_118083_, (int)normal);
        return ptr += 36L;
    }

    @Inject(method={"render(Lnet/minecraft/block/entity/BeaconBlockEntity;FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;II)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(BeaconBlockEntity beaconBlockEntity, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, int j, CallbackInfo ci) {
        AABB box;
        Frustum frustum = ((WorldRendererAccessor)Minecraft.m_91087_().f_91060_).getFrustum();
        if (!frustum.m_113029_(box = new AABB((double)beaconBlockEntity.m_58899_().m_123341_() - 1.0, (double)beaconBlockEntity.m_58899_().m_123342_() - 1.0, (double)beaconBlockEntity.m_58899_().m_123343_() - 1.0, (double)beaconBlockEntity.m_58899_().m_123341_() + 1.0, (double)beaconBlockEntity.m_58899_().m_123342_() + (beaconBlockEntity.m_58702_().isEmpty() ? 1.0 : 1024.0), (double)beaconBlockEntity.m_58899_().m_123343_() + 1.0))) {
            ci.cancel();
        }
    }
}

