/*
 * Decompiled with CFR 0.152.
 */
package com.argus.regenerating_loot_blocks.command;

import com.argus.regenerating_loot_blocks.block.entity.RegenLootBlockEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RegenLootBlockCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"lootBlock").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).suggests(RegenLootBlockCommand::suggestLookingAtBlock).then(Commands.m_82129_((String)"loot_table", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(RegenLootBlockCommand::suggestLootTables).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"blockState", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)commandBuildContext)).executes(RegenLootBlockCommand::setRegenLootBlock))).executes(RegenLootBlockCommand::setRegenLootBlockNoVisual)))));
    }

    private static int setRegenLootBlock(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        BlockEntity be = level.m_7702_(BlockPosArgument.m_264582_(ctx, (String)"pos"));
        if (be instanceof RegenLootBlockEntity) {
            RegenLootBlockEntity rbe = (RegenLootBlockEntity)be;
            rbe.setLootTable(ResourceLocationArgument.m_107011_(ctx, (String)"loot_table"));
            rbe.setDelayMax(IntegerArgumentType.getInteger(ctx, (String)"delay"));
            rbe.setBlockAppearance(BlockStateArgument.m_116123_(ctx, (String)"blockState").m_114669_());
            rbe.m_6596_();
            level.m_7260_(rbe.m_58899_(), BlockStateArgument.m_116123_(ctx, (String)"blockState").m_114669_(), BlockStateArgument.m_116123_(ctx, (String)"blockState").m_114669_(), 3);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Updated loot table, delay, and visual."), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"There is no Loot Block at this position!"));
        }
        return 0;
    }

    private static int setRegenLootBlockNoVisual(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        BlockEntity be = level.m_7702_(BlockPosArgument.m_264582_(ctx, (String)"pos"));
        if (be instanceof RegenLootBlockEntity) {
            RegenLootBlockEntity rbe = (RegenLootBlockEntity)be;
            rbe.setLootTable(ResourceLocationArgument.m_107011_(ctx, (String)"loot_table"));
            rbe.setDelayMax(IntegerArgumentType.getInteger(ctx, (String)"delay"));
            rbe.m_6596_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Updated loot table and delay."), false);
        }
        return 0;
    }

    public static CompletableFuture<Suggestions> suggestLootTables(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        for (ResourceLocation lootTableId : source.m_81377_().m_278653_().m_278706_(LootDataType.f_278413_)) {
            builder.suggest(lootTableId.toString());
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestLookingAtBlock(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Vec3 lookVec;
        Vec3 reachVec;
        Vec3 eyePos;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        Level level = player.m_9236_();
        BlockHitResult hitResult = level.m_45547_(new ClipContext(eyePos = player.m_146892_(), reachVec = eyePos.m_82549_((lookVec = player.m_20252_(1.0f)).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = hitResult.m_82425_();
            String suggestion = pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
            return SharedSuggestionProvider.m_82970_(Collections.singleton(suggestion), (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    private static CompletableFuture<Suggestions> suggestAllBlockStates(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        String propertiesPart;
        String input = builder.getRemaining().toLowerCase();
        int bracketIndex = input.indexOf(91);
        String blockId = bracketIndex == -1 ? input : input.substring(0, bracketIndex);
        String string = propertiesPart = bracketIndex == -1 ? "" : input.substring(bracketIndex + 1).replace("]", "");
        if (bracketIndex == -1) {
            Stream blocks = BuiltInRegistries.f_256975_.m_123024_();
            blocks.filter(b -> {
                ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_(b);
                return id.toString().contains(input.toLowerCase());
            }).forEach(b -> builder.suggest(BuiltInRegistries.f_256975_.m_7981_(b).toString()));
        } else {
            ResourceLocation rl = ResourceLocation.m_135820_((String)blockId);
            if (rl == null || !BuiltInRegistries.f_256975_.m_7804_(rl)) {
                return builder.buildFuture();
            }
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(rl);
            ArrayList allProperties = new ArrayList(block.m_49965_().m_61092_());
            HashSet<String> alreadyUsedProperties = new HashSet<String>();
            if (!propertiesPart.isEmpty()) {
                String[] pairs = propertiesPart.split(",");
                for (String pair : pairs) {
                    String[] kv = pair.split("=");
                    if (kv.length != 2) continue;
                    alreadyUsedProperties.add(kv[0]);
                }
            }
            String prefix = blockId + "[";
            for (Property property : allProperties) {
                if (alreadyUsedProperties.contains(property.m_61708_())) continue;
                for (Comparable value : property.m_6908_()) {
                    builder.suggest(prefix + propertiesPart + ((propertiesPart.isEmpty() ? "" : ",") + property.m_61708_() + "=" + value.toString()).substring(propertiesPart.length() + 1));
                }
            }
        }
        return builder.buildFuture();
    }
}

