/*
 * Decompiled with CFR 0.152.
 */
package com.argus.regenerating_loot_blocks.block.entity;

import com.argus.regenerating_loot_blocks.block.entity.ModBlockEntities;
import com.argus.regenerating_loot_blocks.gui.menu.RegenLootMenu;
import com.argus.regenerating_loot_blocks.gui.menu.itemstackhandler.DisabledItemStackHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class RegenLootBlockEntity
extends BlockEntity
implements MenuProvider {
    private final int slots = 27;
    private DisabledItemStackHandler inventory;
    private LazyOptional<IItemHandler> inventoryCapability = LazyOptional.empty();
    private ResourceLocation lootTable;
    private BlockState blockAppearance = Blocks.f_50087_.m_49966_();
    private CompoundTag blockAppearanceTag = null;
    private long delayMax = 200L;
    private long delayTimestamp = -1L;

    public RegenLootBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.REGEN_LOOT_BLOCK.get(), pos, state);
        this.inventory = new DisabledItemStackHandler(27);
        this.inventoryCapability = LazyOptional.of(() -> this.inventory);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inventoryCapability.invalidate();
    }

    public void tryStartDelay() {
        if (this.delayTimestamp == -1L) {
            this.delayTimestamp = this.f_58857_.m_46467_();
        }
    }

    public void tick() {
        if (!this.f_58857_.f_46443_ && this.delayTimestamp != -1L && this.f_58857_.m_46467_() - this.delayTimestamp > this.delayMax) {
            this.delayTimestamp = this.f_58857_.m_46467_();
            this.regenerateLoot(this.f_58857_);
        }
    }

    private void regenerateLoot(Level level) {
        this.inventory = new DisabledItemStackHandler(27);
        if (this.lootTable != null && level instanceof ServerLevel) {
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable table = serverLevel.m_7654_().m_278653_().m_278676_(this.lootTable);
            LootParams params = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_287235_(LootContextParamSets.f_81411_);
            ObjectArrayList generatedLoot = table.m_287195_(params);
            ArrayList<Integer> slotIndices = new ArrayList<Integer>();
            for (i = 0; i < this.inventory.getSlots(); ++i) {
                slotIndices.add(i);
            }
            Collections.shuffle(slotIndices, new Random(serverLevel.m_46467_()));
            for (i = 0; i < Math.min(generatedLoot.size(), slotIndices.size()); ++i) {
                this.inventory.setStackInSlot((Integer)slotIndices.get(i), (ItemStack)generatedLoot.get(i));
            }
        }
        this.delayTimestamp = -1L;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        if (this.lootTable != null) {
            tag.m_128359_("LootTable", this.lootTable.toString());
        }
        if (this.blockAppearance != null) {
            tag.m_128365_("BlockAppearance", (Tag)NbtUtils.m_129202_((BlockState)this.blockAppearance));
        }
        tag.m_128356_("DelayCounter", this.delayTimestamp);
        tag.m_128356_("DelayMax", this.delayMax);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        if (tag.m_128441_("LootTable")) {
            this.lootTable = new ResourceLocation(tag.m_128461_("LootTable"));
        }
        if (tag.m_128441_("BlockAppearance")) {
            this.blockAppearanceTag = tag.m_128469_("BlockAppearance");
            this.blockAppearance = NbtUtils.m_247651_((HolderGetter)(this.f_58857_ != null ? this.f_58857_.m_9598_().m_255025_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_()), (CompoundTag)this.blockAppearanceTag);
        }
        this.delayTimestamp = tag.m_128454_("DelayCounter");
        this.delayMax = tag.m_128454_("DelayMax");
    }

    public void onLoad() {
        super.onLoad();
        if (this.blockAppearanceTag != null && this.f_58857_ != null) {
            this.blockAppearance = NbtUtils.m_247651_((HolderGetter)((HolderGetter)this.f_58857_.m_9598_().m_254861_(Registries.f_256747_).orElseThrow()), (CompoundTag)this.blockAppearanceTag);
            this.blockAppearanceTag = null;
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.blockAppearance != null) {
            tag.m_128365_("BlockAppearance", (Tag)NbtUtils.m_129202_((BlockState)this.blockAppearance));
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128441_("BlockAppearance")) {
            this.blockAppearanceTag = tag.m_128469_("BlockAppearance");
            this.blockAppearance = NbtUtils.m_247651_((HolderGetter)(this.f_58857_ != null ? this.f_58857_.m_9598_().m_255025_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_()), (CompoundTag)this.blockAppearanceTag);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Loot Block");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return null;
    }

    public MenuProvider getLootContainerProvider() {
        return new SimpleMenuProvider((id, inv, player) -> new RegenLootMenu(id, inv, this.inventory), (Component)Component.m_237113_((String)"Loot"));
    }

    public long getDelayMax() {
        return this.delayMax;
    }

    public void setDelayMax(long delayMax) {
        this.delayMax = delayMax;
    }

    public BlockState getBlockAppearance() {
        return this.blockAppearance;
    }

    public void setBlockAppearance(BlockState blockAppearance) {
        this.blockAppearance = blockAppearance;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceLocation lootTable) {
        this.lootTable = lootTable;
    }

    public long getDelayTimestamp() {
        return this.delayTimestamp;
    }

    public void setDelayTimestamp(long delayTimestamp) {
        this.delayTimestamp = delayTimestamp;
    }
}

