/*
 * Decompiled with CFR 0.152.
 */
package com.argus.regenerating_loot_blocks.block;

import com.argus.regenerating_loot_blocks.block.entity.ModBlockEntities;
import com.argus.regenerating_loot_blocks.block.entity.RegenLootBlockEntity;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class RegenLootBlock
extends BaseEntityBlock {
    public RegenLootBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_).m_60955_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RegenLootBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (hand == InteractionHand.MAIN_HAND) {
                Item item;
                BlockEntity be = level.m_7702_(pos);
                if (!(be instanceof RegenLootBlockEntity)) {
                    return InteractionResult.PASS;
                }
                RegenLootBlockEntity entity = (RegenLootBlockEntity)be;
                ItemStack heldItem = player.m_21120_(hand);
                if (player.m_7500_() && (item = heldItem.m_41720_()) instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    Block block = blockItem.m_40614_();
                    BlockState heldBlockState = blockItem.m_40614_().m_49966_();
                    Optional<Property> facingPropOpt = block.m_49965_().m_61092_().stream().filter(prop -> prop.m_61708_().equals("facing")).findFirst();
                    if (facingPropOpt.isPresent()) {
                        Property prop2 = facingPropOpt.get();
                        System.out.println(prop2);
                        if (prop2 instanceof DirectionProperty) {
                            DirectionProperty dirProp = (DirectionProperty)prop2;
                            Direction playerFacing = player.m_6350_();
                            if (dirProp.m_6908_().contains(playerFacing)) {
                                heldBlockState = (BlockState)heldBlockState.m_61124_((Property)dirProp, (Comparable)playerFacing);
                            }
                        }
                    }
                    entity.setBlockAppearance(heldBlockState);
                    level.m_7260_(pos, heldBlockState, heldBlockState, 3);
                    player.m_213846_((Component)Component.m_237113_((String)("Updated loot box appearance to \"" + heldBlockState + "\"")));
                } else if (player.m_7500_() && player.m_6047_()) {
                    player.m_213846_((Component)Component.m_237113_((String)("Loot table: " + entity.getLootTable())));
                    player.m_213846_((Component)Component.m_237113_((String)("Max regen delay: " + entity.getDelayMax())));
                    if (entity.getDelayTimestamp() != -1L) {
                        player.m_213846_((Component)Component.m_237113_((String)("Time left: " + (entity.getDelayMax() - level.m_46467_() + entity.getDelayTimestamp()) / 20L + "s")));
                    } else {
                        player.m_213846_((Component)Component.m_237113_((String)"Time left: PAUSED"));
                    }
                } else {
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)entity.getLootContainerProvider(), buf -> buf.m_130064_(pos));
                    level.m_5594_(null, pos, SoundEvents.f_11749_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    entity.tryStartDelay();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return RegenLootBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.REGEN_LOOT_BLOCK.get()), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }
}

