/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.ArrowFunction;
import dev.latvian.mods.rhino.BoundFunction;
import dev.latvian.mods.rhino.ConsString;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.IdFunctionObject;
import dev.latvian.mods.rhino.JavaAdapter;
import dev.latvian.mods.rhino.NativeGlobal;
import dev.latvian.mods.rhino.NativeSymbol;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Symbol;
import dev.latvian.mods.rhino.SymbolKey;
import dev.latvian.mods.rhino.Wrapper;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;

final class EqualObjectGraphs {
    private static final ThreadLocal<EqualObjectGraphs> instance = new ThreadLocal();
    private final Map<Object, Object> knownEquals = new IdentityHashMap<Object, Object>();
    private final Map<Object, Object> currentlyCompared = new IdentityHashMap<Object, Object>();

    EqualObjectGraphs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withThreadLocal(Function<EqualObjectGraphs, T> action) {
        EqualObjectGraphs currEq = instance.get();
        if (currEq == null) {
            EqualObjectGraphs eq = new EqualObjectGraphs();
            instance.set(eq);
            try {
                T t = action.apply(eq);
                return t;
            }
            finally {
                instance.set(null);
            }
        }
        return action.apply(currEq);
    }

    private static Iterator<Map.Entry> sortedEntries(Map m) {
        Map sortedMap = m instanceof SortedMap ? m : new TreeMap(m);
        return sortedMap.entrySet().iterator();
    }

    private static Object[] sortedSet(Set<?> s) {
        Object[] a = s.toArray();
        Arrays.sort(a);
        return a;
    }

    private static Object[] getSortedIds(Context cx, Scriptable s) {
        Object[] ids = EqualObjectGraphs.getIds(cx, s);
        Arrays.sort(ids, (a, b) -> {
            if (a instanceof Integer) {
                if (b instanceof Integer) {
                    return ((Integer)a).compareTo((Integer)b);
                }
                if (b instanceof String || b instanceof Symbol) {
                    return -1;
                }
            } else if (a instanceof String) {
                if (b instanceof String) {
                    return ((String)a).compareTo((String)b);
                }
                if (b instanceof Integer) {
                    return 1;
                }
                if (b instanceof Symbol) {
                    return -1;
                }
            } else if (a instanceof Symbol) {
                if (b instanceof Symbol) {
                    return EqualObjectGraphs.getSymbolName((Symbol)a).compareTo(EqualObjectGraphs.getSymbolName((Symbol)b));
                }
                if (b instanceof Integer || b instanceof String) {
                    return 1;
                }
            }
            throw new ClassCastException();
        });
        return ids;
    }

    private static String getSymbolName(Symbol s) {
        if (s instanceof SymbolKey) {
            return ((SymbolKey)s).getName();
        }
        if (s instanceof NativeSymbol) {
            return ((NativeSymbol)s).getKey().getName();
        }
        throw new ClassCastException();
    }

    private static Object[] getIds(Context cx, Scriptable s) {
        if (s instanceof ScriptableObject) {
            return ((ScriptableObject)s).getIds(cx, true, true);
        }
        return s.getAllIds(cx);
    }

    private static Object getValue(Scriptable s, Object id, Context cx) {
        if (id instanceof Symbol) {
            return ScriptableObject.getProperty(s, (Symbol)id, cx);
        }
        if (id instanceof Integer) {
            return ScriptableObject.getProperty(s, (Integer)id, cx);
        }
        if (id instanceof String) {
            return ScriptableObject.getProperty(s, (String)id, cx);
        }
        throw new ClassCastException();
    }

    boolean equalGraphs(Context cx, Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Object curr2 = this.currentlyCompared.get(o1);
        if (curr2 == o2) {
            return true;
        }
        if (curr2 != null) {
            return false;
        }
        Object prev2 = this.knownEquals.get(o1);
        if (prev2 == o2) {
            return true;
        }
        if (prev2 != null) {
            return false;
        }
        Object prev1 = this.knownEquals.get(o2);
        assert (prev1 != o1);
        if (prev1 != null) {
            return false;
        }
        this.currentlyCompared.put(o1, o2);
        boolean eq = this.equalGraphsNoMemo(cx, o1, o2);
        if (eq) {
            this.knownEquals.put(o1, o2);
            this.knownEquals.put(o2, o1);
        }
        this.currentlyCompared.remove(o1);
        return eq;
    }

    private boolean equalGraphsNoMemo(Context cx, Object o1, Object o2) {
        if (o1 instanceof Wrapper) {
            return o2 instanceof Wrapper && this.equalGraphs(cx, ((Wrapper)o1).unwrap(), ((Wrapper)o2).unwrap());
        }
        if (o1 instanceof Scriptable) {
            return o2 instanceof Scriptable && this.equalScriptables(cx, (Scriptable)o1, (Scriptable)o2);
        }
        if (o1 instanceof ConsString) {
            return ((ConsString)o1).toString().equals(o2);
        }
        if (o2 instanceof ConsString) {
            return o1.equals(((ConsString)o2).toString());
        }
        if (o1 instanceof SymbolKey) {
            return o2 instanceof SymbolKey && this.equalGraphs(cx, ((SymbolKey)o1).getName(), ((SymbolKey)o2).getName());
        }
        if (o1 instanceof Object[]) {
            return o2 instanceof Object[] && this.equalObjectArrays(cx, (Object[])o1, (Object[])o2);
        }
        if (o1.getClass().isArray()) {
            return Objects.deepEquals(o1, o2);
        }
        if (o1 instanceof List) {
            return o2 instanceof List && this.equalLists(cx, (List)o1, (List)o2);
        }
        if (o1 instanceof Map) {
            return o2 instanceof Map && this.equalMaps(cx, (Map)o1, (Map)o2);
        }
        if (o1 instanceof Set) {
            return o2 instanceof Set && this.equalSets(cx, (Set)o1, (Set)o2);
        }
        if (o1 instanceof NativeGlobal) {
            return o2 instanceof NativeGlobal;
        }
        if (o1 instanceof JavaAdapter) {
            return o2 instanceof JavaAdapter;
        }
        return o1.equals(o2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean equalScriptables(Context cx, Scriptable s1, Scriptable s2) {
        Object[] ids2;
        Object[] ids1 = EqualObjectGraphs.getSortedIds(cx, s1);
        if (!this.equalObjectArrays(cx, ids1, ids2 = EqualObjectGraphs.getSortedIds(cx, s2))) {
            return false;
        }
        int l = ids1.length;
        for (int i = 0; i < l; ++i) {
            if (this.equalGraphs(cx, EqualObjectGraphs.getValue(s1, ids1[i], cx), EqualObjectGraphs.getValue(s2, ids2[i], cx))) continue;
            return false;
        }
        if (!this.equalGraphs(cx, s1.getPrototype(cx), s2.getPrototype(cx))) {
            return false;
        }
        if (!this.equalGraphs(cx, s1.getParentScope(), s2.getParentScope())) {
            return false;
        }
        if (s1 instanceof IdFunctionObject) {
            IdFunctionObject s3 = (IdFunctionObject)s1;
            if (!(s2 instanceof IdFunctionObject)) return false;
            IdFunctionObject s4 = (IdFunctionObject)s2;
            if (!IdFunctionObject.equalObjectGraphs(cx, s3, s4, this)) return false;
            return true;
        }
        if (s1 instanceof ArrowFunction) {
            ArrowFunction s3 = (ArrowFunction)s1;
            if (!(s2 instanceof ArrowFunction)) return false;
            ArrowFunction s4 = (ArrowFunction)s2;
            if (!ArrowFunction.equalObjectGraphs(cx, s3, s4, this)) return false;
            return true;
        }
        if (s1 instanceof BoundFunction) {
            BoundFunction s3 = (BoundFunction)s1;
            if (!(s2 instanceof BoundFunction)) return false;
            BoundFunction s4 = (BoundFunction)s2;
            if (!BoundFunction.equalObjectGraphs(cx, s3, s4, this)) return false;
            return true;
        }
        if (!(s1 instanceof NativeSymbol)) return true;
        NativeSymbol s3 = (NativeSymbol)s1;
        if (!(s2 instanceof NativeSymbol)) return false;
        NativeSymbol s4 = (NativeSymbol)s2;
        if (!this.equalGraphs(cx, s3.getKey(), s4.getKey())) return false;
        return true;
    }

    private boolean equalObjectArrays(Context cx, Object[] a1, Object[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (this.equalGraphs(cx, a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean equalLists(Context cx, List<?> l1, List<?> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<?> i1 = l1.iterator();
        Iterator<?> i2 = l2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (this.equalGraphs(cx, i1.next(), i2.next())) continue;
            return false;
        }
        assert (!i1.hasNext() && !i2.hasNext());
        return true;
    }

    private boolean equalMaps(Context cx, Map<?, ?> m1, Map<?, ?> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        Iterator<Map.Entry> i1 = EqualObjectGraphs.sortedEntries(m1);
        Iterator<Map.Entry> i2 = EqualObjectGraphs.sortedEntries(m2);
        while (i1.hasNext() && i2.hasNext()) {
            Map.Entry kv1 = i1.next();
            Map.Entry kv2 = i2.next();
            if (this.equalGraphs(cx, kv1.getKey(), kv2.getKey()) && this.equalGraphs(cx, kv1.getValue(), kv2.getValue())) continue;
            return false;
        }
        assert (!i1.hasNext() && !i2.hasNext());
        return true;
    }

    private boolean equalSets(Context cx, Set<?> s1, Set<?> s2) {
        return this.equalObjectArrays(cx, EqualObjectGraphs.sortedSet(s1), EqualObjectGraphs.sortedSet(s2));
    }
}

