/*
 * Decompiled with CFR 0.152.
 */
package com.anar4732.opf.client;

import com.anar4732.opf.OPFEntity;
import com.anar4732.opf.OPFMod;
import com.google.common.hash.Hashing;
import com.madgag.gif.fmsware.GifDecoder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class DownloadingTextureExtended
extends SimpleTexture {
    private static final Logger LOGGER = OPFMod.LOGGER;
    private final File cacheFile;
    private final String imageUrl;
    private final Runnable processTask;
    private CompletableFuture<?> future;
    private int frameIndex = 0;
    private int delayTimer = 0;
    private final OPFEntity frame;
    private ArrayList<byte[]> frames;
    public boolean error;
    public boolean loaded = false;

    public DownloadingTextureExtended(@Nullable File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, @Nullable Runnable processTaskIn, OPFEntity frame) {
        super(textureResourceLocation);
        this.cacheFile = cacheFileIn;
        this.imageUrl = imageUrlIn;
        this.processTask = processTaskIn;
        this.frame = frame;
    }

    private void setImage(NativeImage nativeImage) {
        if (this.processTask != null) {
            this.processTask.run();
        }
        Minecraft.m_91087_().execute(() -> {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(nativeImage));
            } else {
                this.upload(nativeImage);
            }
        });
    }

    private void upload(NativeImage imageIn) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)imageIn.m_84982_(), (int)imageIn.m_85084_());
        imageIn.m_85040_(0, 0, 0, true);
    }

    public void m_6704_(@NotNull ResourceManager manager) throws IOException {
        if (this.future == null) {
            NativeImage nativeimage;
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading texture from local cache ({})", (Object)this.cacheFile);
                FileInputStream stream = new FileInputStream(this.cacheFile);
                nativeimage = this.loadTexture(stream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.setImage(nativeimage);
            } else {
                this.future = CompletableFuture.runAsync(() -> {
                    block14: {
                        HttpURLConnection httpurlconnection = null;
                        LOGGER.debug("Downloading texture from {} to {}", (Object)this.imageUrl, (Object)this.cacheFile);
                        try {
                            httpurlconnection = (HttpURLConnection)new URL(this.imageUrl).openConnection(Minecraft.m_91087_().m_91096_());
                            httpurlconnection.setDoInput(true);
                            httpurlconnection.setDoOutput(false);
                            httpurlconnection.connect();
                            if (httpurlconnection.getResponseCode() / 100 != 2) break block14;
                            try (InputStream inputStream = httpurlconnection.getInputStream();){
                                if (this.cacheFile != null) {
                                    LOGGER.debug("Writing to local cache file {}", (Object)this.cacheFile);
                                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)this.cacheFile);
                                    this.addLoadTextureTask(new FileInputStream(this.cacheFile));
                                } else {
                                    this.addLoadTextureTask(inputStream);
                                }
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.error("Couldn't download texture", (Throwable)exception);
                            this.error = true;
                        }
                        finally {
                            if (httpurlconnection != null) {
                                httpurlconnection.disconnect();
                            }
                        }
                    }
                }, Util.m_183991_());
            }
        }
    }

    private void addLoadTextureTask(InputStream inputStream) {
        Minecraft.m_91087_().execute(() -> {
            NativeImage image = this.loadTexture(inputStream);
            if (image != null) {
                this.setImage(image);
            }
        });
    }

    @Nullable
    private NativeImage loadTexture(InputStream inputStreamIn) {
        NativeImage nativeimage = null;
        try {
            byte[] data = IOUtils.toByteArray((InputStream)inputStreamIn);
            String type = DownloadingTextureExtended.readType(data);
            if (type.equalsIgnoreCase("gif")) {
                new Thread(() -> {
                    GifDecoder gifDecoder = new GifDecoder();
                    int status = gifDecoder.read(new ByteArrayInputStream(data));
                    if (status == 0) {
                        this.frames = new ArrayList();
                        File cacheFile = new File(OPFEntity.cacheDir, Hashing.sha1().hashUnencodedChars((CharSequence)this.frame.url).toString().replace("==", "") + ".pgc");
                        if (cacheFile.isFile()) {
                            try {
                                LOGGER.debug("Loading PGC from local cache ({})", (Object)cacheFile);
                                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(cacheFile));
                                this.frames = (ArrayList)ois.readObject();
                                this.loaded = true;
                                ois.close();
                                return;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        for (int i = 0; i < gifDecoder.getFrameCount(); ++i) {
                            try {
                                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                                ImageIO.write((RenderedImage)gifDecoder.getFrame(i), "png", stream);
                                stream.flush();
                                this.frames.add(stream.toByteArray());
                                stream.close();
                                continue;
                            }
                            catch (IOException ioexception) {
                                LOGGER.warn("Error while parsing gif frame", (Throwable)ioexception);
                                this.error = true;
                            }
                        }
                        try {
                            LOGGER.debug("Saving PGC to local cache ({})", (Object)cacheFile);
                            ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(cacheFile));
                            stream.writeObject(this.frames);
                            stream.close();
                            this.loaded = true;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        LOGGER.error("Failed to read gif {}", (Object)status);
                        this.error = true;
                    }
                }).start();
            } else {
                this.loaded = true;
            }
            nativeimage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(data));
        }
        catch (IOException ioexception) {
            LOGGER.warn("Error while loading the texture", (Throwable)ioexception);
            this.error = true;
        }
        return nativeimage;
    }

    private static String readType(byte[] input) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(input);){
            String string = DownloadingTextureExtended.readType(stream);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readType(InputStream input) throws IOException {
        input.mark(0);
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(stream);
        if (!imageReaders.hasNext()) {
            return "";
        }
        ImageReader reader = imageReaders.next();
        if (reader.getFormatName().equalsIgnoreCase("gif")) {
            return "gif";
        }
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        try {
            reader.read(0, param);
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse input format", (Throwable)e);
        }
        finally {
            reader.dispose();
            IOUtils.closeQuietly((Closeable)stream);
        }
        input.reset();
        return reader.getFormatName();
    }

    public boolean isGif() {
        return this.frames != null;
    }

    public void tick() {
        block6: {
            if ((float)this.delayTimer > Math.abs(this.frame.speed * 20.0f - 20.0f)) {
                this.delayTimer = 0;
                try {
                    OPFEntity.textureManager.m_118506_(this.f_118129_).m_117964_();
                    this.setImage(NativeImage.m_85058_((InputStream)new ByteArrayInputStream(this.frames.get(this.frameIndex))));
                    if (this.frameIndex == this.frames.size() - 1) {
                        this.frameIndex = 0;
                        break block6;
                    }
                    ++this.frameIndex;
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                    this.error = true;
                }
            } else if (this.loaded) {
                ++this.delayTimer;
            }
        }
    }
}

