/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.flywheel;

import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import dev.engine_room.flywheel.backend.gl.shader.ShaderType;
import net.irisshaders.iris.shadows.ShadowRenderer;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL20;
import top.leonx.irisflw.flywheel.IrisFlwCompatGlProgramBase;
import top.leonx.irisflw.flywheel.RenderLayerEventStateManager;
import top.leonx.irisflw.iris.GlUniformMcMatrix3f;
import top.leonx.irisflw.iris.GlUniformMcMatrix4f;

public class IrisFlwCompatGlProgram
extends IrisFlwCompatGlProgramBase {
    public ShaderInstance shader;
    protected GlUniformMcMatrix4f uniformIrisProjMat;
    protected GlUniformMcMatrix4f iris_uniformModelViewMat;
    protected GlUniformMcMatrix3f uniformNormalMatrix;
    protected GlUniformMcMatrix4f uniformModelViewProjMat;

    public IrisFlwCompatGlProgram(ShaderInstance shader, ShaderType type, String name) {
        super(shader.m_108943_());
        this.shader = shader;
        int progId = shader.m_108943_();
        if (shader.f_173308_ == null) {
            shader.f_173308_ = new Uniform("ModelViewMat", 10, 16, (Shader)shader);
            shader.f_173308_.m_5679_(new Matrix4f());
        }
        this.uniformIrisProjMat = new GlUniformMcMatrix4f(GL20.glGetUniformLocation((int)progId, (CharSequence)"iris_ProjMat"));
        this.iris_uniformModelViewMat = new GlUniformMcMatrix4f(GL20.glGetUniformLocation((int)progId, (CharSequence)"iris_ModelViewMat"));
        this.uniformNormalMatrix = new GlUniformMcMatrix3f(GL20.glGetUniformLocation((int)progId, (CharSequence)"iris_NormalMat"));
        this.uniformModelViewProjMat = new GlUniformMcMatrix4f(GL20.glGetUniformLocation((int)progId, (CharSequence)"flw_ModelViewProjMat"));
    }

    @Override
    public void bind() {
        this.shader.m_173363_();
        if (RenderLayerEventStateManager.isRenderingShadow()) {
            this.setProjectionMatrix(ShadowRenderer.PROJECTION);
            this.setModelViewMatrix(ShadowRenderer.MODELVIEW);
        } else {
            this.setProjectionMatrix(CapturedRenderingState.INSTANCE.getGbufferProjection());
            this.setModelViewMatrix(CapturedRenderingState.INSTANCE.getGbufferModelView());
        }
    }

    @Override
    public void clear() {
        this.shader.m_173362_();
    }

    public int getProgramHandle() {
        return this.shader.m_108943_();
    }

    @Override
    public void setProjectionMatrix(Matrix4f projectionMatrix) {
        this.uniformIrisProjMat.set(projectionMatrix);
    }

    @Override
    public void setModelViewMatrix(Matrix4f modelView) {
        this.iris_uniformModelViewMat.set(modelView);
        if (this.uniformNormalMatrix != null) {
            Matrix4f normalMatrix = new Matrix4f((Matrix4fc)modelView);
            normalMatrix.invert();
            normalMatrix.transpose();
            this.uniformNormalMatrix.set(new Matrix3f((Matrix4fc)normalMatrix));
        }
    }
}

