/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.resource;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Map;
import me.xjqsh.lrtactical.item.index.MeleeWeaponIndex;
import me.xjqsh.lrtactical.item.index.ThrowableIndex;
import me.xjqsh.lrtactical.network.DataType;
import me.xjqsh.lrtactical.resource.CommonAssetsManager;
import me.xjqsh.lrtactical.resource.ICommonResourceProvider;
import me.xjqsh.lrtactical.resource.manager.MeleeIndexManager;
import me.xjqsh.lrtactical.resource.manager.ThrowableIndexManager;
import net.minecraft.resources.ResourceLocation;

public enum CommonNetworkCache implements ICommonResourceProvider
{
    INSTANCE;

    public Map<ResourceLocation, ThrowableIndex<?, ?>> throwableIndex = Maps.newHashMap();
    public Map<ResourceLocation, MeleeWeaponIndex<?>> meleeWeaponIndex = Maps.newHashMap();

    @Override
    public ThrowableIndex<?, ?> getThrowableIndex(ResourceLocation id) {
        return this.throwableIndex.get(id);
    }

    @Override
    public Collection<ThrowableIndex<?, ?>> getThrowableIndexes() {
        return this.throwableIndex.values();
    }

    @Override
    public MeleeWeaponIndex<?> getMeleeIndex(ResourceLocation id) {
        return this.meleeWeaponIndex.get(id);
    }

    @Override
    public Collection<MeleeWeaponIndex<?>> getMeleeIndexes() {
        return this.meleeWeaponIndex.values();
    }

    public void parseThrowableIndex(Map<ResourceLocation, String> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, String> throwableEntry : cache.entrySet()) {
            JsonObject jsonObject = (JsonObject)CommonAssetsManager.GSON.fromJson(throwableEntry.getValue(), JsonObject.class);
            ThrowableIndex<?, ?> index = ThrowableIndexManager.parse(jsonObject, throwableEntry.getKey());
            if (index == null) continue;
            builder.put((Object)throwableEntry.getKey(), index);
        }
        this.throwableIndex = builder.build();
    }

    public void parseMeleeIndex(Map<ResourceLocation, String> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, String> meleeEntry : cache.entrySet()) {
            JsonObject jsonObject = (JsonObject)CommonAssetsManager.GSON.fromJson(meleeEntry.getValue(), JsonObject.class);
            MeleeWeaponIndex<?> index = MeleeIndexManager.parse(jsonObject, meleeEntry.getKey());
            if (index == null) continue;
            builder.put((Object)meleeEntry.getKey(), index);
        }
        this.meleeWeaponIndex = builder.build();
    }

    public void fromNetwork(Map<DataType, Map<ResourceLocation, String>> cache) {
        for (Map.Entry<DataType, Map<ResourceLocation, String>> entry : cache.entrySet()) {
            switch (entry.getKey()) {
                case THROWABLE_INDEX: {
                    this.parseThrowableIndex(entry.getValue());
                    break;
                }
                case MELEE_INDEX: {
                    this.parseMeleeIndex(entry.getValue());
                    break;
                }
            }
        }
    }
}

