/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.client.resource.display;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.client.animation.AnimationController;
import com.tacz.guns.api.client.animation.AnimationListenerSupplier;
import com.tacz.guns.api.client.animation.Animations;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.animation.statemachine.LuaStateMachineFactory;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import java.util.Map;
import java.util.Objects;
import me.xjqsh.lrtactical.api.animation.BaseAnimationStateContext;
import me.xjqsh.lrtactical.client.audio.ICustomSoundSupplier;
import me.xjqsh.lrtactical.client.renderer.model.CustomBedrockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.LuaTable;

public class MeleeDisplayInstance
implements ICustomSoundSupplier {
    private ResourceLocation id;
    private CustomBedrockModel model;
    private LuaAnimationStateMachine<BaseAnimationStateContext> stateMachine;
    private ResourceLocation texture;
    private ResourceLocation slotTexture;
    private ItemTransforms transforms;
    private Map<String, ResourceLocation> sounds;

    private MeleeDisplayInstance() {
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public CustomBedrockModel getModel() {
        return this.model;
    }

    public LuaAnimationStateMachine<BaseAnimationStateContext> getStateMachine() {
        return this.stateMachine;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ResourceLocation getSlotTexture() {
        return this.slotTexture;
    }

    public ItemTransforms getTransforms() {
        return this.transforms;
    }

    @Override
    public Map<String, ResourceLocation> getSounds() {
        return this.sounds;
    }

    @NotNull
    public static MeleeDisplayInstance create(MeleeDisplay pojo, ResourceLocation id) throws IllegalArgumentException {
        MeleeDisplayInstance display = new MeleeDisplayInstance();
        display.id = id;
        Preconditions.checkArgument((pojo.modelLocation != null ? 1 : 0) != 0, (Object)"display object missing model field");
        Preconditions.checkArgument((pojo.stateMachineLocation != null ? 1 : 0) != 0, (Object)"display object missing stateMachine field");
        Preconditions.checkArgument((pojo.textureLocation != null ? 1 : 0) != 0, (Object)"display object missing texture field");
        Preconditions.checkArgument((pojo.animationLocation != null ? 1 : 0) != 0, (Object)"display object missing animation field");
        BedrockModelPOJO modelPOJO = ClientAssetsManager.INSTANCE.getBedrockModelPOJO(pojo.modelLocation);
        Preconditions.checkArgument((modelPOJO != null ? 1 : 0) != 0, (Object)("no corresponding model found for " + pojo.modelLocation));
        if (BedrockVersion.isLegacyVersion((BedrockModelPOJO)modelPOJO)) {
            display.model = new CustomBedrockModel(modelPOJO, BedrockVersion.LEGACY);
        }
        display.model = new CustomBedrockModel(modelPOJO, BedrockVersion.NEW);
        BedrockAnimationFile animation = ClientAssetsManager.INSTANCE.getBedrockAnimations(pojo.animationLocation);
        Preconditions.checkArgument((animation != null ? 1 : 0) != 0, (Object)("no corresponding animation found for " + pojo.modelLocation));
        AnimationController controller = Animations.createControllerFromBedrock((BedrockAnimationFile)animation, (AnimationListenerSupplier)display.model);
        LuaTable script = ClientAssetsManager.INSTANCE.getScript(pojo.stateMachineLocation);
        Preconditions.checkArgument((script != null ? 1 : 0) != 0, (Object)("no corresponding state machine found for " + pojo.modelLocation));
        display.stateMachine = new LuaStateMachineFactory().setController(controller).setLuaScripts(script).build();
        display.texture = new ResourceLocation(pojo.textureLocation.m_135827_(), "textures/" + pojo.textureLocation.m_135815_() + ".png");
        if (pojo.slotTextureLocation != null) {
            display.slotTexture = new ResourceLocation(pojo.slotTextureLocation.m_135827_(), "textures/" + pojo.slotTextureLocation.m_135815_() + ".png");
        }
        display.transforms = Objects.requireNonNullElse(pojo.transforms, ItemTransforms.f_111786_);
        display.sounds = Objects.requireNonNullElseGet(pojo.sounds, Maps::newHashMap);
        return display;
    }

    public record MeleeDisplay(@SerializedName(value="model") ResourceLocation modelLocation, @SerializedName(value="animation") ResourceLocation animationLocation, @SerializedName(value="state_machine") ResourceLocation stateMachineLocation, @SerializedName(value="texture") ResourceLocation textureLocation, @SerializedName(value="slot_texture") ResourceLocation slotTextureLocation, @SerializedName(value="transforms") ItemTransforms transforms, @SerializedName(value="sounds") Map<String, ResourceLocation> sounds) {
    }
}

