/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.client.renderer;

import com.tacz.guns.client.model.BedrockAnimatedModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.util.math.SecondOrderDynamics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;

public class JumpSwayUtil {
    private static float jumpingSwayProgress = 0.0f;
    private static boolean lastOnGround = false;
    private static long jumpingTimeStamp = -1L;
    private static final SecondOrderDynamics JUMPING_DYNAMICS = new SecondOrderDynamics(0.28f, 1.0f, 0.65f, 0.0f);
    private static final float JUMPING_Y_SWAY = -2.0f;
    private static final float JUMPING_SWAY_TIME = 0.3f;
    private static final float LANDING_SWAY_TIME = 0.15f;

    public static void applyJumpingSway(BedrockAnimatedModel model, float partialTicks) {
        LocalPlayer player;
        if (jumpingTimeStamp == -1L) {
            jumpingTimeStamp = System.currentTimeMillis();
        }
        if ((player = Minecraft.m_91087_().f_91074_) != null) {
            double posY = Mth.m_14139_((double)partialTicks, (double)Minecraft.m_91087_().f_91074_.f_19791_, (double)Minecraft.m_91087_().f_91074_.m_20186_());
            float velocityY = (float)(posY - Minecraft.m_91087_().f_91074_.f_19791_) / partialTicks;
            if (player.m_20096_()) {
                if (!lastOnGround) {
                    jumpingSwayProgress = velocityY / -0.1f;
                    if (jumpingSwayProgress > 1.0f) {
                        jumpingSwayProgress = 1.0f;
                    }
                    lastOnGround = true;
                } else if ((jumpingSwayProgress -= (float)(System.currentTimeMillis() - jumpingTimeStamp) / 150.0f) < 0.0f) {
                    jumpingSwayProgress = 0.0f;
                }
            } else if (lastOnGround) {
                jumpingSwayProgress = velocityY / 0.42f;
                if (jumpingSwayProgress > 1.0f) {
                    jumpingSwayProgress = 1.0f;
                }
                lastOnGround = false;
            } else if ((jumpingSwayProgress -= (float)(System.currentTimeMillis() - jumpingTimeStamp) / 300.0f) < 0.0f) {
                jumpingSwayProgress = 0.0f;
            }
        }
        jumpingTimeStamp = System.currentTimeMillis();
        float ySway = JUMPING_DYNAMICS.update(-2.0f * jumpingSwayProgress);
        BedrockPart rootNode = model.getRootNode();
        if (rootNode != null) {
            rootNode.offsetY += -ySway / 16.0f;
        }
    }
}

