/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.capability;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import me.xjqsh.lrtactical.network.NetworkHandler;
import me.xjqsh.lrtactical.network.message.SCustomCoolDownMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;

@AutoRegisterCapability
public class CustomItemCoolDowns {
    public static final ResourceLocation ID = new ResourceLocation("lrtactical", "custom_cooldown");
    private final Player player;
    public Map<ResourceLocation, CooldownInstance> cooldowns = Maps.newHashMap();
    private int tickCount;

    public CustomItemCoolDowns(Player player) {
        this.player = player;
    }

    public boolean isOnCooldown(ResourceLocation id) {
        return this.getCooldownPercent(id, 0.0f) > 0.0f;
    }

    public float getCooldownPercent(ResourceLocation id, float pPartialTicks) {
        CooldownInstance itemcooldowns$cooldowninstance = this.cooldowns.get(id);
        if (itemcooldowns$cooldowninstance != null) {
            float f = itemcooldowns$cooldowninstance.endTime - itemcooldowns$cooldowninstance.startTime;
            float f1 = (float)itemcooldowns$cooldowninstance.endTime - ((float)this.tickCount + pPartialTicks);
            return Mth.m_14036_((float)(f1 / f), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    public void tick() {
        ++this.tickCount;
        if (!this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<ResourceLocation, CooldownInstance>> iterator = this.cooldowns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, CooldownInstance> entry = iterator.next();
                if (entry.getValue().endTime > this.tickCount) continue;
                iterator.remove();
                this.onCooldownEnded(entry.getKey());
            }
        }
    }

    public void addCooldown(ResourceLocation id, int pTicks) {
        this.cooldowns.put(id, new CooldownInstance(this.tickCount, this.tickCount + pTicks));
        this.onCooldownStarted(id, pTicks);
    }

    public void removeCooldown(ResourceLocation id) {
        this.cooldowns.remove(id);
        this.onCooldownEnded(id);
    }

    protected void onCooldownStarted(ResourceLocation id, int pTicks) {
        if (!this.player.m_9236_().m_5776_()) {
            NetworkHandler.sendToClientPlayer(new SCustomCoolDownMessage(id, pTicks), this.player);
        }
    }

    protected void onCooldownEnded(ResourceLocation id) {
        if (!this.player.m_9236_().m_5776_()) {
            NetworkHandler.sendToClientPlayer(new SCustomCoolDownMessage(id, 0), this.player);
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public static class CooldownInstance {
        final int startTime;
        final int endTime;

        CooldownInstance(int pStartTime, int pEndTime) {
            this.startTime = pStartTime;
            this.endTime = pEndTime;
        }
    }
}

