/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.gametest.conditions;

import com.almostreliable.lootjs.forge.gametest.GameTestUtils;
import com.almostreliable.lootjs.loot.condition.MatchKillerDistance;
import com.almostreliable.lootjs.loot.condition.builder.DistancePredicateBuilder;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="lootjs")
@PrefixGameTestTemplate(value=false)
public class MatchKillerDistanceTest {
    private static final BlockPos TEST_POS = new BlockPos(0, 0, 0);

    @GameTest(m_177046_="empty_test_structure")
    public void matchDistance(GameTestHelper helper) {
        Player player = helper.m_177368_();
        Cow cow = (Cow)GameTestUtils.simpleEntity(EntityType.f_20557_, helper.m_177100_(), TEST_POS);
        DamageSource ds = cow.m_269291_().m_269075_(player);
        LootParams params = new LootParams.Builder(helper.m_177100_()).m_287286_(LootContextParams.f_81455_, (Object)cow).m_287286_(LootContextParams.f_81460_, (Object)cow.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)ds).m_287289_(LootContextParams.f_81458_, (Object)ds.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)ds.m_7640_()).m_287286_(LootContextParams.f_81456_, (Object)player).m_287239_(player.m_36336_()).m_287235_(LootContextParamSets.f_81415_);
        LootContext ctx = new LootContext.Builder(params).m_287259_(null);
        double dist = player.m_20270_((Entity)cow);
        MatchKillerDistance mkd = new MatchKillerDistance(new DistancePredicateBuilder().absolute(new MinMaxBounds.Doubles(Double.valueOf(dist - 1.0), Double.valueOf(dist + 1.0))).build());
        helper.m_177279_(() -> GameTestUtils.assertTrue(helper, mkd.test(ctx), "MatchKillerDistance check should pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void failDistance(GameTestHelper helper) {
        Player player = helper.m_177368_();
        Cow cow = (Cow)GameTestUtils.simpleEntity(EntityType.f_20557_, helper.m_177100_(), TEST_POS);
        DamageSource ds = cow.m_269291_().m_269075_(player);
        LootParams params = new LootParams.Builder(helper.m_177100_()).m_287286_(LootContextParams.f_81455_, (Object)cow).m_287286_(LootContextParams.f_81460_, (Object)cow.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)ds).m_287289_(LootContextParams.f_81458_, (Object)ds.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)ds.m_7640_()).m_287286_(LootContextParams.f_81456_, (Object)player).m_287239_(player.m_36336_()).m_287235_(LootContextParamSets.f_81415_);
        LootContext ctx = new LootContext.Builder(params).m_287259_(null);
        MatchKillerDistance mkd = new MatchKillerDistance(new DistancePredicateBuilder().absolute(new MinMaxBounds.Doubles(Double.valueOf(1000.0), Double.valueOf(1000.0))).build());
        helper.m_177279_(() -> GameTestUtils.assertFalse(helper, mkd.test(ctx), "MatchKillerDistance check should fail"));
    }
}

