/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.gametest;

import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootJSParamSets;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class GameTestUtils {
    public static LootContext unknownContext(ServerLevel level, Vec3 origin) {
        LootParams params = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)origin).m_287235_(LootContextParamSets.f_81411_);
        return new LootContext.Builder(params).m_287259_(null);
    }

    public static LootContext chestContext(ServerLevel level, Vec3 origin, @Nullable Player player) {
        LootParams.Builder pb = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)origin);
        if (player != null) {
            pb.m_287286_(LootContextParams.f_81455_, (Object)player);
        }
        LootParams params = pb.m_287235_(LootContextParamSets.f_81411_);
        return new LootContext.Builder(params).m_287259_(null);
    }

    public static ILootContextData fillExampleLoot(LootContext context) {
        ILootContextData data = (ILootContextData)context.m_78953_(LootJSParamSets.DATA);
        assert (data != null);
        data.setGeneratedLoot(Stream.of(new ItemStack((ItemLike)Items.f_42415_), new ItemStack((ItemLike)Items.f_42691_, 10), new ItemStack((ItemLike)Items.f_42477_)).collect(Collectors.toList()));
        return data;
    }

    public static ILootContextData fillExampleLoot(LootContext context, ItemStack ... items) {
        ILootContextData data = (ILootContextData)context.m_78953_(LootJSParamSets.DATA);
        assert (data != null);
        data.setGeneratedLoot(Stream.of(items).collect(Collectors.toList()));
        return data;
    }

    public static ILootContextData fillExampleLoot(LootContext context, Item ... items) {
        ILootContextData data = (ILootContextData)context.m_78953_(LootJSParamSets.DATA);
        assert (data != null);
        data.setGeneratedLoot(Stream.of(items).map(ItemStack::new).collect(Collectors.toList()));
        return data;
    }

    public static <E extends Entity> E simpleEntity(EntityType<E> entityType, ServerLevel level, BlockPos pos) {
        Entity entity = entityType.m_262455_(level, null, e -> {}, pos, MobSpawnType.COMMAND, false, false);
        if (entity == null) {
            throw new RuntimeException("Entity type + '" + String.valueOf(BuiltInRegistries.f_256780_.m_7981_(entityType)) + "' cannot be created through 'GameTestUtils::simpleEntity'");
        }
        return (E)entity;
    }

    public static void assertFalse(GameTestHelper helper, boolean condition, String message) {
        if (condition) {
            helper.m_177284_(message);
        }
    }

    public static void assertTrue(GameTestHelper helper, boolean condition, String message) {
        if (!condition) {
            helper.m_177284_(message);
        }
    }

    public static void assertFalse(GameTestHelper helper, boolean condition) {
        GameTestUtils.assertFalse(helper, condition, "Expected condition to be false");
    }

    public static void assertTrue(GameTestHelper helper, boolean condition) {
        GameTestUtils.assertTrue(helper, condition, "Expected condition to be true");
    }

    public static void assertEquals(GameTestHelper helper, Object expected, Object actual) {
        if (!Objects.equals(expected, actual)) {
            helper.m_177284_("Expected " + String.valueOf(expected) + " but got " + String.valueOf(actual));
        }
    }

    public static void assertNotEquals(GameTestHelper helper, Object expected, Object actual) {
        if (Objects.equals(expected, actual)) {
            helper.m_177284_("Expected " + String.valueOf(expected) + " and " + String.valueOf(actual) + " to be different");
        }
    }

    public static void assertNull(GameTestHelper helper, @Nullable Object actual) {
        if (actual != null) {
            helper.m_177284_("Expected null but got " + String.valueOf(actual));
        }
    }

    public static void assertNotNull(GameTestHelper helper, @Nullable Object actual) {
        if (actual == null) {
            helper.m_177284_("Expected not null");
        }
    }
}

