/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonMobEffect;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstBlock;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ThirstDataManager;
import sfiomn.legendarysurvivaloverhaul.api.thirst.HydrationEnum;
import sfiomn.legendarysurvivaloverhaul.api.thirst.IThirstUtil;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.thirst.ThirstCapability;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.origins.OriginsUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;

public class ThirstUtilInternal
implements IThirstUtil {
    public static final String HYDRATION_ENUM_TAG = "legendarysurvivaloverhaul:HydrationPurity";
    public static final String CAPACITY_TAG = "legendarysurvivaloverhaul:HydrationCapacity";

    @Override
    public void setThirstEnumTag(ItemStack stack, HydrationEnum hydrationEnum) {
        CompoundTag compound;
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if ((compound = stack.m_41783_()) != null) {
            compound.m_128359_(HYDRATION_ENUM_TAG, hydrationEnum.getName());
        }
    }

    @Override
    public HydrationEnum getHydrationEnumTag(ItemStack stack) {
        CompoundTag compound;
        if (stack.m_41782_() && (compound = stack.m_41783_()) != null && compound.m_128441_(HYDRATION_ENUM_TAG)) {
            String hydrationEnumName = compound.m_128461_(HYDRATION_ENUM_TAG);
            return HydrationEnum.getByName(hydrationEnumName);
        }
        return null;
    }

    @Override
    public void removeHydrationEnumTag(ItemStack stack) {
        CompoundTag compound;
        if (stack.m_41782_() && (compound = stack.m_41783_()) != null && compound.m_128441_(HYDRATION_ENUM_TAG)) {
            compound.m_128473_(HYDRATION_ENUM_TAG);
        }
    }

    @Override
    public void setCapacityTag(ItemStack stack, int capacity) {
        CompoundTag compound;
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if ((compound = stack.m_41783_()) != null) {
            compound.m_128405_(CAPACITY_TAG, capacity);
        }
    }

    @Override
    public int getCapacityTag(ItemStack stack) {
        CompoundTag compound;
        if (stack.m_41782_() && (compound = stack.m_41783_()) != null && compound.m_128441_(CAPACITY_TAG)) {
            return compound.m_128451_(CAPACITY_TAG);
        }
        return 0;
    }

    @Override
    public void removeCapacityTag(ItemStack stack) {
        CompoundTag compound;
        if (stack.m_41782_() && (compound = stack.m_41783_()) != null && compound.m_128441_(CAPACITY_TAG)) {
            compound.m_128473_(CAPACITY_TAG);
        }
    }

    @Override
    public void takeDrink(Player player, ItemStack itemStack) {
        if (!Config.Baked.thirstEnabled || !ThirstUtil.isThirstActive(player)) {
            return;
        }
        JsonThirstConsumable jsonThirstConsumable = ThirstDataManager.getConsumable(itemStack);
        if (jsonThirstConsumable != null) {
            ThirstUtil.takeDrink(player, jsonThirstConsumable.hydration, jsonThirstConsumable.saturation, jsonThirstConsumable.effects);
        }
    }

    @Override
    public void takeDrink(Player player, int hydration, float saturation, List<JsonMobEffect> effects) {
        if (!Config.Baked.thirstEnabled || !ThirstUtil.isThirstActive(player)) {
            return;
        }
        ThirstCapability capability = CapabilityUtil.getThirstCapability(player);
        if (!capability.isHydrationLevelAtMax()) {
            capability.addHydrationLevel(hydration);
            capability.addSaturationLevel(saturation);
        }
        for (JsonMobEffect effect : effects) {
            MobEffect mobEffect;
            if (!(effect.chance >= 0.0f) || effect.duration <= 0 || effect.name.isEmpty() || !(player.m_9236_().f_46441_.m_188501_() < effect.chance) || (mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effect.name))) == null) continue;
            int effectDuration = effect.duration;
            if (Config.Baked.cumulativeThirstEffectDuration && mobEffect == MobEffectRegistry.THIRST.get() && player.m_21124_((MobEffect)MobEffectRegistry.THIRST.get()) != null) {
                effectDuration += Objects.requireNonNull(player.m_21124_((MobEffect)MobEffectRegistry.THIRST.get())).m_19557_();
            }
            player.m_7292_(new MobEffectInstance(mobEffect, effectDuration, effect.amplifier, false, true, true));
        }
    }

    @Override
    public void takeDrink(Player player, int hydration, float saturation) {
        this.takeDrink(player, hydration, saturation, Collections.emptyList());
    }

    @Override
    public void addExhaustion(Player player, float exhaustion) {
        ThirstCapability thirstCap = CapabilityUtil.getThirstCapability(player);
        thirstCap.addThirstExhaustion(exhaustion);
    }

    @Override
    public JsonThirstBlock getFluidThirstLookedAt(Player player, double finalDistance) {
        ResourceLocation rain = new ResourceLocation("rain");
        if (player.m_5686_(1.0f) < -60.0f && player.m_9236_().m_46758_(player.m_20183_().m_7494_()) && ThirstDataManager.getBlock(rain) != null) {
            List<JsonThirstBlock> thirstPropertyList = ThirstDataManager.getBlock(rain);
            if (thirstPropertyList == null || thirstPropertyList.isEmpty()) {
                return null;
            }
            return thirstPropertyList.get(0);
        }
        HitResult positionLookedAt = player.m_19907_(finalDistance, 0.0f, true);
        if (positionLookedAt.m_6662_() == HitResult.Type.BLOCK) {
            FluidState fluidState = player.m_9236_().m_6425_(((BlockHitResult)positionLookedAt).m_82425_());
            ResourceLocation fluidRegistryName = ForgeRegistries.FLUIDS.getKey((Object)fluidState.m_76152_());
            JsonThirstBlock defaultThirst = null;
            if (fluidRegistryName != null && !fluidState.m_76178_()) {
                if (LegendarySurvivalOverhaul.curiosLoaded && CuriosUtil.isCurioItemEquipped(player, (Item)ItemRegistry.NETHER_CHALICE.get()) && (fluidState.m_192917_((Fluid)Fluids.f_76194_) || fluidState.m_192917_((Fluid)Fluids.f_76195_))) {
                    return new JsonThirstBlock(Config.Baked.hydrationLava, (float)Config.Baked.saturationLava, new ArrayList<JsonMobEffect>(), new HashMap<String, String>());
                }
                if (LegendarySurvivalOverhaul.originsLoaded && OriginsUtil.isOrigin(player, OriginsUtil.BLAZEBORN) && (fluidState.m_192917_((Fluid)Fluids.f_76194_) || fluidState.m_192917_((Fluid)Fluids.f_76195_))) {
                    return new JsonThirstBlock(Config.Baked.hydrationLavaBlazeborn, (float)Config.Baked.saturationLavaBlazeborn, new ArrayList<JsonMobEffect>(), new HashMap<String, String>());
                }
                List<JsonThirstBlock> jsonBlockFluidThirsts = ThirstDataManager.getBlock(fluidRegistryName);
                if (jsonBlockFluidThirsts == null) {
                    return null;
                }
                for (JsonThirstBlock thirstInfo : jsonBlockFluidThirsts) {
                    if (thirstInfo == null) continue;
                    if (thirstInfo.isDefault()) {
                        defaultThirst = thirstInfo;
                    }
                    if (!thirstInfo.matchesState(fluidState)) continue;
                    return thirstInfo;
                }
                return defaultThirst;
            }
        }
        return null;
    }

    @Override
    public JsonThirstBlock getBlockThirstLookedAt(Player player, double finalDistance) {
        HitResult positionLookedAt = player.m_19907_(finalDistance, 0.0f, true);
        if (positionLookedAt.m_6662_() == HitResult.Type.BLOCK) {
            JsonThirstBlock defaultThirst = null;
            BlockState blockState = player.m_9236_().m_8055_(((BlockHitResult)positionLookedAt).m_82425_());
            ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
            if (blockRegistryName != null) {
                List<JsonThirstBlock> jsonBlockFluidThirsts = ThirstDataManager.getBlock(blockRegistryName);
                if (jsonBlockFluidThirsts == null) {
                    return null;
                }
                for (JsonThirstBlock thirstInfo : jsonBlockFluidThirsts) {
                    if (thirstInfo == null) continue;
                    if (thirstInfo.isDefault()) {
                        defaultThirst = thirstInfo;
                    }
                    if (!thirstInfo.matchesState(blockState)) continue;
                    return thirstInfo;
                }
                return defaultThirst;
            }
        }
        return null;
    }

    @Override
    public void deactivateThirst(Player player) {
        ThirstCapability cap = CapabilityUtil.getThirstCapability(player);
        cap.setThirstTickTimer(-1);
        cap.setDirty();
    }

    @Override
    public void activateThirst(Player player) {
        ThirstCapability cap = CapabilityUtil.getThirstCapability(player);
        if (cap.getThirstTickTimer() == -1) {
            cap.setThirstTickTimer(0);
            cap.setDirty();
        }
    }

    @Override
    public boolean isThirstActive(Player player) {
        return CapabilityUtil.getThirstCapability(player).getThirstTickTimer() != -1;
    }
}

