/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util.internal;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.api.health.IHealthUtil;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.health.HealthCapability;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.AttributeRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttributeBuilder;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;

public class HealthUtilInternal
implements IHealthUtil {
    public static final UUID HEALTH_ATTRIBUTE_UUID = UUID.fromString("b158dbba-c193-4301-9dfd-82c4347b2cf4");
    public static final UUID INITIAL_PERMANENT_HEART_ATTRIBUTE_UUID = UUID.fromString("81e7fd2b-90d2-4673-84f6-8bd343fd7c5e");
    public static final UUID INITIAL_BROKEN_HEART_RESILIENCE_ATTRIBUTE_UUID = UUID.fromString("eb13fc3b-cc33-4716-a0b0-9f4cdd7704ba");
    public static final AttributeBuilder HEALTH_ATTRIBUTE = new AttributeBuilder(Attributes.f_22276_, "attribute.legendarysurvivaloverhaul.max_health");
    public static final AttributeBuilder BROKEN_HEART_ATTRIBUTE = new AttributeBuilder((Attribute)AttributeRegistry.BROKEN_HEART.get(), "attribute.legendarysurvivaloverhaul.broken_heart");
    public static final AttributeBuilder PERMANENT_HEART_ATTRIBUTE = new AttributeBuilder((Attribute)AttributeRegistry.PERMANENT_HEART.get(), "attribute.legendarysurvivaloverhaul.permanent_heart");
    public static final AttributeBuilder BROKEN_HEART_RESILIENCE_ATTRIBUTE = new AttributeBuilder((Attribute)AttributeRegistry.BROKEN_HEART_RESILIENCE.get(), "attribute.legendarysurvivaloverhaul.broken_heart_resilience");

    @Override
    public void updatePlayerMaxHealthAttribute(Player player) {
        double maxHealth = this.getPlayerMaxHealth(player);
        double baseHealth = 20.0;
        if (player.m_21051_(Attributes.f_22276_) != null) {
            baseHealth = Objects.requireNonNull(player.m_21051_(Attributes.f_22276_)).m_22115_();
        }
        HEALTH_ATTRIBUTE.addModifier(player, HEALTH_ATTRIBUTE_UUID, maxHealth - (baseHealth += this.getMaxHealthFromModifiers(player)));
        player.m_21153_(Math.min(player.m_21233_(), player.m_21223_()));
    }

    @Override
    public double getPlayerMaxHealth(Player player) {
        double maxHealth = Config.Baked.initialHealth;
        maxHealth += this.getMaxHealthFromModifiers(player);
        if (Config.Baked.healthOverhaulEnabled) {
            HealthCapability healthCapability = CapabilityUtil.getHealthCapability(player);
            float additionalHealth = healthCapability.getAdditionalHealth();
            int minhHearthLimitWithBrokenHearth = (int)player.m_21133_((Attribute)AttributeRegistry.BROKEN_HEART_RESILIENCE.get());
            maxHealth += (double)additionalHealth - Mth.m_14008_((double)((int)player.m_21133_((Attribute)AttributeRegistry.BROKEN_HEART.get()) * 2), (double)0.0, (double)(maxHealth + (double)additionalHealth - (double)(minhHearthLimitWithBrokenHearth * 2)));
        }
        return maxHealth;
    }

    @Override
    public double getPlayerStableMaxHealth(Player player) {
        double maxHealth = Config.Baked.initialHealth;
        maxHealth += this.getMaxHealthFromModifiers(player);
        if (Config.Baked.healthOverhaulEnabled) {
            HealthCapability healthCapability = CapabilityUtil.getHealthCapability(player);
            maxHealth += (double)healthCapability.getAdditionalHealth();
        }
        return maxHealth;
    }

    @Override
    public int getEffectiveBrokenHearts(Player player) {
        if (!Config.Baked.healthOverhaulEnabled) {
            return 0;
        }
        double maxHealth = this.getPlayerStableMaxHealth(player);
        int brokenHearts = (int)player.m_21133_((Attribute)AttributeRegistry.BROKEN_HEART.get());
        int resilientHearts = (int)player.m_21133_((Attribute)AttributeRegistry.BROKEN_HEART_RESILIENCE.get());
        return Mth.m_14045_((int)brokenHearts, (int)0, (int)((int)Math.ceil(maxHealth / 2.0) - resilientHearts));
    }

    @Override
    public void initializeHealthAttributes(Player player) {
        PERMANENT_HEART_ATTRIBUTE.addModifier(player, INITIAL_PERMANENT_HEART_ATTRIBUTE_UUID, (double)(Config.Baked.permanentHearts - 1));
        BROKEN_HEART_RESILIENCE_ATTRIBUTE.addModifier(player, INITIAL_BROKEN_HEART_RESILIENCE_ATTRIBUTE_UUID, (double)(Config.Baked.resilientHeartsWithBrokenHearts - 1));
    }

    @Override
    public float hurtPlayer(Player player, float damageValue) {
        HealthCapability healthCapability = CapabilityUtil.getHealthCapability(player);
        float shieldValue = Math.max(healthCapability.getShieldHealth(), 0.0f);
        healthCapability.addShieldHealth(-damageValue);
        return Math.max(damageValue - shieldValue, 0.0f);
    }

    @Override
    public void loseHearth(Player player, int amountLost) {
        HealthCapability healthCapability = CapabilityUtil.getHealthCapability(player);
        int minhHearthLimit = (int)player.m_21133_((Attribute)AttributeRegistry.PERMANENT_HEART.get());
        int actuallyLostHearts = Math.min((int)Math.ceil((double)player.m_21233_() / 2.0) - minhHearthLimit, amountLost);
        if (actuallyLostHearts > 0) {
            healthCapability.setAdditionalHealth(healthCapability.getAdditionalHealth() - (float)(actuallyLostHearts * 2));
            this.updatePlayerMaxHealthAttribute(player);
        }
    }

    @Override
    public void updateBrokenHearts(Player player, UUID attributeUuid, int brokenHearts) {
        BROKEN_HEART_ATTRIBUTE.addModifier(player, attributeUuid, (double)brokenHearts);
        this.updatePlayerMaxHealthAttribute(player);
    }

    private double getMaxHealthFromModifiers(Player player) {
        double maxHealthModified = 0.0;
        if (player.m_21051_(Attributes.f_22276_) == null) {
            return maxHealthModified;
        }
        for (AttributeModifier attributeModifier : Objects.requireNonNull(player.m_21051_(Attributes.f_22276_)).m_22122_()) {
            if (attributeModifier.m_22209_().equals(HEALTH_ATTRIBUTE_UUID)) continue;
            maxHealthModified += attributeModifier.m_22218_();
        }
        return maxHealthModified;
    }
}

