/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util;

import net.minecraft.world.phys.AABB;

public final class MathUtil {
    private MathUtil() {
    }

    public static float invLerp(float from, float to, float value) {
        return (value - from) / (to - from);
    }

    public static float round(float value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (float)Math.round(value * (float)scale) / (float)scale;
    }

    public static float ceil(float value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (float)Math.ceil(value * (float)scale) / (float)scale;
    }

    public static AABB inflateMultiplier(AABB aabb1, AABB aabb2) {
        double newMinX = aabb1.f_82288_ + aabb1.m_82362_() * aabb2.f_82288_;
        double newMinY = aabb1.f_82289_ + aabb1.m_82376_() * aabb2.f_82289_;
        double newMinZ = aabb1.f_82290_ + aabb1.m_82385_() * aabb2.f_82290_;
        double newMaxX = aabb1.f_82288_ + aabb1.m_82362_() * aabb2.f_82291_;
        double newMaxY = aabb1.f_82289_ + aabb1.m_82376_() * aabb2.f_82292_;
        double newMaxZ = aabb1.f_82290_ + aabb1.m_82385_() * aabb2.f_82293_;
        return new AABB(newMinX, newMinY, newMinZ, newMaxX, newMaxY, newMaxZ);
    }

    public static AABB inflateMultiplier(AABB original, double inflateValue) {
        AABB inflateAABB = new AABB(-inflateValue, -inflateValue, -inflateValue, 1.0 + inflateValue, 1.0 + inflateValue, 1.0 + inflateValue);
        return MathUtil.inflateMultiplier(original, inflateAABB);
    }

    public static AABB inflate(AABB original, AABB inflateValues) {
        double newMinX = original.f_82288_ + inflateValues.f_82288_;
        double newMinY = original.f_82289_ + inflateValues.f_82289_;
        double newMinZ = original.f_82290_ + inflateValues.f_82290_;
        double newMaxX = original.f_82291_ + inflateValues.f_82291_;
        double newMaxY = original.f_82292_ + inflateValues.f_82292_;
        double newMaxZ = original.f_82293_ + inflateValues.f_82293_;
        return new AABB(newMinX, newMinY, newMinZ, newMaxX, newMaxY, newMaxZ);
    }

    public static AABB horizontalInflate(AABB original, double inflateValue) {
        AABB inflateAABB = new AABB(-inflateValue, 0.0, -inflateValue, inflateValue, 0.0, inflateValue);
        return MathUtil.inflate(original, inflateAABB);
    }

    public static AABB horizontalUpInflate(AABB original, double inflateValue) {
        AABB inflateAABB = new AABB(-inflateValue, 0.0, -inflateValue, inflateValue, inflateValue, inflateValue);
        return MathUtil.inflate(original, inflateAABB);
    }

    public static AABB horizontalDownInflate(AABB original, double inflateValue) {
        AABB inflateAABB = new AABB(-inflateValue, -inflateValue, -inflateValue, inflateValue, 0.0, inflateValue);
        return MathUtil.inflate(original, inflateAABB);
    }
}

