/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.wetness.WetnessCapability;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.wetness.WetnessProvider;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class UpdateWetnessPacket {
    private CompoundTag compound;

    public UpdateWetnessPacket(Tag compound) {
        this.compound = (CompoundTag)compound;
    }

    public UpdateWetnessPacket() {
    }

    public static void encode(UpdateWetnessPacket message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.compound);
    }

    public static UpdateWetnessPacket decode(FriendlyByteBuf buffer) {
        return new UpdateWetnessPacket((Tag)buffer.m_130260_());
    }

    public static void handle(UpdateWetnessPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> UpdateWetnessPacket.syncWetness(message.compound)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncWetness(final CompoundTag compound) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    WetnessCapability wetness = (WetnessCapability)player.getCapability(WetnessProvider.WETNESS_CAPABILITY).orElse((Object)new WetnessCapability());
                    wetness.readNBT(compound);
                }
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Tag compound) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new UpdateWetnessPacket(compound));
    }
}

