/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureConsumable;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureConsumableListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncTemperatureConsumablesPacket {
    private final Map<ResourceLocation, List<JsonTemperatureConsumable>> temperatureConsumables;
    private final int size;

    public SyncTemperatureConsumablesPacket(Map<ResourceLocation, List<JsonTemperatureConsumable>> temperatureConsumables) {
        this.temperatureConsumables = Map.copyOf(temperatureConsumables);
        this.size = temperatureConsumables.size();
    }

    public static void encode(SyncTemperatureConsumablesPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, List<JsonTemperatureConsumable>> e : message.temperatureConsumables.entrySet()) {
            buffer.m_130085_(e.getKey());
            buffer.writeInt(e.getValue().size());
            DataResult r = JsonTemperatureConsumable.LIST_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, e.getValue());
            r.result().ifPresent(j -> ((ListTag)j).forEach(k -> buffer.m_130079_((CompoundTag)k)));
        }
    }

    public static SyncTemperatureConsumablesPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, List<JsonTemperatureConsumable>> temperatureConsumables = new HashMap<ResourceLocation, List<JsonTemperatureConsumable>>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            int jtcSize = buffer.readInt();
            ArrayList jtcList = new ArrayList();
            for (int j = 0; j < jtcSize; ++j) {
                CompoundTag tag = buffer.m_130260_();
                if (tag == null) continue;
                DataResult r = JsonTemperatureConsumable.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
                r.result().ifPresent(jtcList::add);
            }
            temperatureConsumables.put(key, jtcList);
        }
        return new SyncTemperatureConsumablesPacket(temperatureConsumables);
    }

    public static void handle(SyncTemperatureConsumablesPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncTemperatureConsumablesPacket.syncTemperatureConsumables(message.temperatureConsumables)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncTemperatureConsumables(final Map<ResourceLocation, List<JsonTemperatureConsumable>> temperatureConsumables) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                TemperatureConsumableListener.acceptServerTemperatureConsumables(temperatureConsumables);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, List<JsonTemperatureConsumable>> temperatureConsumables) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncTemperatureConsumablesPacket(temperatureConsumables));
    }
}

