/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.common.integration.supplementaries.SupplementariesUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.heal.BodyHealingItem;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;

public class BodyPartHealingTimeMessage {
    private CompoundTag compound;

    public BodyPartHealingTimeMessage(BodyPartEnum bodyPart, InteractionHand hand, boolean consumeItem, float healingValue, int healingTime) {
        CompoundTag bodyPartHealNbt = new CompoundTag();
        bodyPartHealNbt.m_128359_("bodyPartEnum", bodyPart.name());
        bodyPartHealNbt.m_128379_("mainHand", hand == InteractionHand.MAIN_HAND);
        bodyPartHealNbt.m_128379_("consumeItem", consumeItem);
        bodyPartHealNbt.m_128350_("healingValue", healingValue);
        bodyPartHealNbt.m_128405_("healingTime", healingTime);
        this.compound = bodyPartHealNbt;
    }

    public BodyPartHealingTimeMessage(Tag nbt) {
        this.compound = (CompoundTag)nbt;
    }

    public BodyPartHealingTimeMessage() {
    }

    public static void encode(BodyPartHealingTimeMessage message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.compound);
    }

    public static BodyPartHealingTimeMessage decode(FriendlyByteBuf buffer) {
        return new BodyPartHealingTimeMessage((Tag)buffer.m_130260_());
    }

    public static void handle(BodyPartHealingTimeMessage message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer player;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (player = context.getSender()) != null) {
            context.enqueueWork(() -> BodyPartHealingTimeMessage.applyHealingItemOnServer(player, message.compound));
        }
        supplier.get().setPacketHandled(true);
    }

    public static void applyHealingItemOnServer(ServerPlayer player, CompoundTag nbt) {
        BodyPartEnum bodyPartEnum = BodyPartEnum.valueOf(nbt.m_128461_("bodyPartEnum"));
        InteractionHand hand = nbt.m_128471_("mainHand") ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack itemStack = player.m_21120_(hand);
        player.m_284548_().m_6269_(null, (Entity)player, (SoundEvent)SoundRegistry.HEAL_BODY_PART.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (nbt.m_128471_("consumeItem")) {
            if (itemStack.m_41720_() instanceof BodyHealingItem) {
                ((BodyHealingItem)itemStack.m_41720_()).runSecondaryEffect((Player)player, itemStack);
            }
            if (!player.m_7500_()) {
                ItemStack itemStackInBasket = SupplementariesUtil.getSelectedItemInLunchBasket(itemStack);
                if (itemStackInBasket != ItemStack.f_41583_) {
                    itemStackInBasket.m_41774_(1);
                } else {
                    itemStack.m_41774_(1);
                }
            }
        }
        BodyDamageUtil.applyHealingTimeBodyPart((Player)player, bodyPartEnum, nbt.m_128457_("healingValue"), nbt.m_128451_("healingTime"));
    }

    public static void sendToServer(BodyPartEnum bodyPart, InteractionHand hand, boolean consumeItem, float healingValue, int healingTime) {
        BodyPartHealingTimeMessage bodyPartHealingTimeMessageToServer = new BodyPartHealingTimeMessage(bodyPart, hand, consumeItem, healingValue, healingTime);
        NetworkHandler.INSTANCE.sendToServer((Object)bodyPartHealingTimeMessageToServer);
    }
}

