/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.config;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureDisplayEnum;
import sfiomn.legendarysurvivaloverhaul.config.json_old.JsonConfigRegistration;
import sfiomn.legendarysurvivaloverhaul.util.ItemUtil;

public class Config {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    public static void register() {
        for (Path configPath : new Path[]{LegendarySurvivalOverhaul.modConfigPath}) {
            try {
                Files.createDirectory(configPath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to create Legendary Survival Overhaul config directory " + configPath);
                LegendarySurvivalOverhaul.LOGGER.error((Object)e.getStackTrace());
            }
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC, "legendarysurvivaloverhaul/legendarysurvivaloverhaul-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC, "legendarysurvivaloverhaul/legendarysurvivaloverhaul-common.toml");
        JsonConfigRegistration.init(LegendarySurvivalOverhaul.modConfigJsons.toFile());
    }

    private static boolean validateDouble(Object obj) {
        return obj instanceof Double;
    }

    private static boolean validatePositiveInt(Object obj) {
        Integer intValue;
        return obj instanceof Integer && (intValue = (Integer)obj) >= 0;
    }

    private static boolean validatePercentDouble(Object obj) {
        Double doubleValue;
        return obj instanceof Double && (doubleValue = (Double)obj) >= 0.0 && doubleValue <= 1.0;
    }

    private static boolean validateEffectName(Object obj) {
        String effectName;
        return obj instanceof String && ForgeRegistries.MOB_EFFECTS.containsKey(new ResourceLocation(effectName = (String)obj));
    }

    private static boolean validateEntityType(Object obj) {
        String entityName;
        return obj instanceof String && ForgeRegistries.ENTITY_TYPES.containsKey(new ResourceLocation(entityName = (String)obj));
    }

    static {
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue routinePacketSync;
        public final ForgeConfigSpec.BooleanValue hideInfoFromDebug;
        public final ForgeConfigSpec.BooleanValue naturalRegenerationEnabled;
        public final ForgeConfigSpec.BooleanValue vanillaFreezeEnabled;
        public final ForgeConfigSpec.EnumValue<ItemUtil.CompassInfo> compassInfoMode;
        public final ForgeConfigSpec.BooleanValue showCoordinateOnMap;
        public final ForgeConfigSpec.DoubleValue initialHealth;
        public final ForgeConfigSpec.DoubleValue baseFoodExhaustion;
        public final ForgeConfigSpec.DoubleValue sprintingFoodExhaustion;
        public final ForgeConfigSpec.DoubleValue onAttackFoodExhaustion;
        public final ForgeConfigSpec.BooleanValue temperatureEnabled;
        public final ForgeConfigSpec.IntValue tempTickTime;
        public final ForgeConfigSpec.DoubleValue minTemperatureModification;
        public final ForgeConfigSpec.DoubleValue maxTemperatureModification;
        public final ForgeConfigSpec.BooleanValue dangerousHeatTemperature;
        public final ForgeConfigSpec.BooleanValue dangerousColdTemperature;
        public final ForgeConfigSpec.DoubleValue goldFernChance;
        public final ForgeConfigSpec.BooleanValue temperatureImmunityOnDeathEnabled;
        public final ForgeConfigSpec.IntValue temperatureImmunityOnDeathTime;
        public final ForgeConfigSpec.BooleanValue temperatureImmunityOnFirstSpawnEnabled;
        public final ForgeConfigSpec.IntValue temperatureImmunityOnFirstSpawnTime;
        public final ForgeConfigSpec.BooleanValue heatTemperatureSecondaryEffects;
        public final ForgeConfigSpec.BooleanValue coldTemperatureSecondaryEffects;
        public final ForgeConfigSpec.DoubleValue heatThirstEffectModifier;
        public final ForgeConfigSpec.DoubleValue coldHungerEffectModifier;
        public final ForgeConfigSpec.BooleanValue biomeEffectsEnabled;
        public final ForgeConfigSpec.DoubleValue biomeDrynessMultiplier;
        public final ForgeConfigSpec.DoubleValue biomeTemperatureMultiplier;
        public final ForgeConfigSpec.DoubleValue timeModifier;
        public final ForgeConfigSpec.DoubleValue biomeTimeMultiplier;
        public final ForgeConfigSpec.DoubleValue shadeTimeModifier;
        public final ForgeConfigSpec.DoubleValue shadeTimeModifierThreshold;
        public final ForgeConfigSpec.DoubleValue altitudeModifier;
        public final ForgeConfigSpec.DoubleValue sprintModifier;
        public final ForgeConfigSpec.DoubleValue onFireModifier;
        public final ForgeConfigSpec.BooleanValue wetnessEnabled;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> wetnessImmunityMounts;
        public final ForgeConfigSpec.DoubleValue wetMultiplier;
        public final ForgeConfigSpec.IntValue wetnessTickTimer;
        public final ForgeConfigSpec.IntValue wetnessDecrease;
        public final ForgeConfigSpec.IntValue wetnessRainIncrease;
        public final ForgeConfigSpec.IntValue wetnessFluidIncrease;
        public final ForgeConfigSpec.IntValue tempInfluenceMaximumDist;
        public final ForgeConfigSpec.DoubleValue tempInfluenceUpDistMultiplier;
        public final ForgeConfigSpec.DoubleValue tempInfluenceInWaterDistMultiplier;
        public final ForgeConfigSpec.DoubleValue tempInfluenceOutsideDistMultiplier;
        public final ForgeConfigSpec.DoubleValue undergroundBiomeTemperatureMultiplier;
        public final ForgeConfigSpec.IntValue undergroundEffectStartDistanceToWS;
        public final ForgeConfigSpec.IntValue undergroundEffectEndDistanceToWS;
        public final ForgeConfigSpec.DoubleValue rainTemperatureModifier;
        public final ForgeConfigSpec.DoubleValue snowTemperatureModifier;
        public final ForgeConfigSpec.DoubleValue maxFreezeTemperatureModifier;
        public final ForgeConfigSpec.IntValue maxFreezeEffectTick;
        public final ForgeConfigSpec.DoubleValue playerHuddlingModifier;
        public final ForgeConfigSpec.IntValue playerHuddlingRadius;
        public final ForgeConfigSpec.DoubleValue heatingCoat1Modifier;
        public final ForgeConfigSpec.DoubleValue heatingCoat2Modifier;
        public final ForgeConfigSpec.DoubleValue heatingCoat3Modifier;
        public final ForgeConfigSpec.DoubleValue coolingCoat1Modifier;
        public final ForgeConfigSpec.DoubleValue coolingCoat2Modifier;
        public final ForgeConfigSpec.DoubleValue coolingCoat3Modifier;
        public final ForgeConfigSpec.DoubleValue thermalCoat1Modifier;
        public final ForgeConfigSpec.DoubleValue thermalCoat2Modifier;
        public final ForgeConfigSpec.DoubleValue thermalCoat3Modifier;
        public final ForgeConfigSpec.DoubleValue tfcItemHeatMultiplier;
        public final ForgeConfigSpec.DoubleValue tfcTemperatureMultiplier;
        public final ForgeConfigSpec.BooleanValue sereneSeasonsEnabled;
        public final ForgeConfigSpec.BooleanValue ssTropicalSeasonsEnabled;
        public final ForgeConfigSpec.BooleanValue ssSeasonCardsEnabled;
        public final ForgeConfigSpec.BooleanValue ssDefaultSeasonEnabled;
        public final ForgeConfigSpec.DoubleValue ssEarlySpringModifier;
        public final ForgeConfigSpec.DoubleValue ssMidSpringModifier;
        public final ForgeConfigSpec.DoubleValue ssLateSpringModifier;
        public final ForgeConfigSpec.DoubleValue ssEarlySummerModifier;
        public final ForgeConfigSpec.DoubleValue ssMidSummerModifier;
        public final ForgeConfigSpec.DoubleValue ssLateSummerModifier;
        public final ForgeConfigSpec.DoubleValue ssEarlyAutumnModifier;
        public final ForgeConfigSpec.DoubleValue ssMidAutumnModifier;
        public final ForgeConfigSpec.DoubleValue ssLateAutumnModifier;
        public final ForgeConfigSpec.DoubleValue ssEarlyWinterModifier;
        public final ForgeConfigSpec.DoubleValue ssMidWinterModifier;
        public final ForgeConfigSpec.DoubleValue ssLateWinterModifier;
        public final ForgeConfigSpec.DoubleValue ssEarlyWetSeasonModifier;
        public final ForgeConfigSpec.DoubleValue ssMidWetSeasonModifier;
        public final ForgeConfigSpec.DoubleValue ssLateWetSeasonModifier;
        public final ForgeConfigSpec.DoubleValue ssEarlyDrySeasonModifier;
        public final ForgeConfigSpec.DoubleValue ssMidDrySeasonModifier;
        public final ForgeConfigSpec.DoubleValue ssLateDrySeasonModifier;
        public final ForgeConfigSpec.BooleanValue eclipticSeasonsEnabled;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> esSpringModifier;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> esSummerModifier;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> esAutumnModifier;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> esWinterModifier;
        public final ForgeConfigSpec.BooleanValue thirstEnabled;
        public final ForgeConfigSpec.BooleanValue dangerousDehydration;
        public final ForgeConfigSpec.BooleanValue cumulativeThirstEffectDuration;
        public final ForgeConfigSpec.DoubleValue dehydrationDamageScaling;
        public final ForgeConfigSpec.DoubleValue thirstEffectModifier;
        public final ForgeConfigSpec.DoubleValue baseThirstExhaustion;
        public final ForgeConfigSpec.DoubleValue sprintingThirstExhaustion;
        public final ForgeConfigSpec.DoubleValue onJumpThirstExhaustion;
        public final ForgeConfigSpec.DoubleValue onBlockBreakThirstExhaustion;
        public final ForgeConfigSpec.DoubleValue onAttackThirstExhaustion;
        public final ForgeConfigSpec.IntValue canteenCapacity;
        public final ForgeConfigSpec.BooleanValue selfWateringCanteenEnabled;
        public final ForgeConfigSpec.IntValue selfWateringCanteenWetnessIncrease;
        public final ForgeConfigSpec.IntValue largeCanteenCapacity;
        public final ForgeConfigSpec.BooleanValue allowOverridePurifiedWater;
        public final ForgeConfigSpec.IntValue hydrationLava;
        public final ForgeConfigSpec.DoubleValue saturationLava;
        public final ForgeConfigSpec.BooleanValue glassBottleLootAfterDrink;
        public final ForgeConfigSpec.IntValue hydrationLavaBlazeborn;
        public final ForgeConfigSpec.DoubleValue saturationLavaBlazeborn;
        public final ForgeConfigSpec.DoubleValue extraThirstExhaustionShulk;
        public final ForgeConfigSpec.DoubleValue extraThirstExhaustionPhantom;
        public final ForgeConfigSpec.BooleanValue thirstEnabledIfVampire;
        public final ForgeConfigSpec.BooleanValue healthOverhaulEnabled;
        public final ForgeConfigSpec.DoubleValue maxAdditionalHealth;
        public final ForgeConfigSpec.DoubleValue maxShieldHealth;
        public final ForgeConfigSpec.BooleanValue absorptionEffectOverride;
        public final ForgeConfigSpec.IntValue heartsLostOnDeath;
        public final ForgeConfigSpec.IntValue permanentHearts;
        public final ForgeConfigSpec.IntValue resilientHeartsWithBrokenHearts;
        public final ForgeConfigSpec.DoubleValue brokenHeartsPerInjuredLimb;
        public final ForgeConfigSpec.ConfigValue<String> brokenHeartsPerInjuredLimbMode;
        public final ForgeConfigSpec.BooleanValue localizedBodyDamageEnabled;
        public final ForgeConfigSpec.DoubleValue headCriticalShotMultiplier;
        public final ForgeConfigSpec.DoubleValue bodyDamageMultiplier;
        public final ForgeConfigSpec.DoubleValue bodyHealthRatioRecoveredFromSleep;
        public final ForgeConfigSpec.DoubleValue healthRatioRecoveredFromSleep;
        public final ForgeConfigSpec.DoubleValue bodyHealingFoodExhaustion;
        public final ForgeConfigSpec.IntValue minFoodOnBodyHealing;
        public final ForgeConfigSpec.IntValue painkillerAddictionDuration;
        public final ForgeConfigSpec.DoubleValue firstAidSuppliesLimbHealthRegenerated;
        public final ForgeConfigSpec.ConfigValue<String> firstAidSuppliesLimbRegenerationMode;
        public final ForgeConfigSpec.BooleanValue firstAidSuppliesHealingOverflow;
        public final ForgeConfigSpec.IntValue firstAidSuppliesTickTimer;
        public final ForgeConfigSpec.BooleanValue firstAidSuppliesExhaustsFood;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> firstAidSuppliesBoostedOnEffects;
        public final ForgeConfigSpec.DoubleValue firstAidSuppliesBoostedTickTimerMultiplier;
        public final ForgeConfigSpec.IntValue healingHerbsUseTime;
        public final ForgeConfigSpec.IntValue healingHerbsRegenerationAmplifier;
        public final ForgeConfigSpec.IntValue healingHerbsRegenerationTickDuration;
        public final ForgeConfigSpec.IntValue plasterUseTime;
        public final ForgeConfigSpec.IntValue plasterRegenerationAmplifier;
        public final ForgeConfigSpec.IntValue plasterRegenerationTickDuration;
        public final ForgeConfigSpec.IntValue bandageUseTime;
        public final ForgeConfigSpec.IntValue bandageRegenerationAmplifier;
        public final ForgeConfigSpec.IntValue bandageRegenerationTickDuration;
        public final ForgeConfigSpec.IntValue tonicUseTime;
        public final ForgeConfigSpec.IntValue tonicRegenerationAmplifier;
        public final ForgeConfigSpec.IntValue tonicRegenerationTickDuration;
        public final ForgeConfigSpec.IntValue medikitUseTime;
        public final ForgeConfigSpec.IntValue medikitRegenerationAmplifier;
        public final ForgeConfigSpec.IntValue medikitRegenerationTickDuration;
        public final ForgeConfigSpec.IntValue morphineUseTime;
        public final ForgeConfigSpec.IntValue morphinePainkillerTickDuration;
        public final ForgeConfigSpec.ConfigValue<String> bodyPartHealthMode;
        public final ForgeConfigSpec.DoubleValue headPartHealth;
        public final ForgeConfigSpec.DoubleValue armsPartHealth;
        public final ForgeConfigSpec.DoubleValue chestPartHealth;
        public final ForgeConfigSpec.DoubleValue legsPartHealth;
        public final ForgeConfigSpec.DoubleValue feetPartHealth;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> headPartEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> headPartEffectAmplifiers;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> headPartEffectThresholds;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> armsPartEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> armsPartEffectAmplifiers;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> armsPartEffectThresholds;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bothArmsPartEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> bothArmsPartEffectAmplifiers;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> bothArmsPartEffectThresholds;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> chestPartEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> chestPartEffectAmplifiers;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> chestPartEffectThresholds;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> legsPartEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> legsPartEffectAmplifiers;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> legsPartEffectThresholds;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bothLegsPartEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> bothLegsPartEffectAmplifiers;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> bothLegsPartEffectThresholds;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> feetPartEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> feetPartEffectAmplifiers;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> feetPartEffectThresholds;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bothFeetPartEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> bothFeetPartEffectAmplifiers;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> bothFeetPartEffectThresholds;
        public final ForgeConfigSpec.BooleanValue morphineSyringeApplyPainkillerAddiction;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{" Options related to enabling/disabling specific features", " See the jsons folder to customize the temperature of specific blocks, liquids, armors, etc."}).push("core");
            this.temperatureEnabled = builder.comment(" Whether the temperature system is enabled.").define("Temperature Enabled", true);
            this.thirstEnabled = builder.comment(" Whether the thirst system is enabled.").define("Thirst Enabled", true);
            this.healthOverhaulEnabled = builder.comment(" Whether the overhaul health system is enabled.").define("Health Overhaul Enabled", true);
            this.localizedBodyDamageEnabled = builder.comment(" Whether body members receive localized damages.").define("Localized Body Damage Enabled", true);
            builder.push("advanced");
            this.routinePacketSync = builder.comment(new String[]{" How often player temperature, thirst, body damage and health is regularly synced between the client and server, in ticks.", " Lower values will increase accuracy at the cost of performance."}).defineInRange("Routine Packet Sync", 30, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("misc");
            this.compassInfoMode = builder.comment(" What information the compass returns when player is using it or in an item frame.").defineEnum("Compass Info Mode", (Enum)ItemUtil.CompassInfo.FULL);
            this.showCoordinateOnMap = builder.comment(" If enabled, use on a filled map will show destination coordinates.").define("Show Coordinate On Filled Map", true);
            this.hideInfoFromDebug = builder.comment(" If enabled, information like position and direction will be hidden from the debug screen (F3).").define("Hide Info From Debug", true);
            this.naturalRegenerationEnabled = builder.comment(" If enabled, the player can regenerate health naturally if their hunger is full enough (doesn't affect external healing, such as golden apples, the Regeneration effect, etc.)").define("Natural Regeneration Enabled", true);
            this.vanillaFreezeEnabled = builder.comment(" If enabled, the player suffers vanilla freeze when inside powder snow.").define("Vanilla Freeze Enabled", false);
            this.initialHealth = builder.comment(" How much health player will have initially.").defineInRange("Initial Player Health", 20.0, 1.0, 10000.0);
            builder.pop();
            builder.pop();
            builder.comment(" Options related to the player food data").push("food");
            this.baseFoodExhaustion = builder.comment(" Food exhausted every 10 ticks. Increase the base minecraft food exhaustion.").defineInRange("Base Food Exhaustion", 0.05, 0.0, 1000.0);
            this.sprintingFoodExhaustion = builder.comment(" Food exhausted every 10 ticks while sprinting in addition to the sprinting minecraft food exhaustion.").defineInRange("Sprinting Food Exhaustion", 0.1, 0.0, 1000.0);
            this.onAttackFoodExhaustion = builder.comment(" Food exhausted on every attack in addition to the minecraft attack food exhaustion.").defineInRange("On Attack Food Exhaustion", 0.1, 0.0, 1000.0);
            builder.pop();
            builder.comment(" Options related to the temperature system").push("temperature");
            this.dangerousHeatTemperature = builder.comment(" If enabled, players will take damage from the effects of high temperature.").define("Dangerous Heat Temperature Effects", true);
            this.dangerousColdTemperature = builder.comment(" If enabled, players will take damage from the effects of low temperature.").define("Dangerous Cold Temperature Effects", true);
            this.goldFernChance = builder.comment(" Chance of the ferns to become a gold fern when grow mature.").defineInRange("Gold Fern Chance", 0.01, 0.0, 1.0);
            builder.push("temperature-immunity");
            this.temperatureImmunityOnDeathEnabled = builder.comment(" If enabled, players will be immune to temperature effects after death.").define("Temperature Immunity On Death Enabled", true);
            this.temperatureImmunityOnDeathTime = builder.comment(" Temperature immunity period in ticks while the player is immune to temperature effects after death.").defineInRange("Temperature Immunity On Death Time", 1800, 0, 100000);
            this.temperatureImmunityOnFirstSpawnEnabled = builder.comment(" If enabled, players will be immune to temperature effects on first spawn in a world.").define("Temperature Immunity On First Spawn Enabled", true);
            this.temperatureImmunityOnFirstSpawnTime = builder.comment(" Temperature immunity period in ticks while the player is immune to temperature effects on first spawn.").defineInRange("Temperature Immunity On First Spawn Time", 1800, 0, 100000);
            builder.pop();
            builder.push("secondary_effects");
            this.heatTemperatureSecondaryEffects = builder.comment(new String[]{" If enabled, players will also receive other effects from their current temperature state.", " If the player is too hot, hydration will deplete faster."}).define("Heat Temperature Secondary Effects", true);
            this.coldTemperatureSecondaryEffects = builder.comment(new String[]{" If enabled, players will also receive other effects from their current temperature state.", " If the player is too cold, hunger will deplete faster."}).define("Cold Temperature Secondary Effects", true);
            this.heatThirstEffectModifier = builder.comment(" How much thirst exhaustion will be added every 50 ticks with no amplification effect, when the player suffers from heat.").defineInRange("Heat Thirst Effect Modifier", 0.2, 0.0, 1000.0);
            this.coldHungerEffectModifier = builder.comment(new String[]{" How much food exhaustion will be added every 50 ticks with no amplification effect, when the player suffers from frostbite.", " As reference, the hunger effect add 0.025 food exhaustion every 50 ticks."}).defineInRange("Cold Hunger Modifier", 0.1, 0.0, 1000.0);
            builder.pop();
            this.onFireModifier = builder.comment(" How much of an effect being on fire has on a player's temperature.").defineInRange("Player On Fire Modifier", 12.5, -1000.0, 1000.0);
            this.sprintModifier = builder.comment(" How much of an effect sprinting has on a player's temperature.").defineInRange("Player Sprint Modifier", 1.5, -1000.0, 1000.0);
            this.altitudeModifier = builder.comment(new String[]{" How much of an effect altitude has on player's temperature.", " Each 64 blocks further from sea level will impact player's temperature by this value.", " The sea level can be defined via datapack under the dimension's temperature.", " As an example, a value of -6 will reduce the player's temperature by 6 for each 64 blocks (the calculus is done linearly)."}).defineInRange("Altitude Modifier", -6.0, -1000.0, 1000.0);
            builder.push("wetness");
            this.wetnessEnabled = builder.comment(" Enable the wetness mechanic.").define("Wetness Enabled", true);
            this.wetnessImmunityMounts = builder.comment(" List of mounts that provide a wetness immunity.").defineListAllowEmpty("Wetness Immunity Mounts", List.of("alexscaves:submarine", "immersive_machinery:bamboo_bee", "immersive_machinery:tunnel_digger", "immersive_machinery:redstone_sheep", "immersive_machinery:copperfin"), Config::validateEntityType);
            this.wetMultiplier = builder.comment(new String[]{" How much being wet influences the player's temperature.", " It means that for a value of -10, the body temperature of the player is reduced by 10."}).defineInRange("Wetness Modifier", -10.0, -1000.0, 1000.0);
            this.wetnessTickTimer = builder.comment(new String[]{" How frequently the wetness is modified.", " By default, every 10 ticks, the wetness will either increase or decrease, based on the conditions."}).defineInRange("Wetness Tick Timer", 10, 1, 100000);
            this.wetnessDecrease = builder.comment(" How much the wetness decrease when out of water.").defineInRange("Wetness Decrease", -3, -1000, 0);
            this.wetnessRainIncrease = builder.comment(" How much the wetness increase when under rain.").defineInRange("Wetness Under Rain Increase", 7, 0, 1000);
            this.wetnessFluidIncrease = builder.comment(new String[]{" How much the wetness increase when the player is in a fluid, scale by the amount of fluid in the block.", " The defined value is for a full block of fluid, and goes up to 2 times this value when fully immerge."}).defineInRange("Wetness In Fluid Increase", 10, 0, 1000);
            builder.pop();
            builder.push("huddling");
            this.playerHuddlingModifier = builder.comment(new String[]{" How much nearby players increase the ambient temperature by.", " Note that this value stacks!"}).defineInRange("Player Huddling Modifier", 0.5, -1000.0, 1000.0);
            this.playerHuddlingRadius = builder.comment(" The radius, in blocks, around which players will add to each other's temperature.").defineInRange("Player Huddling Radius", 1, 0, 10);
            builder.pop();
            builder.push("biomes");
            this.biomeTemperatureMultiplier = builder.comment(" How much a biome's temperature effects are multiplied.").defineInRange("Biome Temperature Multiplier", 16.0, 0.0, 1000.0);
            this.biomeEffectsEnabled = builder.comment(" Whether biomes will have an effect on a player's temperature.").define("Biomes affect Temperature", true);
            this.biomeDrynessMultiplier = builder.comment(new String[]{" How much hot biome's dryness will make nights really cold.", " Affects only dry (minecraft down fall <0.2) and hot biome.", " 1 means no dryness effect; 0.5 means the biome temp will be divided by 2 at the middle of the night."}).defineInRange("Biome's Dryness Multiplier", 0.2, 0.0, 1.0);
            builder.pop();
            builder.comment(new String[]{" The underground effect starts apply at Start Distance to the world surface.", " The underground effect will linearly apply a multiplier on the biome temperature, and averages the time and season temperature effects."}).push("underground");
            this.undergroundBiomeTemperatureMultiplier = builder.comment(" How much a biomes temperature effects are multiplied when player is underground").defineInRange("Underground Biome Temperature Multiplier", 0.8, 0.0, 1000.0);
            this.undergroundEffectStartDistanceToWS = builder.comment(new String[]{" Distance to the World Surface where underground effect will start to be applied.", " Smaller distance, no underground effect are applied."}).defineInRange("Start Distance To World Surface For Underground Effect", 10, 0, 400);
            this.undergroundEffectEndDistanceToWS = builder.comment(new String[]{" Distance to the World Surface where underground effect will be maximal.", " Bigger distance, the underground effect is maximal. Between the Start and End Distance, the increase of underground effect is linear."}).defineInRange("End Distance To World Surface For Underground Effect", 16, 0, 400);
            builder.pop();
            builder.push("weather");
            this.rainTemperatureModifier = builder.comment(new String[]{" How much of an effect rain has on temperature.", " It means that for a value of -2, the body temperature of the player is reduced by 2."}).defineInRange("Rain Temperature Modifier", -2.0, -1000.0, 1000.0);
            this.snowTemperatureModifier = builder.comment(new String[]{" How much of an effect snow has on temperature.", " It means that for a value of -6, the body temperature of the player is reduced by 6."}).defineInRange("Snow Temperature Modifier", -6.0, -1000.0, 1000.0);
            builder.pop();
            builder.comment(" Freeze effect increases while inside snow powder.").push("freeze");
            this.maxFreezeTemperatureModifier = builder.comment(" How much of an effect freeze has on temperature when reaching maximum tick time. Starts at 0 and increases linearly.").defineInRange("Max Freeze Temperature Modifier", -10.0, -1000.0, 1000.0);
            this.maxFreezeEffectTick = builder.comment(" How long in tick before freeze modifier reaches its maximum effect.").defineInRange("Max Freeze Effect Tick", 400, 0, 100000);
            builder.pop();
            builder.push("time");
            this.timeModifier = builder.comment(new String[]{" How much Time has effect on Temperature.", " Maximum effect at noon (positive) and midnight (negative), following a sinusoidal"}).defineInRange("Time Based Temperature Modifier", 2.0, 0.0, Double.POSITIVE_INFINITY);
            this.biomeTimeMultiplier = builder.comment(new String[]{" How strongly time in extreme temperature biomes affect player's temperature.", " Extreme temperature biomes (like snowy taiga, deserts, ...) will multiply the time based temperature by this value, while temperate biome won't be affected by this value, following a linear."}).defineInRange("Biome Time Multiplier", 1.75, 1.0, Double.POSITIVE_INFINITY);
            this.shadeTimeModifier = builder.comment(new String[]{" Staying in the shade or during cloudy weather will reduce player's temperature by this amount based on time of the day (maximum effect at noon, following sinusoidal).", " It means that for a value of -6, the body temperature of the player is reduced by 6.", " Only effective when reaching the threshold and during day time!"}).defineInRange("Shade Time Modifier", -6.0, -1000.0, 1000.0);
            this.shadeTimeModifierThreshold = builder.comment(" Defines when the biome temperature added by the season temperature (if seasons mod loaded) will trigger a shade effect.").defineInRange("Shade Time Modifier Threshold", 9.0, 0.0, 10000.0);
            builder.pop();
            builder.comment(new String[]{" Temperature coat adds temperature effects on armors by using the sewing table.", " Adaptive means the coating will maintain the player's temperature temperate."}).push("coat");
            builder.comment(" Add a heating resistance on armors.").push("heating");
            this.heatingCoat1Modifier = builder.defineInRange("Heating Coat I", 2.0, 0.0, 1000.0);
            this.heatingCoat2Modifier = builder.defineInRange("Heating Coat II", 3.0, 0.0, 1000.0);
            this.heatingCoat3Modifier = builder.defineInRange("Heating Coat III", 4.0, 0.0, 1000.0);
            builder.pop();
            builder.comment(" Add a cooling resistance on armors.").push("cooling");
            this.coolingCoat1Modifier = builder.defineInRange("Cooling Coat I", 2.0, 0.0, 1000.0);
            this.coolingCoat2Modifier = builder.defineInRange("Cooling Coat II", 3.0, 0.0, 1000.0);
            this.coolingCoat3Modifier = builder.defineInRange("Cooling Coat III", 4.0, 0.0, 1000.0);
            builder.pop();
            builder.comment(" Add a temperature resistance on armors that can both heat and cool the player.").push("thermal");
            this.thermalCoat1Modifier = builder.defineInRange("Thermal Coat I", 2.0, 0.0, 1000.0);
            this.thermalCoat2Modifier = builder.defineInRange("Thermal Coat II", 3.0, 0.0, 1000.0);
            this.thermalCoat3Modifier = builder.defineInRange("Thermal Coat III", 4.0, 0.0, 1000.0);
            builder.pop();
            builder.pop();
            builder.push("advanced");
            this.tempInfluenceMaximumDist = builder.comment(" Maximum influence distance, in blocks, where thermal sources will have an effect on temperature.").defineInRange("Temperature Influence Maximum Distance", 20, 1, 40);
            this.tempInfluenceUpDistMultiplier = builder.comment(" How strongly influence distance above the player is reduced for thermal sources to have an effect on temperature.").comment(new String[]{" Example max dist is 10, up mult is 0.75 -> max distance is 10 * 0.75 = 7.5 blocks above the player.", " Logic is that heat goes up, the strength of the heat source above the player is decreased faster with distance."}).defineInRange("Temperature Influence Up Distance Multiplier", 0.75, 0.0, 1.0);
            this.tempInfluenceInWaterDistMultiplier = builder.comment(new String[]{" How strongly influence distance in water is reduced for thermal sources to have an effect on temperature.", "The under water maximum distance is defined as the maximum distance * this value"}).defineInRange("Temperature Influence Outside Distance Multiplier", 0.25, 0.0, 1.0);
            this.tempInfluenceOutsideDistMultiplier = builder.comment(new String[]{" How strongly influence distance outside a structure is reduced for thermal sources to have an effect on temperature.", " The outside maximum distance is defined as the maximum distance * this value"}).defineInRange("Temperature Influence Outside Distance Multiplier", 0.5, 0.0, 1.0);
            builder.comment(new String[]{" The player's temperature will be adjusted at each temperature tick time,", " by an amount of temperature defined between the minimum and the maximum temperature modification adjusted linearly."}).push("temperature-modification");
            this.tempTickTime = builder.comment(" Amount of time in ticks between 2 player temperature modification. The bigger is this value, the more time it takes between temperature adjustments.").defineInRange("Temperature Tick Time", 20, 5, Integer.MAX_VALUE);
            this.maxTemperatureModification = builder.comment(new String[]{" Maximum amount of temperature the player's temperature can be modified at each temperature tick time.", " Correspond to the amount of temperature given when temperature difference is maximum, meaning 40."}).defineInRange("Maximum Temperature Modification", 1.0, 0.1, 2.147483647E9);
            this.minTemperatureModification = builder.comment(new String[]{" Minimum amount of temperature the player's temperature can be modified at each temperature tick time.", " Correspond to the amount of temperature given when there is no temperature difference"}).defineInRange("Minimum Temperature Modification", 0.2, 0.1, 2.147483647E9);
            builder.pop();
            builder.pop();
            builder.push("integration");
            builder.comment(new String[]{" If TerraFirmaCraft is installed, then biome, time, season (if serene seasons installed) and altitude modifiers will be disabled, and TerraFirmaCraft calculation used instead.", " All other modifiers remain to calculate Player temperature."}).push("terrafirmacraft");
            this.tfcItemHeatMultiplier = builder.comment(" How much the heat of the item provided by TerraFirmaCraft is multiplied. 0 deactivates the impact on temperature.").defineInRange("TerraFirmaCraft Item Heat Multiplier", 0.01, 0.0, 1000.0);
            this.tfcTemperatureMultiplier = builder.comment(" How much the temperature given from TerraFirmaCraft is multiplied. 0 deactivates the impact on temperature.").defineInRange("TerraFirmaCraft Temperature Multiplier", 1.0, 0.0, 1000.0);
            builder.pop();
            builder.push("serene-seasons");
            this.sereneSeasonsEnabled = builder.comment(" If Serene Seasons is installed, whether the seasons have an effect on the player's temperature.").define("Serene Seasons Enabled", true);
            this.ssTropicalSeasonsEnabled = builder.comment(new String[]{" If the tropical seasons are disabled, the normal summer-autumn-winter-spring seasons are applied.", " If disabled, dry and wet seasons are applied for hot biomes."}).define("Tropical Seasons Enabled", false);
            this.ssSeasonCardsEnabled = builder.comment(" If season cards are enabled, season cards will appear at every season changes.").define("Season Cards Enabled", false);
            this.ssDefaultSeasonEnabled = builder.comment(new String[]{" If default season is enabled, when serene season defines no season effect in a biome, the normal season temperature will be applied.", " If disabled, when serene season defines no season effects, no season temperature will be applied."}).define("Default Season Enabled", true);
            builder.comment(" Temperature modifiers per season in temperate biomes. The value is reached at the middle of the sub season, and smoothly transition from one to another.").push("temperate");
            builder.push("spring");
            this.ssEarlySpringModifier = builder.defineInRange("Early Spring Modifier", -3.0, -1000.0, 1000.0);
            this.ssMidSpringModifier = builder.defineInRange("Mid Spring Modifier", 0.0, -1000.0, 1000.0);
            this.ssLateSpringModifier = builder.defineInRange("Late Spring Modifier", 3.0, -1000.0, 1000.0);
            builder.pop();
            builder.push("summer");
            this.ssEarlySummerModifier = builder.defineInRange("Early Summer Modifier", 6.0, -1000.0, 1000.0);
            this.ssMidSummerModifier = builder.defineInRange("Mid Summer Modifier", 10.0, -1000.0, 1000.0);
            this.ssLateSummerModifier = builder.defineInRange("Late Summer Modifier", 6.0, -1000.0, 1000.0);
            builder.pop();
            builder.push("autumn");
            this.ssEarlyAutumnModifier = builder.defineInRange("Early Autumn Modifier", 3.0, -1000.0, 1000.0);
            this.ssMidAutumnModifier = builder.defineInRange("Mid Autumn Modifier", 0.0, -1000.0, 1000.0);
            this.ssLateAutumnModifier = builder.defineInRange("Late Autumn Modifier", -3.0, -1000.0, 1000.0);
            builder.pop();
            builder.push("winter");
            this.ssEarlyWinterModifier = builder.defineInRange("Early Winter Modifier", -7.0, -1000.0, 1000.0);
            this.ssMidWinterModifier = builder.defineInRange("Mid Winter Modifier", -12.0, -1000.0, 1000.0);
            this.ssLateWinterModifier = builder.defineInRange("Late Winter Modifier", -7.0, -1000.0, 1000.0);
            builder.pop();
            builder.pop();
            builder.comment(" Temperature modifiers per season in tropical biomes.").push("tropical");
            builder.push("wet-season");
            this.ssEarlyWetSeasonModifier = builder.defineInRange("Early Wet Season Modifier", -1.0, -1000.0, 1000.0);
            this.ssMidWetSeasonModifier = builder.defineInRange("Mid Wet Season Modifier", -5.0, -1000.0, 1000.0);
            this.ssLateWetSeasonModifier = builder.defineInRange("Late Wet Season Modifier", -1.0, -1000.0, 1000.0);
            builder.pop();
            builder.push("dry-season");
            this.ssEarlyDrySeasonModifier = builder.defineInRange("Early Dry Season Modifier", 3.0, -1000.0, 1000.0);
            this.ssMidDrySeasonModifier = builder.defineInRange("Mid Dry Season Modifier", 7.0, -1000.0, 1000.0);
            this.ssLateDrySeasonModifier = builder.defineInRange("Late Dry Season Modifier", 3.0, -1000.0, 1000.0);
            builder.pop();
            builder.pop();
            builder.pop();
            builder.push("ecliptic-seasons");
            this.eclipticSeasonsEnabled = builder.comment(" If Ecliptic Seasons is installed, whether the seasons have an effect on the player's temperature.").define("Ecliptic Seasons Enabled", true);
            builder.comment(" Temperature modifiers per season. Each season is subdivided in 6 sub seasons. The value is reached at the middle of the sub season, and smoothly transition from one to another.").push("temperature");
            this.esSpringModifier = builder.defineList("Spring Modifier", List.of(Double.valueOf(-10.0), Double.valueOf(-7.0), Double.valueOf(-5.0), Double.valueOf(-3.0), Double.valueOf(-1.0), Double.valueOf(0.0)), Config::validateDouble);
            this.esSummerModifier = builder.defineList("Summer Modifier", List.of(Double.valueOf(1.0), Double.valueOf(3.0), Double.valueOf(5.0), Double.valueOf(7.0), Double.valueOf(9.0), Double.valueOf(10.0)), Config::validateDouble);
            this.esAutumnModifier = builder.defineList("Autumn Modifier", List.of(Double.valueOf(9.0), Double.valueOf(7.0), Double.valueOf(5.0), Double.valueOf(3.0), Double.valueOf(1.0), Double.valueOf(0.0)), Config::validateDouble);
            this.esWinterModifier = builder.defineList("Winter Modifier", List.of(Double.valueOf(-1.0), Double.valueOf(-3.0), Double.valueOf(-5.0), Double.valueOf(-7.0), Double.valueOf(-10.0), Double.valueOf(-12.0)), Config::validateDouble);
            builder.pop();
            builder.pop();
            builder.pop();
            builder.pop();
            builder.comment(" Options related to thirst").push("thirst");
            this.dangerousDehydration = builder.comment(" If enabled, players will take damage from the complete dehydration.").define("Dangerous Dehydration", true);
            this.cumulativeThirstEffectDuration = builder.comment(" If enabled, each time the player receives a thirst effect, its duration will be added to the thirst effect duration if already on the player.").define("Cumulative Thirst Effect Duration", true);
            builder.push("exhaustion");
            this.baseThirstExhaustion = builder.comment(" Thirst exhausted every 10 ticks.").defineInRange("Base Thirst Exhaustion", 0.03, 0.0, 1000.0);
            this.sprintingThirstExhaustion = builder.comment(" Thirst exhausted when sprinting, replacing the base thirst exhausted.").defineInRange("Sprinting Thirst Exhaustion", 0.1, 0.0, 1000.0);
            this.onJumpThirstExhaustion = builder.comment(" Thirst exhausted on every jump.").defineInRange("On Jump Thirst Exhaustion", 0.15, 0.0, 1000.0);
            this.onBlockBreakThirstExhaustion = builder.comment(" Thirst exhausted on every block break.").defineInRange("On Block Break Thirst Exhaustion", 0.07, 0.0, 1000.0);
            this.onAttackThirstExhaustion = builder.comment(" Thirst exhausted on every attack.").defineInRange("On Attack Thirst Exhaustion", 0.3, 0.0, 1000.0);
            builder.pop();
            this.dehydrationDamageScaling = builder.comment(" Scaling of the damages dealt when completely dehydrated. Each tick damage will be increased by this value.").defineInRange("Dehydration Damage Scaling", 0.3, 0.0, 1000.0);
            this.thirstEffectModifier = builder.comment(new String[]{" How much thirst exhaustion will be added every 50 ticks when the player suffers from not amplified Thirst Effect.", " The player will suffer Thirst Effect from dirty water for example."}).defineInRange("Thirst Effect Modifier", 0.25, 0.0, 1000.0);
            builder.push("canteen");
            this.selfWateringCanteenEnabled = builder.comment(new String[]{" If enabled, the player can water himself by using the canteen while crouching.", " This will increase the player wetness and remove fire."}).define("Self Watering Canteen Enabled", true);
            this.selfWateringCanteenWetnessIncrease = builder.comment(new String[]{" If Self Watering Canteen and Wetness are enabled, defines how much wetness is added to the player.", " Set this value to 0 to have no wetness added. By default, the maximum wetness is 400."}).defineInRange("Self Watering Canteen Wetness", 400, 0, 10000);
            this.canteenCapacity = builder.comment(" Capacity of the canteen used to store water.").defineInRange("Canteen Capacity", 10, 0, 1000);
            this.largeCanteenCapacity = builder.comment(" Capacity of the large canteen used to store water.").defineInRange("Large Canteen Capacity", 20, 0, 1000);
            this.allowOverridePurifiedWater = builder.comment(" Allow override of purified water stored in canteen with normal water.").define("Allow Override Purified Water", true);
            builder.pop();
            builder.comment(" Allows drinking from lava. Can be used as bauble.").push("nether_chalice");
            this.hydrationLava = builder.comment(" Amount of hydration recovered when drinking from lava.").defineInRange("Lava Hydration", 6, 0, 20);
            this.saturationLava = builder.comment(" Amount of saturation recovered when drinking from lava.").defineInRange("Lava Saturation", 4.0, 0.0, 20.0);
            builder.pop();
            builder.push("juices");
            this.glassBottleLootAfterDrink = builder.comment(" Whether the player retrieves a glass bottle after drinking a juice.").define("Glass Bottle Loot After Drinking A Juice", true);
            builder.pop();
            builder.push("integration");
            builder.push("origins");
            builder.comment(new String[]{" Temperature won't increase while on fire", " Immune to wetness", " Can drink lava"}).push("blazeborn");
            this.hydrationLavaBlazeborn = builder.comment(" Amount of hydration recovered when drinking from lava.").defineInRange("Lava Hydration For Blazeborn", 3, 0, 20);
            this.saturationLavaBlazeborn = builder.comment(" Amount of saturation recovered when drinking from lava.").defineInRange("Lava Saturation For Blazeborn", 1.0, 0.0, 20.0);
            builder.pop();
            builder.comment(new String[]{" Immune to wetness", "Immune to Thirst Effect"}).push("merling");
            builder.pop();
            builder.comment(" Immune to high altitude coldness").push("elytrian");
            builder.pop();
            builder.comment(" Immune to high altitude coldness").push("avian");
            builder.pop();
            builder.comment(" Thirst depletes slightly faster").push("shulk");
            this.extraThirstExhaustionShulk = builder.comment(" Amount of thirst exhaustion added every 20 ticks.").defineInRange("Extra Thirst Exhaustion For Shulk", 0.1, 0.0, 1000.0);
            builder.pop();
            builder.comment(" Thirst depletes slightly faster").push("phantom");
            this.extraThirstExhaustionPhantom = builder.comment(" Amount of thirst exhaustion added every 20 ticks.").defineInRange("Extra Thirst Exhaustion For Phantom", 0.1, 0.0, 1000.0);
            builder.pop();
            builder.pop();
            builder.push("vampirism");
            this.thirstEnabledIfVampire = builder.comment(new String[]{" If Vampirism is installed and if thirst enabled while being a vampire, keep the thirst system in addition to the vampiric one.", " If disabled, the thirst system will be disabled for vampires."}).define("Thirst Enabled If Vampire", false);
            builder.pop();
            builder.pop();
            builder.pop();
            builder.comment(" Options related to health overhaul").push("health-overhaul");
            this.maxAdditionalHealth = builder.comment(" How much of Additional Health a player can accumulate. 2 Heath means a full heart.").defineInRange("Maximum Additional Health", 20.0, 0.0, 10000.0);
            builder.push("shield-health");
            this.maxShieldHealth = builder.comment(new String[]{" How much of Shield Health a player can accumulate. 2 Shield Heath means a full shield.", " Shield Health are lost when the player suffers damages and can't regenerate. Works similarly as the Minecraft Absorption."}).defineInRange("Maximum Shield Health", 20.0, 1.0, 10000.0);
            this.absorptionEffectOverride = builder.comment(new String[]{" Override the absorption effect by a shield health increase of 2.", " The absorption is typically given by the Golden Apple."}).define("Absorption Effect Override", true);
            builder.pop();
            builder.push("heart-loss");
            this.heartsLostOnDeath = builder.comment(" The number of Hearts lost on death.").defineInRange("Hearts Lost On Death", 0, 0, 10000);
            this.permanentHearts = builder.comment(new String[]{" The number of Hearts below which player can't lose hearts upon death.", " The hearts below this limit are de facto Permanent Hearts."}).defineInRange("Permanent Hearts", 10, 1, 10000);
            builder.pop();
            builder.push("broken-hearts").comment(new String[]{" Broken Hearts are an interaction with the localized body damage feature. Enables both feature to have it.", " Broken Hearts are lost hearts when a player's limb is severely injured and it can be recovered by healing the injured limb."});
            this.resilientHeartsWithBrokenHearts = builder.comment(new String[]{" The Resilient Hearts is the number of heart below which Broken Hearts can no longer be added.", " By default, the player has 2 resilient heart, meaning no matter the amount of broken hearts, the player won't go below 2 hearts."}).defineInRange("Minimum Amount Of Player's Heart With Broken Hearts (Broken Heart Resilience)", 2, 1, 10000);
            this.brokenHeartsPerInjuredLimb = builder.comment(" Amount of Broken Hearts added per limbs fully injured.").defineInRange("Added Broken Hearts Per Injured Limb", 0.1, 0.0, 10000.0);
            this.brokenHeartsPerInjuredLimbMode = builder.comment(new String[]{" How broken hearts inflicted per injured limbs are calculated. The total amount will be round down to have an integer amount of broken hearts.", " For example, if the amount per injured limb is 0.1 with mode Player Dynamic and the player has 3 limbs injured, the total amount is 3 * (0.1 * 20), 20 being the default player max health, so 6 broken hearts will be inflicted.", " Accepted values are as follows:", "   SIMPLE - The broken heart amount is a fixed value defined in Broken Hearts Per Injured Limb.", "   PLAYER_DYNAMIC - The broken heart amount is a percentage value of the player max health using the percentage value defined in Broken Hearts Per Injured Limb.", "   LIMB_DYNAMIC - The broken heart amount is a percentage value of the injured limb max health using the percentage value defined in Broken Hearts Per Injured Limb.", " Any other value will default to SIMPLE."}).define("Broken Hearts Per Injured Limb Mode", (Object)"PLAYER_DYNAMIC");
            builder.pop();
            builder.pop();
            builder.comment(new String[]{" Options related to localized body damage", " The damageSourceBodyParts.json allows you to define for specific damage source, the damage spread across specified body parts.", " The damage distribution can either be ONE_OF or ALL. ALL means the damage are equally divided across all body parts."}).push("body-damage");
            this.headCriticalShotMultiplier = builder.comment(" Multiply the damage taken by the player when shot in the head without helmet.").defineInRange("Headshot Multiplier", 2.0, 1.0, 1000.0);
            this.bodyDamageMultiplier = builder.comment(" How much of the hurt player's damage is assigned to the body parts.").defineInRange("Body Damage Multiplier", 1.0, 0.0, 1000.0);
            this.bodyHealthRatioRecoveredFromSleep = builder.comment(" How much health ratio are recovered in all body parts from bed sleeping.").defineInRange("Body Part Health Ratio Recovered", 1.0, 0.0, 1.0);
            this.healthRatioRecoveredFromSleep = builder.comment(" How much health ratio are recovered from bed sleeping.").defineInRange("Health Ratio Recovered", 1.0, 0.0, 1.0);
            this.bodyHealingFoodExhaustion = builder.comment(new String[]{" How much food is exhausted when a limb regenerates based on the amount of health regenerated.", " For each 1 health regenerated, the food is exhausted by this value."}).defineInRange("Body Healing Food Exhaustion", 0.5, 0.0, 1000.0);
            this.minFoodOnBodyHealing = builder.comment(new String[]{" The hunger bar won't drop below this value while body is healing.", " Each hunger icon has a value of 2 in the hunger bar."}).defineInRange("Minimum Food On Body Healing", 0, 0, 1000);
            this.painkillerAddictionDuration = builder.comment(new String[]{" How long in ticks is the Addiction Effect lasting. 0 deactivates the feature.", " The Addiction Effect prevents you from re-using the morphine item."}).defineInRange("Painkiller Addiction Duration", 3600, 0, 100000);
            builder.push("healing-items");
            builder.push("first-aid-supplies");
            this.firstAidSuppliesLimbHealthRegenerated = builder.comment(" The First Aid Supplies regenerate limb health passively, either by holding it or using Curios mod, the most damaged limb first.").defineInRange("First Aid Supplies Limb Health Regenerated", 0.25, 0.0, 1000.0);
            this.firstAidSuppliesLimbRegenerationMode = builder.comment(new String[]{" How a player's limb health regenerated is defined. Accepted values are as follows:", "   SIMPLE - The limb health regenerated is a fixed value defined in First Aid Supplies Limb Health Regenerated.", "   PLAYER_DYNAMIC - The limb health regenerated is a percentage value of the player max health using the percentage value defined in First Aid Supplies Limb Health Regenerated.", "   LIMB_DYNAMIC - The limb health regenerated is a percentage value of the limb max health using the percentage value defined in First Aid Supplies Limb Health Regenerated.", " Any other value will default to SIMPLE."}).define("First Aid Supplies Limb Regeneration Mode", (Object)"LIMB_DYNAMIC");
            this.firstAidSuppliesHealingOverflow = builder.comment(new String[]{" Whether the exceeded limb health regenerated will heal the next most damaged limb.", " Only available for Regeneration Mode SIMPLE or PLAYER_DYNAMIC."}).define("First Aid Supplies Healing Overflow", false);
            this.firstAidSuppliesTickTimer = builder.comment(" How fast in ticks the First Aid Supplies will heal limbs. 20 ticks = 1s").defineInRange("First Aid Supplies Tick Timer", 300, 0, 10000);
            this.firstAidSuppliesExhaustsFood = builder.comment(" Whether the First Aid Supplies exhaust food when healing limbs, such as the other healing items.").define("First Aid Supplies Exhausts Food", true);
            this.firstAidSuppliesBoostedOnEffects = builder.comment(" The First Aid Supplies will heal limbs faster when the player is under one of the mentioned effect.").defineListAllowEmpty("First Aid Supplies Boosted On Effects", List.of("minecraft:regeneration", "farmersdelight:comfort"), Config::validateEffectName);
            this.firstAidSuppliesBoostedTickTimerMultiplier = builder.comment(new String[]{" How much the First Aid Supplies tick timer is multiplied when boosted. ", " A value of 1 would deactivate the speed boost. 0.5 makes the heal twice faster."}).defineInRange("First Aid Supplies Tick Timer Multiplier", 0.75, 0.1, 1.0);
            builder.pop();
            builder.push("healing-herbs");
            this.healingHerbsUseTime = builder.comment(" Item use time in ticks.").defineInRange("Healing Herbs Use Time", 20, 0, 1000);
            this.healingHerbsRegenerationAmplifier = builder.comment(" Regeneration effect amplifier.").defineInRange("Healing Herbs Regeneration Amplifier", 0, 0, 10);
            this.healingHerbsRegenerationTickDuration = builder.comment(" Regeneration effect duration in ticks.").defineInRange("Healing Herbs Regeneration Duration", 60, 0, 10000);
            builder.pop();
            builder.push("plaster");
            this.plasterUseTime = builder.comment(" Item use time in ticks.").defineInRange("Plaster Use Time", 20, 0, 1000);
            this.plasterRegenerationAmplifier = builder.comment(" Regeneration effect amplifier.").defineInRange("Plaster Regeneration Amplifier", 0, 0, 10);
            this.plasterRegenerationTickDuration = builder.comment(" Regeneration effect duration in ticks.").defineInRange("Plaster Regeneration Duration", 120, 0, 10000);
            builder.pop();
            builder.push("bandage");
            this.bandageUseTime = builder.comment(" Item use time in ticks.").defineInRange("Bandage Use Time", 30, 0, 1000);
            this.bandageRegenerationAmplifier = builder.comment(" Regeneration effect amplifier.").defineInRange("Bandage Regeneration Amplifier", 1, 0, 10);
            this.bandageRegenerationTickDuration = builder.comment(" Regeneration effect duration in ticks.").defineInRange("Bandage Regeneration Duration", 120, 0, 10000);
            builder.pop();
            builder.push("tonic");
            this.tonicUseTime = builder.comment(" Item use time in ticks.").defineInRange("Tonic Use Time", 50, 0, 1000);
            this.tonicRegenerationAmplifier = builder.comment(" Regeneration effect amplifier.").defineInRange("Tonic Regeneration Amplifier", 1, 0, 10);
            this.tonicRegenerationTickDuration = builder.comment(" Regeneration effect duration in ticks.").defineInRange("Tonic Regeneration Duration", 140, 0, 10000);
            builder.pop();
            builder.push("medikit");
            this.medikitUseTime = builder.comment(" Item use time in ticks.").defineInRange("Medikit Use Time", 50, 0, 1000);
            this.medikitRegenerationAmplifier = builder.defineInRange("Medikit Regeneration Amplifier", 2, 0, 10);
            this.medikitRegenerationTickDuration = builder.comment(" Regeneration effect duration in ticks.").defineInRange("Medikit Regeneration Duration", 140, 0, 10000);
            builder.pop();
            builder.push("morphine");
            this.morphineUseTime = builder.comment(" Item use time in ticks.").defineInRange("Morphine Use Time", 30, 0, 1000);
            this.morphinePainkillerTickDuration = builder.comment(" Painkiller effect duration in ticks. This effect prevents the player to be affected by broken limbs effects.").defineInRange("Morphine Painkiller Duration", 1800, 0, 10000);
            builder.pop();
            builder.pop();
            builder.push("body-parts-health");
            this.bodyPartHealthMode = builder.comment(new String[]{" How a player's body part health is determined. Accepted values are as follows:", "   SIMPLE - Body parts will have initial fixed values. The body parts health define the health value.", "       In this case, if the 'headPartHeath = 10', the head will have '10' health.", "   DYNAMIC - Body parts will have dynamic values based on the player's max health. In this case, the body parts health is a multiplier of the player's max health.", "       In this case, if the 'headPartHeath = 0.3', the head will have '0.3' * 'player max health' health.", " Any other value will default to SIMPLE."}).define("Body Part Health Mode", (Object)"DYNAMIC");
            this.headPartHealth = builder.defineInRange("Head Part Health", 0.4, 0.0, 1000.0);
            this.armsPartHealth = builder.comment(" Both arms will have this health.").defineInRange("Arms Part Health", 0.4, 0.0, 1000.0);
            this.chestPartHealth = builder.defineInRange("Chest Part Health", 0.6, 0.0, 1000.0);
            this.legsPartHealth = builder.comment(" Both legs will have this health.").defineInRange("Legs Part Health", 0.6, 0.0, 1000.0);
            this.feetPartHealth = builder.comment(" Both feet will have this health.").defineInRange("Feet Part Health", 0.4, 0.0, 1000.0);
            builder.pop();
            builder.push("body-parts-effects");
            builder.comment(new String[]{" Each effect, threshold and amplifier lists must have the same number of items.", " The first effect will be triggered with the first amplifier value when the first threshold is reach."}).push("head");
            this.headPartEffects = builder.comment(" The list of effects that will be triggered when the head is damaged by the percentage of remaining head health defined in the thresholds.").defineListAllowEmpty("Head Part Effects", List.of("legendarysurvivaloverhaul:headache"), Config::validateEffectName);
            this.headPartEffectAmplifiers = builder.comment(new String[]{" The list of amplifiers the effect will have.", " 0 means the basic effect, 1 means the effect is amplified once."}).defineListAllowEmpty("Head Part Effect Amplifiers", List.of(Integer.valueOf(0)), Config::validatePositiveInt);
            this.headPartEffectThresholds = builder.comment(new String[]{" The list of thresholds for which each effect will be triggered. A threshold is a percentage of remaining head health.", " 0 means the head is fully damaged."}).defineListAllowEmpty("Head Part Effect Thresholds", List.of(Double.valueOf(0.2)), Config::validatePercentDouble);
            builder.pop();
            builder.push("arms");
            this.armsPartEffects = builder.defineListAllowEmpty("Arms Part Effects", List.of("minecraft:mining_fatigue"), Config::validateEffectName);
            this.armsPartEffectAmplifiers = builder.defineListAllowEmpty("Arms Part Effect Amplifiers", List.of(Integer.valueOf(0)), Config::validatePositiveInt);
            this.armsPartEffectThresholds = builder.defineListAllowEmpty("Arms Part Effect Thresholds", List.of(Double.valueOf(0.2)), Config::validatePercentDouble);
            this.bothArmsPartEffects = builder.comment(new String[]{" These effects will be triggered when both arms reach the thresholds.", " If a same effect is used with a higher amplifier, the higher prevails (normal Minecraft behaviour)."}).defineListAllowEmpty("Both Arms Part Effects", List.of("minecraft:weakness"), Config::validateEffectName);
            this.bothArmsPartEffectAmplifiers = builder.defineListAllowEmpty("Both Arms Part Effect Amplifiers", List.of(Integer.valueOf(0)), Config::validatePositiveInt);
            this.bothArmsPartEffectThresholds = builder.defineListAllowEmpty("Both Arms Part Effect Thresholds", List.of(Double.valueOf(0.2)), Config::validatePercentDouble);
            builder.pop();
            builder.push("chest");
            this.chestPartEffects = builder.defineListAllowEmpty("Chest Part Effects", List.of("legendarysurvivaloverhaul:vulnerability"), Config::validateEffectName);
            this.chestPartEffectAmplifiers = builder.defineListAllowEmpty("Chest Part Effect Amplifier", List.of(Integer.valueOf(0)), Config::validatePositiveInt);
            this.chestPartEffectThresholds = builder.defineListAllowEmpty("Chest Part Effect Thresholds", List.of(Double.valueOf(0.2)), Config::validatePercentDouble);
            builder.pop();
            builder.push("legs");
            this.legsPartEffects = builder.defineListAllowEmpty("Legs Part Effects", List.of("legendarysurvivaloverhaul:hard_falling"), Config::validateEffectName);
            this.legsPartEffectAmplifiers = builder.defineListAllowEmpty("Legs Part Effect Amplifiers", List.of(Integer.valueOf(0)), Config::validatePositiveInt);
            this.legsPartEffectThresholds = builder.defineListAllowEmpty("Legs Part Effect Thresholds", List.of(Double.valueOf(0.2)), Config::validatePercentDouble);
            this.bothLegsPartEffects = builder.defineListAllowEmpty("Both Legs Part Effects", List.of("legendarysurvivaloverhaul:hard_falling"), Config::validateEffectName);
            this.bothLegsPartEffectAmplifiers = builder.defineListAllowEmpty("Both Legs Part Effect Amplifiers", List.of(Integer.valueOf(1)), Config::validatePositiveInt);
            this.bothLegsPartEffectThresholds = builder.defineListAllowEmpty("Both Legs Part Effect Thresholds", List.of(Double.valueOf(0.2)), Config::validatePercentDouble);
            builder.pop();
            builder.push("feet");
            this.feetPartEffects = builder.defineListAllowEmpty("Feet Part Effects", Collections.singletonList("minecraft:slowness"), Config::validateEffectName);
            this.feetPartEffectAmplifiers = builder.defineListAllowEmpty("Feet Part Effect Amplifiers", Collections.singletonList(0), Config::validatePositiveInt);
            this.feetPartEffectThresholds = builder.defineListAllowEmpty("Feet Part Effect Thresholds", Collections.singletonList(0.2), Config::validatePercentDouble);
            this.bothFeetPartEffects = builder.defineListAllowEmpty("Both Feet Part Effects", Collections.singletonList("minecraft:slowness"), Config::validateEffectName);
            this.bothFeetPartEffectAmplifiers = builder.defineListAllowEmpty("Both Feet Part Effect Amplifiers", Collections.singletonList(1), Config::validatePositiveInt);
            this.bothFeetPartEffectThresholds = builder.defineListAllowEmpty("Both Feet Part Effect Thresholds", Collections.singletonList(0.2), Config::validatePercentDouble);
            builder.pop();
            builder.pop();
            builder.push("integration");
            builder.push("meds_and_herbs");
            this.morphineSyringeApplyPainkillerAddiction = builder.comment(new String[]{" Painkiller Addiction effect prevents the abusive usage of Painkiller effect that prevents all negative effects from limbs.", " Syringe Morphine share the same configuration as Morphine item"}).define("Syringe Morphine Apply Painkiller Addiction", true);
            builder.pop();
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue foodSaturationDisplayed;
        public final ForgeConfigSpec.BooleanValue showVanillaBarAnimationOverlay;
        public final ForgeConfigSpec.EnumValue<TemperatureDisplayEnum> temperatureDisplayMode;
        public final ForgeConfigSpec.IntValue temperatureDisplayOffsetX;
        public final ForgeConfigSpec.IntValue temperatureDisplayOffsetY;
        public final ForgeConfigSpec.IntValue bodyTemperatureDisplayOffsetX;
        public final ForgeConfigSpec.IntValue bodyTemperatureDisplayOffsetY;
        public final ForgeConfigSpec.BooleanValue heatTemperatureOverlay;
        public final ForgeConfigSpec.BooleanValue coldTemperatureOverlay;
        public final ForgeConfigSpec.BooleanValue breathingSoundEnabled;
        public final ForgeConfigSpec.DoubleValue coldBreathEffectThreshold;
        public final ForgeConfigSpec.BooleanValue renderTemperatureInFahrenheit;
        public final ForgeConfigSpec.IntValue wetnessIndicatorOffsetX;
        public final ForgeConfigSpec.IntValue wetnessIndicatorOffsetY;
        public final ForgeConfigSpec.IntValue bodyDamageIndicatorOffsetX;
        public final ForgeConfigSpec.IntValue bodyDamageIndicatorOffsetY;
        public final ForgeConfigSpec.DoubleValue bodyDamageIndicatorRenderHealthLimit;
        public final ForgeConfigSpec.IntValue seasonCardsDisplayOffsetX;
        public final ForgeConfigSpec.IntValue seasonCardsDisplayOffsetY;
        public final ForgeConfigSpec.IntValue seasonCardsSpawnDimensionDelayInTicks;
        public final ForgeConfigSpec.IntValue seasonCardsDisplayTimeInTicks;
        public final ForgeConfigSpec.IntValue seasonCardsFadeInInTicks;
        public final ForgeConfigSpec.IntValue seasonCardsFadeOutInTicks;
        public final ForgeConfigSpec.BooleanValue showHydrationTooltip;
        public final ForgeConfigSpec.BooleanValue mergeHydrationAndSaturationTooltip;
        public final ForgeConfigSpec.BooleanValue thirstSaturationDisplayed;
        public final ForgeConfigSpec.BooleanValue lowHydrationEffect;
        public final ForgeConfigSpec.BooleanValue showHydrationBar;
        public final ForgeConfigSpec.BooleanValue showDrinkPreview;
        public final ForgeConfigSpec.IntValue hydrationBarOffsetX;
        public final ForgeConfigSpec.IntValue hydrationBarOffsetY;
        public final ForgeConfigSpec.BooleanValue appendBrokenShieldHeartsToHealthBar;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{" Options related to the heads up display.", " These options will automatically update upon being saved."}).push("hud");
            builder.push("general");
            this.foodSaturationDisplayed = builder.comment(" If enabled, the food saturation will be rendered on the Food Bar while the player suffers Cold Hunger Effect (secondary temperature effect).").define("Show Food Saturation Bar", true);
            this.showVanillaBarAnimationOverlay = builder.comment(new String[]{" Whether the vanilla animation of the Food bar and Hydration bar is rendered. The bar shakes more the lower they are.", " This mod render a new food bar as a secondary effect of a cold temperature.", " Disable this animation if the temperature secondary effect is enabled to allow a compatibility with other mods rendering the food bar (for example Appleskin)."}).define("Show Vanilla Bar Animation Overlay", true);
            builder.pop();
            builder.push("temperature");
            this.temperatureDisplayMode = builder.comment(new String[]{" How temperature is displayed. Accepted values are as follows:", "    SYMBOL - Display the player's current temperature as a symbol above the hotbar.", "    NONE - Disable the temperature indicator."}).defineEnum("Temperature Display Mode", (Enum)TemperatureDisplayEnum.SYMBOL);
            this.temperatureDisplayOffsetX = builder.comment(" The X and Y offset of the temperature indicator. Set both to 0 for no offset.").defineInRange("Temperature Display X Offset", 0, -10000, 10000);
            this.temperatureDisplayOffsetY = builder.defineInRange("Temperature Display Y Offset", 0, -10000, 10000);
            this.bodyTemperatureDisplayOffsetX = builder.comment(new String[]{" The X and Y offset of the body temperature, shown when thermometer is equipped as a bauble (needs the curios mod).", " Set both to 0 for no offset."}).defineInRange("Body Temperature Display X Offset", 0, -10000, 10000);
            this.bodyTemperatureDisplayOffsetY = builder.defineInRange("Body Temperature Display Y Offset", 0, -10000, 10000);
            this.heatTemperatureOverlay = builder.comment(" If enabled, player will see a foggy effect when the heat is high.").define("Heat Temperature Overlay", true);
            this.coldTemperatureOverlay = builder.comment(" If enabled, player will see a frost effect when the cold is low.").define("Cold Temperature Overlay", true);
            this.breathingSoundEnabled = builder.comment(" If enabled, breathing sound can be heard while player faces harsh temperatures.").define("Breathing Sound Enabled", true);
            this.coldBreathEffectThreshold = builder.comment(" Temperature threshold below which a cold breath effect is rendered by the player. -1000 disable the feature.").defineInRange("Cold Breath Temperature Threshold", 10.0, -1000.0, 1000.0);
            this.renderTemperatureInFahrenheit = builder.comment(" If enabled, render the temperature values in Fahrenheit.").define("Temperature In Fahrenheit", false);
            builder.push("wetness");
            this.wetnessIndicatorOffsetX = builder.comment(" The X and Y offset of the wetness indicator. Set both to 0 for no offset.").defineInRange("Wetness Indicator X Offset", 0, -10000, 10000);
            this.wetnessIndicatorOffsetY = builder.defineInRange("Wetness Indicator Y Offset", 0, -10000, 10000);
            builder.pop();
            builder.pop();
            builder.pop();
            builder.push("body-damage");
            this.bodyDamageIndicatorOffsetX = builder.comment(new String[]{" The X and Y offset of the body damage indicator. Set both to 0 for no offset.", " By default, render next to the inventory bar."}).defineInRange("Body Damage Indicator X Offset", 0, -10000, 10000);
            this.bodyDamageIndicatorOffsetY = builder.defineInRange("Body Damage Indicator Y Offset", 0, -10000, 10000);
            this.bodyDamageIndicatorRenderHealthLimit = builder.comment(new String[]{" Limb health threshold below which the body damage indicator is rendered.", " If set to 1.1, the body damage indicator is always rendered.", " If set to 1.0, the body damage indicator is rendered as soon as a limb is wounded."}).defineInRange("Body Damage Indicator Limb Health Threshold", 1.0, 0.0, 1.1);
            builder.pop();
            builder.push("season-cards");
            this.seasonCardsDisplayOffsetX = builder.comment(new String[]{" The X and Y offset of the season cards. Set both to 0 for no offset.", " By default, render first top quarter vertically and centered horizontally."}).defineInRange("Season Cards Display X Offset", 0, -10000, 10000);
            this.seasonCardsDisplayOffsetY = builder.defineInRange("Season Cards Display Y Offset", 0, -10000, 10000);
            this.seasonCardsSpawnDimensionDelayInTicks = builder.comment(" The delay before rendering the season card at first player spawn or player dimension change.").defineInRange("Season Cards Delay In Ticks", 80, 0, Integer.MAX_VALUE);
            this.seasonCardsDisplayTimeInTicks = builder.comment(" The display time in ticks that the season card will be fully rendered.").defineInRange("Season Cards Display Time In Ticks", 40, 0, Integer.MAX_VALUE);
            this.seasonCardsFadeInInTicks = builder.comment(" The fade in time in ticks that the season card will appear.").defineInRange("Season Cards Fade in In Ticks", 20, 0, Integer.MAX_VALUE);
            this.seasonCardsFadeOutInTicks = builder.comment(" The fade out time in ticks that the season card will disappear.").defineInRange("Season Cards Fade Out In Ticks", 20, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("thirst");
            builder.push("tooltip");
            this.showHydrationTooltip = builder.comment(" If enabled, show the hydration values in the item tooltip.").define("Show Hydration Tooltip", true);
            this.mergeHydrationAndSaturationTooltip = builder.comment(" If enabled, show the hydration and the saturation values on the same line in the tooltip.").define("Merge Hydration And Saturation Tooltip", true);
            builder.pop();
            this.thirstSaturationDisplayed = builder.comment(" Whether the Thirst Saturation is displayed or not.").define("Render the thirst saturation", true);
            this.lowHydrationEffect = builder.comment(" If enabled, player's vision will become blurry when running low on hydration.").define("Low Thirst Effect", true);
            builder.push("hydration-bar");
            this.showHydrationBar = builder.comment(" If enabled, the hydration bar will be displayed.").define("Show Hydration Bar", true);
            this.showDrinkPreview = builder.comment(" If enabled, a preview on hydration bar will be displayed if player holds a drink item.").define("Show Drink Preview", true);
            this.hydrationBarOffsetX = builder.comment(" How much the hydration bar is moved to the right.").defineInRange("Hydration Bar Offset X", 0, -10000, 10000);
            this.hydrationBarOffsetY = builder.comment(" How much the hydration bar is moved to the bottom.").defineInRange("Hydration Bar Offset Y", 0, -10000, 10000);
            builder.pop();
            builder.pop();
            builder.push("health-overhaul");
            this.appendBrokenShieldHeartsToHealthBar = builder.comment(new String[]{" If enabled, will try to append the broken and shield hearts at the end of the Health Bar.", " A compat is made with overflowing-bars mod."}).define("Append Broken/Shield Hearts To Health Bar", true);
            builder.pop();
        }
    }

    public static class Baked {
        public static int routinePacketSync;
        public static boolean hideInfoFromDebug;
        public static boolean naturalRegenerationEnabled;
        public static boolean vanillaFreezeEnabled;
        public static ItemUtil.CompassInfo compassInfoMode;
        public static boolean showCoordinateOnMap;
        public static double initialHealth;
        public static double baseFoodExhaustion;
        public static double sprintingFoodExhaustion;
        public static double onAttackFoodExhaustion;
        public static boolean temperatureEnabled;
        public static int tempTickTime;
        public static double minTemperatureModification;
        public static double maxTemperatureModification;
        public static boolean dangerousHeatTemperature;
        public static boolean dangerousColdTemperature;
        public static double goldFernChance;
        public static boolean temperatureImmunityOnDeathEnabled;
        public static int temperatureImmunityOnDeathTime;
        public static boolean temperatureImmunityOnFirstSpawnEnabled;
        public static int temperatureImmunityOnFirstSpawnTime;
        public static boolean heatTemperatureSecondaryEffects;
        public static boolean coldTemperatureSecondaryEffects;
        public static double heatThirstEffectModifier;
        public static double coldHungerEffectModifier;
        public static boolean biomeEffectsEnabled;
        public static double biomeDrynessMultiplier;
        public static double biomeTemperatureMultiplier;
        public static double undergroundBiomeTemperatureMultiplier;
        public static int undergroundEffectStartDistanceToWS;
        public static int undergroundEffectEndDistanceToWS;
        public static double rainTemperatureModifier;
        public static double snowTemperatureModifier;
        public static double maxFreezeTemperatureModifier;
        public static int maxFreezeEffectTick;
        public static double altitudeModifier;
        public static double timeModifier;
        public static double biomeTimeMultiplier;
        public static double shadeTimeModifier;
        public static double shadeTimeModifierThreshold;
        public static int tempInfluenceMaximumDist;
        public static double tempInfluenceUpDistMultiplier;
        public static double tempInfluenceOutsideDistMultiplier;
        public static double tempInfluenceInWaterDistMultiplier;
        public static double sprintModifier;
        public static double onFireModifier;
        public static double playerHuddlingModifier;
        public static int playerHuddlingRadius;
        public static boolean wetnessEnabled;
        public static List<? extends String> wetnessImmunityMounts;
        public static double wetMultiplier;
        public static int wetnessTickTimer;
        public static int wetnessDecrease;
        public static int wetnessRainIncrease;
        public static int wetnessFluidIncrease;
        public static double heatingCoat1Modifier;
        public static double heatingCoat2Modifier;
        public static double heatingCoat3Modifier;
        public static double coolingCoat1Modifier;
        public static double coolingCoat2Modifier;
        public static double coolingCoat3Modifier;
        public static double thermalCoat1Modifier;
        public static double thermalCoat2Modifier;
        public static double thermalCoat3Modifier;
        public static double tfcItemHeatMultiplier;
        public static double tfcTemperatureMultiplier;
        public static boolean sereneSeasonsEnabled;
        public static boolean ssTropicalSeasonsEnabled;
        public static boolean ssSeasonCardsEnabled;
        public static boolean ssDefaultSeasonEnabled;
        public static double ssEarlySpringModifier;
        public static double ssMidSpringModifier;
        public static double ssLateSpringModifier;
        public static double ssEarlySummerModifier;
        public static double ssMidSummerModifier;
        public static double ssLateSummerModifier;
        public static double ssEarlyAutumnModifier;
        public static double ssMidAutumnModifier;
        public static double ssLateAutumnModifier;
        public static double ssEarlyWinterModifier;
        public static double ssMidWinterModifier;
        public static double ssLateWinterModifier;
        public static double ssEarlyWetSeasonModifier;
        public static double ssMidWetSeasonModifier;
        public static double ssLateWetSeasonModifier;
        public static double earlyDrySeasonModifier;
        public static double midDrySeasonModifier;
        public static double lateDrySeasonModifier;
        public static boolean eclipticSeasonsEnabled;
        public static List<? extends Double> esSpringModifier;
        public static List<? extends Double> esSummerModifier;
        public static List<? extends Double> esAutumnModifier;
        public static List<? extends Double> esWinterModifier;
        public static boolean thirstEnabled;
        public static boolean dangerousDehydration;
        public static boolean cumulativeThirstEffectDuration;
        public static double dehydrationDamageScaling;
        public static double thirstEffectModifier;
        public static double baseThirstExhaustion;
        public static double sprintingThirstExhaustion;
        public static double onJumpThirstExhaustion;
        public static double onBlockBreakThirstExhaustion;
        public static double onAttackThirstExhaustion;
        public static boolean selfWateringCanteenEnabled;
        public static int selfWateringCanteenWetnessIncrease;
        public static int canteenCapacity;
        public static int largeCanteenCapacity;
        public static boolean allowOverridePurifiedWater;
        public static int hydrationLava;
        public static double saturationLava;
        public static boolean glassBottleLootAfterDrink;
        public static int hydrationLavaBlazeborn;
        public static double saturationLavaBlazeborn;
        public static double extraThirstExhaustionShulk;
        public static double extraThirstExhaustionPhantom;
        public static boolean thirstEnabledIfVampire;
        public static boolean healthOverhaulEnabled;
        public static double maxAdditionalHealth;
        public static double maxShieldHealth;
        public static boolean absorptionEffectOverride;
        public static int heartsLostOnDeath;
        public static int permanentHearts;
        public static int resilientHeartsWithBrokenHearts;
        public static double brokenHeartsPerInjuredLimb;
        public static String brokenHeartsPerInjuredLimbMode;
        public static boolean localizedBodyDamageEnabled;
        public static double headCriticalShotMultiplier;
        public static double bodyDamageMultiplier;
        public static double bodyHealthRatioRecoveredFromSleep;
        public static double healthRatioRecoveredFromSleep;
        public static double bodyHealingFoodExhaustion;
        public static int minFoodOnBodyHealing;
        public static int painkillerAddictionDuration;
        public static double firstAidSuppliesLimbHealthRegenerated;
        public static String firstAidSuppliesLimbRegenerationMode;
        public static boolean firstAidSuppliesHealingOverflow;
        public static int firstAidSuppliesTickTimer;
        public static boolean firstAidSuppliesExhaustsFood;
        public static List<? extends String> firstAidSuppliesBoostedOnEffects;
        public static double firstAidSuppliesBoostedTickTimerMultiplier;
        public static String bodyPartHealthMode;
        public static double headPartHealth;
        public static double armsPartHealth;
        public static double chestPartHealth;
        public static double legsPartHealth;
        public static double feetPartHealth;
        public static int healingHerbsUseTime;
        public static int healingHerbsRegenerationAmplifier;
        public static int healingHerbsRegenerationTickDuration;
        public static int plasterUseTime;
        public static int plasterRegenerationAmplifier;
        public static int plasterRegenerationTickDuration;
        public static int bandageUseTime;
        public static int bandageRegenerationAmplifier;
        public static int bandageRegenerationTickDuration;
        public static int tonicUseTime;
        public static int tonicRegenerationAmplifier;
        public static int tonicRegenerationTickDuration;
        public static int medikitUseTime;
        public static int medikitRegenerationAmplifier;
        public static int medikitRegenerationTickDuration;
        public static int morphineUseTime;
        public static int morphinePainkillerTickDuration;
        public static List<? extends String> headPartEffects;
        public static List<? extends Integer> headPartEffectAmplifiers;
        public static List<? extends Double> headPartEffectThresholds;
        public static List<? extends String> armsPartEffects;
        public static List<? extends Integer> armsPartEffectAmplifiers;
        public static List<? extends Double> armsPartEffectThresholds;
        public static List<? extends String> bothArmsPartEffects;
        public static List<? extends Integer> bothArmsPartEffectAmplifiers;
        public static List<? extends Double> bothArmsPartEffectThresholds;
        public static List<? extends String> chestPartEffects;
        public static List<? extends Integer> chestPartEffectAmplifiers;
        public static List<? extends Double> chestPartEffectThresholds;
        public static List<? extends String> legsPartEffects;
        public static List<? extends Integer> legsPartEffectAmplifiers;
        public static List<? extends Double> legsPartEffectThresholds;
        public static List<? extends String> bothLegsPartEffects;
        public static List<? extends Integer> bothLegsPartEffectAmplifiers;
        public static List<? extends Double> bothLegsPartEffectThresholds;
        public static List<? extends String> feetPartEffects;
        public static List<? extends Integer> feetPartEffectAmplifiers;
        public static List<? extends Double> feetPartEffectThresholds;
        public static List<? extends String> bothFeetPartEffects;
        public static List<? extends Integer> bothFeetPartEffectAmplifiers;
        public static List<? extends Double> bothFeetPartEffectThresholds;
        public static boolean morphineSyringeApplyPainkillerAddiction;
        public static TemperatureDisplayEnum temperatureDisplayMode;
        public static int temperatureDisplayOffsetX;
        public static int temperatureDisplayOffsetY;
        public static int bodyTemperatureDisplayOffsetX;
        public static int bodyTemperatureDisplayOffsetY;
        public static boolean heatTemperatureOverlay;
        public static boolean coldTemperatureOverlay;
        public static boolean breathingSoundEnabled;
        public static double coldBreathEffectThreshold;
        public static boolean renderTemperatureInFahrenheit;
        public static boolean foodSaturationDisplayed;
        public static boolean showVanillaBarAnimationOverlay;
        public static int seasonCardsDisplayOffsetX;
        public static int seasonCardsDisplayOffsetY;
        public static int seasonCardsSpawnDimensionDelayInTicks;
        public static int seasonCardsDisplayTimeInTicks;
        public static int seasonCardsFadeInInTicks;
        public static int seasonCardsFadeOutInTicks;
        public static int wetnessIndicatorOffsetX;
        public static int wetnessIndicatorOffsetY;
        public static int bodyDamageIndicatorOffsetX;
        public static int bodyDamageIndicatorOffsetY;
        public static double bodyDamageIndicatorRenderHealthLimit;
        public static boolean showHydrationTooltip;
        public static boolean mergeHydrationAndSaturationTooltip;
        public static boolean thirstSaturationDisplayed;
        public static boolean lowHydrationEffect;
        public static boolean showHydrationBar;
        public static boolean showDrinkPreview;
        public static int hydrationBarOffsetX;
        public static int hydrationBarOffsetY;
        public static boolean appendBrokenShieldHeartsToHealthBar;

        public static void bakeCommon() {
            LegendarySurvivalOverhaul.LOGGER.debug("Load Common configuration from file");
            try {
                hideInfoFromDebug = (Boolean)Config.COMMON.hideInfoFromDebug.get();
                naturalRegenerationEnabled = (Boolean)Config.COMMON.naturalRegenerationEnabled.get();
                routinePacketSync = (Integer)Config.COMMON.routinePacketSync.get();
                vanillaFreezeEnabled = (Boolean)Config.COMMON.vanillaFreezeEnabled.get();
                compassInfoMode = (ItemUtil.CompassInfo)((Object)Config.COMMON.compassInfoMode.get());
                showCoordinateOnMap = (Boolean)Config.COMMON.showCoordinateOnMap.get();
                initialHealth = (Double)Config.COMMON.initialHealth.get();
                baseFoodExhaustion = (Double)Config.COMMON.baseFoodExhaustion.get();
                sprintingFoodExhaustion = (Double)Config.COMMON.sprintingFoodExhaustion.get();
                onAttackFoodExhaustion = (Double)Config.COMMON.onAttackFoodExhaustion.get();
                temperatureEnabled = (Boolean)Config.COMMON.temperatureEnabled.get();
                tempTickTime = (Integer)Config.COMMON.tempTickTime.get();
                minTemperatureModification = (Double)Config.COMMON.minTemperatureModification.get();
                maxTemperatureModification = (Double)Config.COMMON.maxTemperatureModification.get();
                dangerousHeatTemperature = (Boolean)Config.COMMON.dangerousHeatTemperature.get();
                dangerousColdTemperature = (Boolean)Config.COMMON.dangerousColdTemperature.get();
                goldFernChance = (Double)Config.COMMON.goldFernChance.get();
                temperatureImmunityOnDeathEnabled = (Boolean)Config.COMMON.temperatureImmunityOnDeathEnabled.get();
                temperatureImmunityOnDeathTime = (Integer)Config.COMMON.temperatureImmunityOnDeathTime.get();
                temperatureImmunityOnFirstSpawnEnabled = (Boolean)Config.COMMON.temperatureImmunityOnFirstSpawnEnabled.get();
                temperatureImmunityOnFirstSpawnTime = (Integer)Config.COMMON.temperatureImmunityOnFirstSpawnTime.get();
                heatTemperatureSecondaryEffects = (Boolean)Config.COMMON.heatTemperatureSecondaryEffects.get();
                coldTemperatureSecondaryEffects = (Boolean)Config.COMMON.coldTemperatureSecondaryEffects.get();
                heatThirstEffectModifier = (Double)Config.COMMON.heatThirstEffectModifier.get();
                coldHungerEffectModifier = (Double)Config.COMMON.coldHungerEffectModifier.get();
                rainTemperatureModifier = (Double)Config.COMMON.rainTemperatureModifier.get();
                snowTemperatureModifier = (Double)Config.COMMON.snowTemperatureModifier.get();
                maxFreezeTemperatureModifier = (Double)Config.COMMON.maxFreezeTemperatureModifier.get();
                maxFreezeEffectTick = (Integer)Config.COMMON.maxFreezeEffectTick.get();
                undergroundBiomeTemperatureMultiplier = (Double)Config.COMMON.undergroundBiomeTemperatureMultiplier.get();
                undergroundEffectStartDistanceToWS = (Integer)Config.COMMON.undergroundEffectStartDistanceToWS.get();
                undergroundEffectEndDistanceToWS = (Integer)Config.COMMON.undergroundEffectEndDistanceToWS.get();
                altitudeModifier = (Double)Config.COMMON.altitudeModifier.get();
                biomeEffectsEnabled = (Boolean)Config.COMMON.biomeEffectsEnabled.get();
                biomeDrynessMultiplier = (Double)Config.COMMON.biomeDrynessMultiplier.get();
                biomeTemperatureMultiplier = (Double)Config.COMMON.biomeTemperatureMultiplier.get();
                timeModifier = (Double)Config.COMMON.timeModifier.get();
                biomeTimeMultiplier = (Double)Config.COMMON.biomeTimeMultiplier.get();
                shadeTimeModifier = (Double)Config.COMMON.shadeTimeModifier.get();
                shadeTimeModifierThreshold = (Double)Config.COMMON.shadeTimeModifierThreshold.get();
                tempInfluenceMaximumDist = (Integer)Config.COMMON.tempInfluenceMaximumDist.get();
                tempInfluenceUpDistMultiplier = (Double)Config.COMMON.tempInfluenceUpDistMultiplier.get();
                tempInfluenceInWaterDistMultiplier = (Double)Config.COMMON.tempInfluenceInWaterDistMultiplier.get();
                tempInfluenceOutsideDistMultiplier = (Double)Config.COMMON.tempInfluenceOutsideDistMultiplier.get();
                onFireModifier = (Double)Config.COMMON.onFireModifier.get();
                sprintModifier = (Double)Config.COMMON.sprintModifier.get();
                wetnessEnabled = (Boolean)Config.COMMON.wetnessEnabled.get();
                wetnessImmunityMounts = (List)Config.COMMON.wetnessImmunityMounts.get();
                wetMultiplier = (Double)Config.COMMON.wetMultiplier.get();
                wetnessTickTimer = (Integer)Config.COMMON.wetnessTickTimer.get();
                wetnessDecrease = (Integer)Config.COMMON.wetnessDecrease.get();
                wetnessRainIncrease = (Integer)Config.COMMON.wetnessRainIncrease.get();
                wetnessFluidIncrease = (Integer)Config.COMMON.wetnessFluidIncrease.get();
                playerHuddlingModifier = (Double)Config.COMMON.playerHuddlingModifier.get();
                playerHuddlingRadius = (Integer)Config.COMMON.playerHuddlingRadius.get();
                heatingCoat1Modifier = (Double)Config.COMMON.heatingCoat1Modifier.get();
                heatingCoat2Modifier = (Double)Config.COMMON.heatingCoat2Modifier.get();
                heatingCoat3Modifier = (Double)Config.COMMON.heatingCoat3Modifier.get();
                coolingCoat1Modifier = (Double)Config.COMMON.coolingCoat1Modifier.get();
                coolingCoat2Modifier = (Double)Config.COMMON.coolingCoat2Modifier.get();
                coolingCoat3Modifier = (Double)Config.COMMON.coolingCoat3Modifier.get();
                thermalCoat1Modifier = (Double)Config.COMMON.thermalCoat1Modifier.get();
                thermalCoat2Modifier = (Double)Config.COMMON.thermalCoat2Modifier.get();
                thermalCoat3Modifier = (Double)Config.COMMON.thermalCoat3Modifier.get();
                tfcItemHeatMultiplier = (Double)Config.COMMON.tfcItemHeatMultiplier.get();
                tfcTemperatureMultiplier = (Double)Config.COMMON.tfcTemperatureMultiplier.get();
                sereneSeasonsEnabled = (Boolean)Config.COMMON.sereneSeasonsEnabled.get();
                ssTropicalSeasonsEnabled = (Boolean)Config.COMMON.ssTropicalSeasonsEnabled.get();
                ssSeasonCardsEnabled = (Boolean)Config.COMMON.ssSeasonCardsEnabled.get();
                ssDefaultSeasonEnabled = (Boolean)Config.COMMON.ssDefaultSeasonEnabled.get();
                ssEarlySpringModifier = (Double)Config.COMMON.ssEarlySpringModifier.get();
                ssMidSpringModifier = (Double)Config.COMMON.ssMidSpringModifier.get();
                ssLateSpringModifier = (Double)Config.COMMON.ssLateSpringModifier.get();
                ssEarlySummerModifier = (Double)Config.COMMON.ssEarlySummerModifier.get();
                ssMidSummerModifier = (Double)Config.COMMON.ssMidSummerModifier.get();
                ssLateSummerModifier = (Double)Config.COMMON.ssLateSummerModifier.get();
                ssEarlyAutumnModifier = (Double)Config.COMMON.ssEarlyAutumnModifier.get();
                ssMidAutumnModifier = (Double)Config.COMMON.ssMidAutumnModifier.get();
                ssLateAutumnModifier = (Double)Config.COMMON.ssLateAutumnModifier.get();
                ssEarlyWinterModifier = (Double)Config.COMMON.ssEarlyWinterModifier.get();
                ssMidWinterModifier = (Double)Config.COMMON.ssMidWinterModifier.get();
                ssLateWinterModifier = (Double)Config.COMMON.ssLateWinterModifier.get();
                ssEarlyWetSeasonModifier = (Double)Config.COMMON.ssEarlyWetSeasonModifier.get();
                ssMidWetSeasonModifier = (Double)Config.COMMON.ssMidWetSeasonModifier.get();
                ssLateWetSeasonModifier = (Double)Config.COMMON.ssLateWetSeasonModifier.get();
                earlyDrySeasonModifier = (Double)Config.COMMON.ssEarlyDrySeasonModifier.get();
                midDrySeasonModifier = (Double)Config.COMMON.ssMidDrySeasonModifier.get();
                lateDrySeasonModifier = (Double)Config.COMMON.ssLateDrySeasonModifier.get();
                eclipticSeasonsEnabled = (Boolean)Config.COMMON.eclipticSeasonsEnabled.get();
                esSpringModifier = (List)Config.COMMON.esSpringModifier.get();
                esSummerModifier = (List)Config.COMMON.esSummerModifier.get();
                esAutumnModifier = (List)Config.COMMON.esAutumnModifier.get();
                esWinterModifier = (List)Config.COMMON.esWinterModifier.get();
                thirstEnabled = (Boolean)Config.COMMON.thirstEnabled.get();
                dangerousDehydration = (Boolean)Config.COMMON.dangerousDehydration.get();
                cumulativeThirstEffectDuration = (Boolean)Config.COMMON.cumulativeThirstEffectDuration.get();
                dehydrationDamageScaling = (Double)Config.COMMON.dehydrationDamageScaling.get();
                thirstEffectModifier = (Double)Config.COMMON.thirstEffectModifier.get();
                baseThirstExhaustion = (Double)Config.COMMON.baseThirstExhaustion.get();
                sprintingThirstExhaustion = (Double)Config.COMMON.sprintingThirstExhaustion.get();
                onJumpThirstExhaustion = (Double)Config.COMMON.onJumpThirstExhaustion.get();
                onBlockBreakThirstExhaustion = (Double)Config.COMMON.onBlockBreakThirstExhaustion.get();
                onAttackThirstExhaustion = (Double)Config.COMMON.onAttackThirstExhaustion.get();
                selfWateringCanteenEnabled = (Boolean)Config.COMMON.selfWateringCanteenEnabled.get();
                selfWateringCanteenWetnessIncrease = (Integer)Config.COMMON.selfWateringCanteenWetnessIncrease.get();
                canteenCapacity = (Integer)Config.COMMON.canteenCapacity.get();
                largeCanteenCapacity = (Integer)Config.COMMON.largeCanteenCapacity.get();
                allowOverridePurifiedWater = (Boolean)Config.COMMON.allowOverridePurifiedWater.get();
                hydrationLava = (Integer)Config.COMMON.hydrationLava.get();
                saturationLava = (Double)Config.COMMON.saturationLava.get();
                glassBottleLootAfterDrink = (Boolean)Config.COMMON.glassBottleLootAfterDrink.get();
                hydrationLavaBlazeborn = (Integer)Config.COMMON.hydrationLavaBlazeborn.get();
                saturationLavaBlazeborn = (Double)Config.COMMON.saturationLavaBlazeborn.get();
                extraThirstExhaustionShulk = (Double)Config.COMMON.extraThirstExhaustionShulk.get();
                extraThirstExhaustionPhantom = (Double)Config.COMMON.extraThirstExhaustionPhantom.get();
                thirstEnabledIfVampire = (Boolean)Config.COMMON.thirstEnabledIfVampire.get();
                healthOverhaulEnabled = (Boolean)Config.COMMON.healthOverhaulEnabled.get();
                maxAdditionalHealth = (Double)Config.COMMON.maxAdditionalHealth.get();
                maxShieldHealth = (Double)Config.COMMON.maxShieldHealth.get();
                absorptionEffectOverride = (Boolean)Config.COMMON.absorptionEffectOverride.get();
                heartsLostOnDeath = (Integer)Config.COMMON.heartsLostOnDeath.get();
                permanentHearts = (Integer)Config.COMMON.permanentHearts.get();
                resilientHeartsWithBrokenHearts = (Integer)Config.COMMON.resilientHeartsWithBrokenHearts.get();
                brokenHeartsPerInjuredLimb = (Double)Config.COMMON.brokenHeartsPerInjuredLimb.get();
                brokenHeartsPerInjuredLimbMode = (String)Config.COMMON.brokenHeartsPerInjuredLimbMode.get();
                localizedBodyDamageEnabled = (Boolean)Config.COMMON.localizedBodyDamageEnabled.get();
                headCriticalShotMultiplier = (Double)Config.COMMON.headCriticalShotMultiplier.get();
                bodyDamageMultiplier = (Double)Config.COMMON.bodyDamageMultiplier.get();
                bodyHealthRatioRecoveredFromSleep = (Double)Config.COMMON.bodyHealthRatioRecoveredFromSleep.get();
                healthRatioRecoveredFromSleep = (Double)Config.COMMON.healthRatioRecoveredFromSleep.get();
                bodyHealingFoodExhaustion = (Double)Config.COMMON.bodyHealingFoodExhaustion.get();
                minFoodOnBodyHealing = (Integer)Config.COMMON.minFoodOnBodyHealing.get();
                painkillerAddictionDuration = (Integer)Config.COMMON.painkillerAddictionDuration.get();
                firstAidSuppliesLimbHealthRegenerated = (Double)Config.COMMON.firstAidSuppliesLimbHealthRegenerated.get();
                firstAidSuppliesLimbRegenerationMode = (String)Config.COMMON.firstAidSuppliesLimbRegenerationMode.get();
                firstAidSuppliesHealingOverflow = (Boolean)Config.COMMON.firstAidSuppliesHealingOverflow.get();
                firstAidSuppliesTickTimer = (Integer)Config.COMMON.firstAidSuppliesTickTimer.get();
                firstAidSuppliesExhaustsFood = (Boolean)Config.COMMON.firstAidSuppliesExhaustsFood.get();
                firstAidSuppliesBoostedOnEffects = (List)Config.COMMON.firstAidSuppliesBoostedOnEffects.get();
                firstAidSuppliesBoostedTickTimerMultiplier = (Double)Config.COMMON.firstAidSuppliesBoostedTickTimerMultiplier.get();
                healingHerbsUseTime = (Integer)Config.COMMON.healingHerbsUseTime.get();
                healingHerbsRegenerationAmplifier = (Integer)Config.COMMON.healingHerbsRegenerationAmplifier.get();
                healingHerbsRegenerationTickDuration = (Integer)Config.COMMON.healingHerbsRegenerationTickDuration.get();
                plasterUseTime = (Integer)Config.COMMON.plasterUseTime.get();
                plasterRegenerationAmplifier = (Integer)Config.COMMON.plasterRegenerationAmplifier.get();
                plasterRegenerationTickDuration = (Integer)Config.COMMON.plasterRegenerationTickDuration.get();
                bandageUseTime = (Integer)Config.COMMON.bandageUseTime.get();
                bandageRegenerationAmplifier = (Integer)Config.COMMON.bandageRegenerationAmplifier.get();
                bandageRegenerationTickDuration = (Integer)Config.COMMON.bandageRegenerationTickDuration.get();
                tonicUseTime = (Integer)Config.COMMON.tonicUseTime.get();
                tonicRegenerationAmplifier = (Integer)Config.COMMON.tonicRegenerationAmplifier.get();
                tonicRegenerationTickDuration = (Integer)Config.COMMON.tonicRegenerationTickDuration.get();
                medikitUseTime = (Integer)Config.COMMON.medikitUseTime.get();
                medikitRegenerationAmplifier = (Integer)Config.COMMON.medikitRegenerationAmplifier.get();
                medikitRegenerationTickDuration = (Integer)Config.COMMON.medikitRegenerationTickDuration.get();
                morphineUseTime = (Integer)Config.COMMON.morphineUseTime.get();
                morphinePainkillerTickDuration = (Integer)Config.COMMON.morphinePainkillerTickDuration.get();
                bodyPartHealthMode = (String)Config.COMMON.bodyPartHealthMode.get();
                headPartHealth = (Double)Config.COMMON.headPartHealth.get();
                chestPartHealth = (Double)Config.COMMON.chestPartHealth.get();
                armsPartHealth = (Double)Config.COMMON.armsPartHealth.get();
                legsPartHealth = (Double)Config.COMMON.legsPartHealth.get();
                feetPartHealth = (Double)Config.COMMON.feetPartHealth.get();
                headPartEffects = (List)Config.COMMON.headPartEffects.get();
                headPartEffectAmplifiers = (List)Config.COMMON.headPartEffectAmplifiers.get();
                headPartEffectThresholds = (List)Config.COMMON.headPartEffectThresholds.get();
                armsPartEffects = (List)Config.COMMON.armsPartEffects.get();
                armsPartEffectAmplifiers = (List)Config.COMMON.armsPartEffectAmplifiers.get();
                armsPartEffectThresholds = (List)Config.COMMON.armsPartEffectThresholds.get();
                bothArmsPartEffects = (List)Config.COMMON.bothArmsPartEffects.get();
                bothArmsPartEffectAmplifiers = (List)Config.COMMON.bothArmsPartEffectAmplifiers.get();
                bothArmsPartEffectThresholds = (List)Config.COMMON.bothArmsPartEffectThresholds.get();
                chestPartEffects = (List)Config.COMMON.chestPartEffects.get();
                chestPartEffectAmplifiers = (List)Config.COMMON.chestPartEffectAmplifiers.get();
                chestPartEffectThresholds = (List)Config.COMMON.chestPartEffectThresholds.get();
                legsPartEffects = (List)Config.COMMON.legsPartEffects.get();
                legsPartEffectAmplifiers = (List)Config.COMMON.legsPartEffectAmplifiers.get();
                legsPartEffectThresholds = (List)Config.COMMON.legsPartEffectThresholds.get();
                bothLegsPartEffects = (List)Config.COMMON.bothLegsPartEffects.get();
                bothLegsPartEffectAmplifiers = (List)Config.COMMON.bothLegsPartEffectAmplifiers.get();
                bothLegsPartEffectThresholds = (List)Config.COMMON.bothLegsPartEffectThresholds.get();
                feetPartEffects = (List)Config.COMMON.feetPartEffects.get();
                feetPartEffectAmplifiers = (List)Config.COMMON.feetPartEffectAmplifiers.get();
                feetPartEffectThresholds = (List)Config.COMMON.feetPartEffectThresholds.get();
                bothFeetPartEffects = (List)Config.COMMON.bothFeetPartEffects.get();
                bothFeetPartEffectAmplifiers = (List)Config.COMMON.bothFeetPartEffectAmplifiers.get();
                bothFeetPartEffectThresholds = (List)Config.COMMON.bothFeetPartEffectThresholds.get();
                morphineSyringeApplyPainkillerAddiction = (Boolean)Config.COMMON.morphineSyringeApplyPainkillerAddiction.get();
            }
            catch (Exception e) {
                LegendarySurvivalOverhaul.LOGGER.warn("An exception was caused trying to load the common config for Legendary Survival Overhaul");
                LegendarySurvivalOverhaul.LOGGER.warn((Object)e.getStackTrace());
            }
        }

        public static void bakeClient() {
            LegendarySurvivalOverhaul.LOGGER.debug("Load Client configuration from file");
            try {
                temperatureDisplayMode = (TemperatureDisplayEnum)((Object)Config.CLIENT.temperatureDisplayMode.get());
                temperatureDisplayOffsetX = (Integer)Config.CLIENT.temperatureDisplayOffsetX.get();
                temperatureDisplayOffsetY = (Integer)Config.CLIENT.temperatureDisplayOffsetY.get();
                bodyTemperatureDisplayOffsetX = (Integer)Config.CLIENT.bodyTemperatureDisplayOffsetX.get();
                bodyTemperatureDisplayOffsetY = (Integer)Config.CLIENT.bodyTemperatureDisplayOffsetY.get();
                heatTemperatureOverlay = (Boolean)Config.CLIENT.heatTemperatureOverlay.get();
                coldTemperatureOverlay = (Boolean)Config.CLIENT.coldTemperatureOverlay.get();
                breathingSoundEnabled = (Boolean)Config.CLIENT.breathingSoundEnabled.get();
                coldBreathEffectThreshold = (Double)Config.CLIENT.coldBreathEffectThreshold.get();
                renderTemperatureInFahrenheit = (Boolean)Config.CLIENT.renderTemperatureInFahrenheit.get();
                foodSaturationDisplayed = (Boolean)Config.CLIENT.foodSaturationDisplayed.get();
                showVanillaBarAnimationOverlay = (Boolean)Config.CLIENT.showVanillaBarAnimationOverlay.get();
                seasonCardsDisplayOffsetX = (Integer)Config.CLIENT.seasonCardsDisplayOffsetX.get();
                seasonCardsDisplayOffsetY = (Integer)Config.CLIENT.seasonCardsDisplayOffsetY.get();
                seasonCardsSpawnDimensionDelayInTicks = (Integer)Config.CLIENT.seasonCardsSpawnDimensionDelayInTicks.get();
                seasonCardsDisplayTimeInTicks = (Integer)Config.CLIENT.seasonCardsDisplayTimeInTicks.get();
                seasonCardsFadeInInTicks = (Integer)Config.CLIENT.seasonCardsFadeInInTicks.get();
                seasonCardsFadeOutInTicks = (Integer)Config.CLIENT.seasonCardsFadeOutInTicks.get();
                wetnessIndicatorOffsetX = (Integer)Config.CLIENT.wetnessIndicatorOffsetX.get();
                wetnessIndicatorOffsetY = (Integer)Config.CLIENT.wetnessIndicatorOffsetY.get();
                bodyDamageIndicatorOffsetX = (Integer)Config.CLIENT.bodyDamageIndicatorOffsetX.get();
                bodyDamageIndicatorOffsetY = (Integer)Config.CLIENT.bodyDamageIndicatorOffsetY.get();
                bodyDamageIndicatorRenderHealthLimit = (Double)Config.CLIENT.bodyDamageIndicatorRenderHealthLimit.get();
                thirstSaturationDisplayed = (Boolean)Config.CLIENT.thirstSaturationDisplayed.get();
                showHydrationTooltip = (Boolean)Config.CLIENT.showHydrationTooltip.get();
                mergeHydrationAndSaturationTooltip = (Boolean)Config.CLIENT.mergeHydrationAndSaturationTooltip.get();
                lowHydrationEffect = (Boolean)Config.CLIENT.lowHydrationEffect.get();
                showHydrationBar = (Boolean)Config.CLIENT.showHydrationBar.get();
                showDrinkPreview = (Boolean)Config.CLIENT.showDrinkPreview.get();
                hydrationBarOffsetX = (Integer)Config.CLIENT.hydrationBarOffsetX.get();
                hydrationBarOffsetY = (Integer)Config.CLIENT.hydrationBarOffsetY.get();
                appendBrokenShieldHeartsToHealthBar = (Boolean)Config.CLIENT.appendBrokenShieldHeartsToHealthBar.get();
            }
            catch (Exception e) {
                LegendarySurvivalOverhaul.LOGGER.warn("An exception was caused trying to load the client config for Legendary Survival Overhaul.");
                LegendarySurvivalOverhaul.LOGGER.warn((Object)e.getStackTrace());
            }
        }
    }

    public static class Server {
        Server(ForgeConfigSpec.Builder builder) {
        }
    }
}

